/*	alg.h
 *
 *	Detect changes in a video stream.
 *	Copyright 2001 by Jeroen Vreeken (pe1rxq@amsat.org)
 *	This software is distributed under the GNU public license version 2
 *	See also the file 'COPYING'.
 *
 */

#ifndef _INCLUDE_ALG_H
#define _INCLUDE_ALG_H

#include "motion.h"

struct coord {
	int x;
	int y;
};

struct segment {
	struct coord coord;
	int width;
	int height;
	int open;
	int count;
};

struct coord alg_locate_center (struct images *, int width, int height);
void alg_locate (struct coord cent, struct images *, int width, int height);
int alg_diff (struct context *);
int alg_lightswitch (struct context *, int diffs, int dev, int pipe, int mpipe);
int alg_switchfilter (struct context *, int, struct coord *);

#endif /* _INCLUDE_ALG_H */
