/*
 *	draw.c
 *
 *	Routines for drawing text on images
 *
 *	Copyright 2000, Jeroen Vreeken
 *	This program is published under the GNU public license version 2
 *	See also the file 'COPYING'
 *
 *	Based on code from Jan Gyselinck
 */

#include <ctype.h>
#include "motion.h"

struct draw_char {
	char ascii;
	char pix[6][6];
};

struct draw_char draw_table[]= {
	{
		'0',
		{
			{0,0,1,1,1,0},
			{0,1,0,0,1,1},
			{0,1,0,1,0,1},
			{0,1,0,1,0,1},
			{0,1,1,0,0,1},
			{0,0,1,1,1,0}
		}
	},
	{
		'1',	
		{
			{0,0,0,1,0,0},
			{0,0,1,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,1,1,1,0}
		}
	},
	{
		'2',
		{
			{0,0,1,1,0,0},
			{0,1,0,0,1,0},
			{0,0,0,0,1,0},
			{0,0,0,1,0,0},
			{0,0,1,0,0,0},
			{0,1,1,1,1,0}
		}
	},
	{
		'3',
		{
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,0,0,1,1,0},
			{0,0,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,1,1,1,0}
		}
	},
	{
		'4',
		{
			{0,0,0,0,1,0},
			{0,0,0,1,1,0},
			{0,0,1,0,1,0},
			{0,1,1,1,1,1},
			{0,0,0,0,1,0},
			{0,0,0,0,1,0}
		}
	},
	{
		'5',
		{
			{0,1,1,1,1,1},
			{0,1,0,0,0,0},
			{0,1,1,1,1,0},
			{0,0,0,0,0,1},
			{0,0,0,0,0,1},
			{0,1,1,1,1,0}
		}
	},
	{
		'6',
		{
			{0,0,1,1,1,1},
			{0,1,0,0,0,0},
			{0,1,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,1,1,1,0}
		}
	},
	{
		'7',
		{
			{0,1,1,1,1,1},
			{0,0,0,0,0,1},
			{0,0,0,0,1,0},
			{0,0,0,1,0,0},
			{0,0,1,0,0,0},
			{0,0,1,0,0,0}
		}
	},
	{
		'8',
		{
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,1,1,1,0}
		}
	},
	{
		'9',
		{
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,0,1,1,1,1},
			{0,0,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,1,1,1,0}
		}
	},
	{
		':',
		{
			{0,0,1,1,0,0},
			{0,0,1,1,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,1,1,0,0},
			{0,0,1,1,0,0},
		}
	},
	{
		'-',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,1,1,1,1,1},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0}
		}
	},
		{
		'A',
		{
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,1,1,1,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1}
		}
	},
	{
		'B',
		{
			{0,1,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,1,1,1,0}
		}
	},
	{
		'C',
		{
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,0},
			{0,1,0,0,0,0},
			{0,1,0,0,0,1},
			{0,0,1,1,1,0}
		}
	},
	{
		'D',
		{
			{0,1,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,1,1,1,0}
		}
	},
	{
		'E',
		{
			{0,1,1,1,1,1},
			{0,1,0,0,0,0},
			{0,1,1,1,1,0},
			{0,1,0,0,0,0},
			{0,1,0,0,0,0},
			{0,1,1,1,1,1}
		}
	},
	{
		'F',
		{
			{0,1,1,1,1,1},
			{0,1,0,0,0,0},
			{0,1,1,1,1,0},
			{0,1,0,0,0,0},
			{0,1,0,0,0,0},
			{0,1,0,0,0,0}
		}
	},
	{
		'G',
		{
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,0},
			{0,1,0,1,1,1},
			{0,1,0,0,0,1},
			{0,0,1,1,1,0}
		}
	},
	{
		'H',
		{
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,1,1,1,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1}
		}
	},
	{
		'I',
		{
			{0,0,1,1,1,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,1,1,1,0}
		}
	},
	{
		'J',
		{
			{0,0,1,1,1,1},
			{0,0,0,0,1,0},
			{0,0,0,0,1,0},
			{0,0,0,0,1,0},
			{0,1,0,0,1,0},
			{0,0,1,1,0,0}
		}
	},
	{
		'K',
		{
			{0,1,0,0,0,1},
			{0,1,0,0,1,0},
			{0,1,0,1,0,0},
			{0,1,1,1,0,0},
			{0,1,0,0,1,0},
			{0,1,0,0,0,1}
		}
	},
	{
		'L',
		{
			{0,1,0,0,0,0},
			{0,1,0,0,0,0},
			{0,1,0,0,0,0},
			{0,1,0,0,0,0},
			{0,1,0,0,0,0},
			{0,1,1,1,1,0}
		}
	},
	{
		'M',
		{
			{0,1,0,0,0,1},
			{0,1,1,0,1,1},
			{0,1,0,1,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1}
		}
	},
	{
		'N',
		{
			{0,1,0,0,0,1},
			{0,1,1,0,0,1},
			{0,1,0,1,0,1},
			{0,1,0,0,1,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1}
		}
	},
	{
		'O',
		{
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,1,1,1,0}
		}
	},
	{
		'P',
		{
			{0,1,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,1,1,1,0},
			{0,1,0,0,0,0},
			{0,1,0,0,0,0},
			{0,1,0,0,0,0}
		}
	},
	{
		'Q',
		{
			{0,0,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,1,0,1},
			{0,1,0,0,1,1},
			{0,0,1,1,1,1}
		}
	},
	{
		'R',
		{
			{0,1,1,1,1,0},
			{0,1,0,0,0,1},
			{0,1,1,1,1,0},
			{0,1,0,1,0,0},
			{0,1,0,0,1,0},
			{0,1,0,0,0,1}
		}
	},
	{
		'S',
		{
			{0,0,1,1,1,1},
			{0,1,0,0,0,0},
			{0,0,1,1,1,0},
			{0,0,0,0,0,1},
			{0,0,0,0,0,1},
			{0,1,1,1,1,0}
		}
	},
	{
		'T',
		{
			{0,1,1,1,1,1},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0}
		}
	},
	{
		'U',
		{
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,1,1,1,1}
		}
	},
	{
		'V',
		{
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,0,1,0,1,0},
			{0,0,0,1,0,0}
		}
	},
	{
		'W',
		{
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,0,0,1},
			{0,1,0,1,0,1},
			{0,1,1,0,1,1},
			{0,1,0,0,0,1}
		}
	},
	{
		'X',
		{
			{0,1,0,0,0,1},
			{0,0,1,0,1,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,1,0,1,0},
			{0,1,0,0,0,1}
		}
	},
	{
		'Y',
		{
			{0,1,0,0,0,1},
			{0,0,1,0,1,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0},
			{0,0,0,1,0,0}
		}
	},
	{
		'Z',
		{
			{0,1,1,1,1,1},
			{0,0,0,0,1,0},
			{0,0,0,1,0,0},
			{0,0,1,0,0,0},
			{0,1,0,0,0,0},
			{0,1,1,1,1,1}
		}
	},
	{
		' ',
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0}
		}
	},
	{
		0,
		{
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0},
			{0,0,0,0,0,0}
		}
	}
};

int draw_text (char *image, int startx, int starty, int height, int width, char *text, int type)
{
	int i, pos=0, x, y;
	
	if (startx>width/2) {
		startx-=strlen(text)*6;
		if (startx<0)
			startx=0;
	}
	while (text[pos]) {
		if (startx+(pos+1)*6>=width)
			break;
		i=0;
		while (draw_table[i].ascii && draw_table[i].ascii!=toupper(text[pos])) i++;
		for (x=0; x<6; x++) {
			for (y=0; y<6; y++) {
				if (draw_table[i].pix[y][x]) {
					if (type==VIDEO_PALETTE_RGB24) {
						image[(x+startx+pos*6)*3+0+(y+starty+1)*width*3]=0;
						image[(x+startx+pos*6)*3+1+(y+starty+1)*width*3]=0;
						image[(x+startx+pos*6)*3+2+(y+starty+1)*width*3]=0;
						image[(x+startx+pos*6)*3+0+(y+starty-1)*width*3]=0;
						image[(x+startx+pos*6)*3+1+(y+starty-1)*width*3]=0;
						image[(x+startx+pos*6)*3+2+(y+starty-1)*width*3]=0;
						image[(x+startx+pos*6-1)*3+0+(y+starty)*width*3]=0;
						image[(x+startx+pos*6-1)*3+1+(y+starty)*width*3]=0;
						image[(x+startx+pos*6-1)*3+2+(y+starty)*width*3]=0;
						image[(x+startx+pos*6+1)*3+0+(y+starty)*width*3]=0;
						image[(x+startx+pos*6+1)*3+1+(y+starty)*width*3]=0;
						image[(x+startx+pos*6+1)*3+2+(y+starty)*width*3]=0;
						image[(x+startx+pos*6)*3+0+(y+starty)*width*3]=255;
						image[(x+startx+pos*6)*3+1+(y+starty)*width*3]=255;
					} else {
						image[x+startx+pos*6+1+(y+starty)*width]=0;
						image[x+startx+pos*6-1+(y+starty)*width]=0;
						image[x+startx+pos*6+(y+starty+1)*width]=0;
						image[x+startx+pos*6+(y+starty-1)*width]=0;
					}
				}
			}
		}
		for (x=0; x<6; x++) {
			for (y=0; y<6; y++) {
				if (draw_table[i].pix[y][x]) {
					if (type==VIDEO_PALETTE_RGB24) {
						image[(x+startx+pos*6)*3+0+(y+starty)*width*3]=255;
						image[(x+startx+pos*6)*3+1+(y+starty)*width*3]=255;
						image[(x+startx+pos*6)*3+2+(y+starty)*width*3]=255;
					} else {
						image[x+startx+pos*6+(y+starty)*width]=255;
					}
				}
			}
		}
		pos++;
	}
	return 0;
}

