#ifndef _INCLUDE_FFMPEG_H_
#define _INCLUDE_FFMPEG_H_

#ifdef HAVE_FFMPEG
#include <avcodec.h>
#endif

struct ffmpeg {
#ifdef HAVE_FFMPEG
	AVCodecContext *c;
	AVFrame *picture;
	int outbuf_size;
	FILE *f;
	UINT8 *outbuf;
	void *udata;
#else
	int dummy;
#endif
};

void ffmpeg_init(void);
extern struct ffmpeg *ffmpeg_open(char *, unsigned char *, unsigned char *, unsigned char *, int, int, int, int);
extern void ffmpeg_close(struct ffmpeg *);
extern void ffmpeg_put_image(struct ffmpeg *);

#endif /* _INCLUDE_FFMPEG_H_ */
