/*	motion.h
 *
 *	Include file for motion.c
 *      Copyright 2000 by Jeroen Vreeken (pe1rxq@amsat.org)
 *      This software is distributed under the GNU public license version 2
 *      See also the file 'COPYING'.
 *
 */

#ifndef _INCLUDE_MOTION_H
#define _INCLUDE_MOTION_H

/* Includes */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <signal.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/ioctl.h>

#include <linux/videodev.h>

#include <pthread.h>

#ifdef HAVE_MYSQL
#include <mysql/mysql.h>
#endif

#ifdef HAVE_PGSQL
#include <postgresql/libpq-fe.h>
#endif

#include "conf.h"
#include "webcam.h"

/* Default picture settings */
#define DEF_WIDTH       352
#define DEF_HEIGHT      288
#define DEF_QUALITY     75
#define DEF_CHANGES     1500

#define DEF_MAXFRAMERATE	100
#define DEF_NOISELEVEL	32

/* Minimum time between two 'actions' (email, sms, external) */
#define DEF_GAP         60   /* 1 minutes */
#define DEF_MAXMPEGTIME     3600 /* 60 minutes */

#define DEF_FFMPEG_BPS	400000

#define DEBUG 0

/* date/time drawing, draw.c */
int draw_text (char *image, int startx, int starty, int height, int width, char *text, int type);

struct images {
	unsigned char *new;
	unsigned char *ref;
	unsigned char *out;
	unsigned char *mask;
	int width;
	int height;
	int type;
	int size;
	int motionsize;
};

#include "track.h"

/*
	these used to be global variables but now each thread will have its
	own context
 */
struct context {
	struct config conf;
	struct images imgs;
	struct trackoptions track;

	int threadnr;
	int daemon;

	int snapshot;
	int makemovie;
	int finish;
	int alarmtime;

	int event_nr;
	int prev_event;

	int shots;
	struct tm *currenttime;
	time_t currenttimep;
	time_t lasttime;
	time_t eventtime;
	time_t lastshot;

	char timestamp[255];
	char datestamp[255];

	int lastrate;
	int filesc;
	int filesmc;
	char **files;
	char **filesm;
	int *filesrate;
	int *filesmrate;
	int moved;
	int switched;

	struct webcam webcam;

#ifdef HAVE_MYSQL
	MYSQL *database;
#endif
#ifdef HAVE_PGSQL
	PGconn *database_pg;
#endif
#ifdef HAVE_FFMPEG
	struct ffmpeg *ffmpeg_new;
	struct ffmpeg *ffmpeg_motion;
	struct ffmpeg *ffmpeg_timelaps;
#endif
};

#endif /* _INCLUDE_MOTION_H */
