/*	alg.h
 *
 *	Detect changes in a video stream.
 *	Copyright 2001 by Jeroen Vreeken (pe1rxq@amsat.org)
 *	This software is distributed under the GNU public license version 2
 *	See also the file 'COPYING'.
 *
 */

#ifndef _INCLUDE_ALG_H
#define _INCLUDE_ALG_H

#include "motion.h"

struct coord {
	int x;
	int y;
	int width;
	int height;
};

struct segment {
	struct coord coord;
	int width;
	int height;
	int open;
	int count;
};

struct predict {
	int length;
	int x;
	int y;
	int width;
	int height;
	int dx;
	int dy;
	int diffs;
};

struct predict_set {
	char *filename;
	char *name;
	struct predict_set *next;
	struct predict max;
	struct predict min;
};

struct coord alg_locate_center (struct images *, int width, int height);
void alg_locate (struct coord *, struct images *, int width, int height, char *);
int alg_diff (struct context *, char *);
int alg_diff_standard (struct context *, char *);
int alg_lightswitch (struct context *, int diffs);
int alg_switchfilter (struct context *, int, struct coord *, char *);
void alg_predict (struct coord *, struct context *, int, int);
void alg_predict_result (struct context *, char *);
void alg_noise_tune (struct context *, char *new);
void alg_threshold_tune (struct context *, int, int);
int alg_despeckle (struct context *);

#endif /* _INCLUDE_ALG_H */
