//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Plugin "Tips of the day"
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef TIPS_H
#define TIPS_H

#include <QObject>
#include <QList>
#include "plugininterface.h"

class QWidget;
class QDialog;
class QDockWidget;
class QTextBrowser;
class QAction;
class QPushButton;
class QCheckBox;

struct Tip
{
	QString tipContent;
	int tipIndex;
	Tip(const QString& content,int index) {
		tipContent = content;
		tipIndex = index;
	}
};

typedef QList<Tip *> TipsList;

class TipsDialog : public QObject, public MountManagerPlugin
{
	Q_OBJECT
	Q_INTERFACES(MountManagerPlugin)
	private slots:
		void show();
		void next();
		void saveSettings();
	private:
		QDialog *mainWidget;
		Actions actions;
		QTextBrowser *textBrowser;
		QPushButton *nextButton;
		QPushButton *backButton;
		QPushButton *closeButton;
		QCheckBox *showOnStartup;

		QString documentationPath;
		QString language;
		TipsList tips;
		QList<int> watchedTipsIndexes;

		int randomIndex();
		void loadSettings();
	public:
		TipsDialog(QWidget *parent = 0);
		~TipsDialog();

		void setParent(QObject *parent);

		const QString pluginName() const;
		const QString pluginDescription() const;
		
		QDialog* dialog() const;
		QDockWidget* dockWidget() const;
		QMenu* menu() const;
		QToolBar* toolBar() const;
		
		Actions menuActions() const;
};

#endif
