//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef CENTRALWIDGET_H
#define CENTRALWIDGET_H

#include <QtGui/QSplitter>
#include <QtCore/QMap>

class DiskCore;
class QVBoxLayout;
class TreeWidget;
class QTreeWidgetItem;
class QPushButton;
class QStackedWidget;
class QScrollArea;
class QHBoxLayout;
class DiskDevice;
class MessageBar;
class QCheckBox;
class QAction;
class DiskWidget;
class VolumeWidget;
class SwapWidget;
class QComboBox;
class InfoButton;
class WidgetForMount;
class PopupWindow;
class QLineEdit;

struct Device {
	QTreeWidgetItem *treeWidgetItem;
	DiskDevice *diskDevice;

	DiskWidget *diskWidget;
	VolumeWidget *volumeWidget;
	SwapWidget *swapWidget;

	int index;
};
		
class CentralWidget : public QSplitter
{
	Q_OBJECT
	private slots:
		void deviceAdded(DiskDevice *addedDevice);
		void removeDevice(DiskDevice *removedDevice);
		// If all message bars is hidden, don't show area of them
		void checkMessageBars();
		void hideOrShowSettingsWidget();
		void showMenu();
		void itemChanged(QTreeWidgetItem *current,QTreeWidgetItem *previous);
		void mount(DiskDevice *device = 0);
		void unmount(DiskDevice *device = 0);
		void setAutomount();
		void setFilter(const QString& filter);
	public slots:
		void showInformation(const QString &informationContent);
		void showWarning(const QString &warningContent);
		void showError(const QString &errorContent);
		void updateCurrentFstabContent();
	signals:
		void showTrayMessage(const QString& title,const QString& message);
		void setAutomountSignal(DiskDevice *device,VolumeWidget *deviceWidget);
		void currentDeviceFsChanged(const QString& currentDeviceFs);
		void currentFstabContentChanged(const QString& currentFstabContent);
		// Emit after showing of Main window
		void started();
		// Emit after quit
		void finished();
	private:
		DiskCore *core;
		QList<Device *> devices;
		QList<MessageBar *> messageBars;

		PopupWindow *popupWindow;

		QAction *mountAction;
		QAction *unmountAction;
		QAction *setAutomountAction;

		QWidget *leftWidget;
		QVBoxLayout *leftWidgetLayout;
		TreeWidget *treeWidget;
		QWidget *settingsWidget;
		QVBoxLayout *settingsWidgetLayout;
		QCheckBox *showTrayMessages;
		QComboBox *format;
		InfoButton *formatInfoButton;
		QLineEdit *devicesFilter;
		QPushButton *filterButton;
		
		QPushButton *settingsButton;
		QHBoxLayout *settingsButtonLayout;
		
		QWidget *rightWidget;
		QVBoxLayout *rightWidgetLayout;
		QStackedWidget *stackedWidget;
		QScrollArea *messageBarsArea;
		QWidget *areaWidget;
		QVBoxLayout *areaWidgetLayout;
		WidgetForMount *mountWidget;
		QSplitter *rightSplitter;

		QString currentFstabContent;

		// Return item of tree widget, which is the parent for childDevice
		QTreeWidgetItem *parentItemForDevice(DiskDevice *childDevice);
		inline DiskDevice *parentForDevice(DiskDevice *childDevice);
		inline DiskDevice *currentDiskDevice();
		inline Device *currentDevice();
		inline Device *deviceByItem(QTreeWidgetItem *item);
		inline QList<Device *> childsForDevice(DiskDevice *parentDevice);
		// Create message bar with messageContent
		void showMessage(int messageType,const QString &messageContent);
		void addDevice(DiskDevice *addedDevice);
	public:
		CentralWidget(DiskCore *core,PopupWindow *popup);
		~CentralWidget();

		QList<QAction *> actions() const;

		QString currentFstabText(bool warn = true);
				
		void saveSettings();
		void loadSettings();
		void emitSignalsForPlugins();
};

#endif
