//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#include <QtGui/QSplitter>
#include <QtGui/QListWidget>
#include <QtGui/QVBoxLayout>
#include <QtGui/QHBoxLayout>
#include <QtGui/QPushButton>
#include <QtGui/QTextBrowser>
#include <QtGui/QIcon>
#include <QtGui/QDesktopServices>
#include <QtCore/QSettings>
#include <QtCore/QDir>
#include <QtCore/QLocale>
#include "manual.h"
#include "const.h"

#include <QDebug>

Manual::Manual(QWidget *parent) : QDialog(parent) {
	
	language = QLocale().name();
	language = language.remove(language.indexOf("_"),language.length());
	
	backwardButton = new QPushButton;
	backwardButton->setIcon(QIcon(ICONS_PATH"backward.png"));
	backwardButton->setEnabled(false);
	
	forwardButton = new QPushButton;
	forwardButton->setIcon(QIcon(ICONS_PATH"forward.png"));
	forwardButton->setEnabled(false);
	
	reloadButton = new QPushButton;
	reloadButton->setIcon(QIcon(ICONS_PATH"reload.png"));
	
	closeButton = new QPushButton(tr("Close"));
	
	QHBoxLayout *topLayout = new QHBoxLayout;
	topLayout->addWidget(backwardButton);
	topLayout->addWidget(forwardButton);
	topLayout->addWidget(reloadButton);
	topLayout->addStretch();
		
	QHBoxLayout *bottomLayout = new QHBoxLayout;
	bottomLayout->addStretch();
	bottomLayout->addWidget(closeButton);
	
	listWidget = new QListWidget;
	listWidget->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	
	textBrowser = new QTextBrowser;
		
	mainWidget = new QSplitter;
	mainWidget->addWidget(listWidget);
	mainWidget->addWidget(textBrowser);
	mainWidget->setCollapsible(0,false);
	mainWidget->setCollapsible(1,false);
	mainWidget->setStretchFactor(1,1);
	
	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addLayout(topLayout);
	mainLayout->addWidget(mainWidget);
	mainLayout->addLayout(bottomLayout);
	
	setLayout(mainLayout);
	setWindowIcon(QIcon(ICONS_PATH"manual.png"));
	setWindowTitle(tr("Documentation"));
	
	// Connections
	connect(closeButton,SIGNAL(clicked()),this,SLOT(hide()));
	connect(listWidget,SIGNAL(currentItemChanged(QListWidgetItem*,QListWidgetItem*)),this,SLOT(changePage(QListWidgetItem*,QListWidgetItem*)));
	connect(reloadButton,SIGNAL(clicked()),textBrowser,SLOT(reload()));
	connect(backwardButton,SIGNAL(clicked()),textBrowser,SLOT(backward()));
	connect(forwardButton,SIGNAL(clicked()),textBrowser,SLOT(forward()));
	connect(textBrowser,SIGNAL(backwardAvailable(bool)),backwardButton,SLOT(setEnabled(bool)));
	connect(textBrowser,SIGNAL(forwardAvailable(bool)),forwardButton,SLOT(setEnabled(bool)));
	connect(textBrowser,SIGNAL(sourceChanged(const QUrl&)),this,SLOT(sourceChangedSlot(const QUrl&)));

	// If documentation with user language doesn't exist - show english
	if (!QDir(QString(DOC_PATH) + language).exists())
		language = "en";
	
	addPoint(tr("About the program"),QString(DOC_PATH) + language + "/Information/more_about_program.html");
	addPoint(tr("Changelogs"),QString(DOC_PATH) + language + "/Information/changelog.html");
	addPoint(tr("Bugs in the program"),QString(DOC_PATH) + language + "/Information/bugs.html");
	addPoint(tr("Usage MountManager"),QString(DOC_PATH) + language + "/Information/usage.html");
	addPoint(tr("Documentation about file system"),QString(DOC_PATH) + language + "/FileSystems/index.html");
	addPoint(tr("General information"),QString(DOC_PATH) + language + "/General/index.html");
	addPoint(tr("License"),QString(DOC_PATH) + language + "/Information/license.html");
	addPoint(tr("Web links"),QString(DOC_PATH) + language + "/Information/links.html");
	addPoint(tr("Authors"),QString(DOC_PATH) + language + "/Information/authors.html");
	addPoint(tr("Plugins API"),QString(DOC_PATH) + language + "/Information/plugins_api.html");
	listWidget->setCurrentRow(0);
}

Manual::~Manual() {
	delete backwardButton;
	delete forwardButton;
	delete reloadButton;
	delete closeButton;
	delete textBrowser;
	delete listWidget;
	delete mainWidget;
}

void Manual::addPoint(const QString& title,const QString& path) {
	QListWidgetItem *newItem = new QListWidgetItem(title,listWidget);
	newItem->setData(1,path);
	listWidget->addItem(newItem);
}

void Manual::changePage(QListWidgetItem *currentItem,QListWidgetItem *previousItem) {
	if (currentItem == 0)
		currentItem = previousItem;
	textBrowser->setSource(QUrl(currentItem->data(1).toString()));
}

void Manual::saveSettings() {
	QSettings settings(ORGANIZATION,PROGRAM_NAME);
	settings.setValue("Manual/State",mainWidget->saveState());
	settings.setValue("Manual/Size",size());
}

void Manual::loadSettings() {
	QSettings settings(ORGANIZATION,PROGRAM_NAME);
	mainWidget->restoreState(settings.value("Manual/State",QByteArray()).toByteArray());
	resize(settings.value("Manual/Size",QSize(800,500)).toSize());
}

void Manual::sourceChangedSlot(const QUrl& newSource) {
	QString url = newSource.toString();
	// If url contains http then it's link to web
	if (url.contains("http"))
		QDesktopServices::openUrl(newSource);
	for (int i = 0; i < listWidget->count(); i++)
		if (listWidget->item(i)->data(1).toString() == url) {
			listWidget->setCurrentRow(i);
			break;
		}
}
