//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef MESSAGEBAR_H
#define MESSAGEBAR_H

#include <QWidget>
#include <QList>

class QPushButton;
class QLabel;
class QMenu;
class QAction;
class QCheckBox;
class DiskDevice;
class QVBoxLayout;

class MessageBar : public QWidget
{
	Q_OBJECT
	signals:
		void mountSignal(DiskDevice *);
		void unmountSignal(DiskDevice *);
		// If message bar is shown, hidden or created(object)
		void activated();
	private slots:
		void mountSlot();
		void unmountSlot();
		void menuShown();
	private:
		QPushButton *hideButton;
		QPushButton *actionsButton;
		QLabel *iconLabel;
		QLabel *textLabel;
		QMenu *actionsMenu;

		QVBoxLayout *mainLayout;

		QAction *mountAction;
		QAction *unmountAction;
		QAction *ignoreAction;
		QAction *setFixedFileSystemAction;
		QAction *dontShowThisMessageAction;

		DiskDevice *deviceVar;
	public:
		MessageBar(QWidget *parent = 0);
		~MessageBar();

		// To define what messages bar of what device set it
		void setDevice(DiskDevice *device);
		
		DiskDevice *device() const;

		enum MessageTypes { Information = 0, Warning, Error };
		enum ActionsTypes { Mount = 0, UnMount, Ignore, DontShowThisMessageAgain };

		void addAction(int actionType);
		void addAction(QAction *newAction);
		
		// Overloaded functions
		void setMessage(const QIcon& icon,const QString& text);
		void setMessage(int messageType,const QString& text);
	protected:
		void showEvent(QShowEvent *event);
		void hideEvent(QHideEvent *event);
};

#endif
