//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#include <QtGui/QLabel>
#include <QtGui/QCheckBox>
#include <QtGui/QGridLayout>
#include <QtCore/QVariant>
#include "../core/diskoptionsparser.h"
#include "permissionswidget.h"

PermissionsWidget::PermissionsWidget(Option *opt) {
	option = opt;

	readLabel = new QLabel(tr("Read"));
	writeLabel = new QLabel(tr("Write"));
	executeLabel = new QLabel(tr("Execute"));
	
	ownerLabel = new QLabel(tr("Owner of created file can"));
	ownerRead = new QCheckBox;
	ownerWrite = new QCheckBox;
	ownerExecute = new QCheckBox;

	groupLabel = new QLabel(tr("Group of owner can"));
	groupRead = new QCheckBox;
	groupWrite = new QCheckBox;
	groupExecute = new QCheckBox;

	otherLabel = new QLabel(tr("Others can"));
	otherRead = new QCheckBox;
	otherWrite = new QCheckBox;
	otherExecute = new QCheckBox;

	connect(ownerRead,SIGNAL(clicked()),this,SIGNAL(permissionsChanged()));
	connect(ownerWrite,SIGNAL(clicked()),this,SIGNAL(permissionsChanged()));
	connect(ownerExecute,SIGNAL(clicked()),this,SIGNAL(permissionsChanged()));
	connect(groupRead,SIGNAL(clicked()),this,SIGNAL(permissionsChanged()));
	connect(groupWrite,SIGNAL(clicked()),this,SIGNAL(permissionsChanged()));
	connect(groupExecute,SIGNAL(clicked()),this,SIGNAL(permissionsChanged()));
	connect(otherRead,SIGNAL(clicked()),this,SIGNAL(permissionsChanged()));
	connect(otherWrite,SIGNAL(clicked()),this,SIGNAL(permissionsChanged()));
	connect(otherExecute,SIGNAL(clicked()),this,SIGNAL(permissionsChanged()));
	
	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->addWidget(readLabel,0,1);
	mainLayout->addWidget(writeLabel,0,2);
	mainLayout->addWidget(executeLabel,0,3);
	
	mainLayout->addWidget(ownerLabel,1,0);
	mainLayout->addWidget(ownerRead,1,1);
	mainLayout->addWidget(ownerWrite,1,2);
	mainLayout->addWidget(ownerExecute,1,3);

	mainLayout->addWidget(groupLabel,2,0);
	mainLayout->addWidget(groupRead,2,1);
	mainLayout->addWidget(groupWrite,2,2);
	mainLayout->addWidget(groupExecute,2,3);

	mainLayout->addWidget(otherLabel,3,0);
	mainLayout->addWidget(otherRead,3,1);
	mainLayout->addWidget(otherWrite,3,2);
	mainLayout->addWidget(otherExecute,3,3);

	if (option->maximumValue == "666") {
		ownerExecute->hide();
		groupExecute->hide();
		otherExecute->hide();
		executeLabel->hide();
	}

	setTitle(option->optionTitle);

	setCode("777");
	currentCode = "777";
	setLayout(mainLayout);
}

PermissionsWidget::~PermissionsWidget() {
	delete readLabel;
	delete writeLabel;
	delete executeLabel;
	
	delete ownerLabel;
	delete ownerRead;
	delete ownerWrite;
	delete ownerExecute;

	delete groupLabel;
	delete groupRead;
	delete groupWrite;
	delete groupExecute;

	delete otherLabel;
	delete otherRead;
	delete otherWrite;
	delete otherExecute;
}

void PermissionsWidget::setCode(const QString& code) {
	
	if (code.length() != 3)
		return;

	int ownerValue = code[0].digitValue();

	if (ownerValue == 7) {
			ownerRead->setChecked(true);
			ownerWrite->setChecked(true);
			ownerExecute->setChecked(true);
	} else if (ownerValue == 6) {
			ownerRead->setChecked(true);
			ownerWrite->setChecked(true);
			ownerExecute->setChecked(false);
	} else if (ownerValue == 5) {
			ownerRead->setChecked(true);
			ownerWrite->setChecked(false);
			ownerExecute->setChecked(true);
	} else if (ownerValue == 4) {
			ownerRead->setChecked(true);
			ownerWrite->setChecked(false);
			ownerExecute->setChecked(false);
	} else if (ownerValue == 3) {
			ownerRead->setChecked(false);
			ownerWrite->setChecked(true);
			ownerExecute->setChecked(true);
	} else if (ownerValue == 2) {
			ownerRead->setChecked(false);
			ownerWrite->setChecked(true);
			ownerExecute->setChecked(false);
	} else if (ownerValue == 1) {
			ownerRead->setChecked(false);
			ownerWrite->setChecked(false);
			ownerExecute->setChecked(true);
	} else if (ownerValue == 0) {
			ownerRead->setChecked(false);
			ownerWrite->setChecked(false);
			ownerExecute->setChecked(false);
	}


	int groupValue = code[1].digitValue();

	if (groupValue == 7) {
			groupRead->setChecked(true);
			groupWrite->setChecked(true);
			groupExecute->setChecked(true);
	} else if (groupValue == 6) {
			groupRead->setChecked(true);
			groupWrite->setChecked(true);
			groupExecute->setChecked(false);
	} else if (groupValue == 5) {
			groupRead->setChecked(true);
			groupWrite->setChecked(false);
			groupExecute->setChecked(true);
	} else if (groupValue == 4) {
			groupRead->setChecked(true);
			groupWrite->setChecked(false);
			groupExecute->setChecked(false);
	} else if (groupValue == 3) {
			groupRead->setChecked(false);
			groupWrite->setChecked(true);
			groupExecute->setChecked(true);
	} else if (groupValue == 2) {
			groupRead->setChecked(false);
			groupWrite->setChecked(true);
			groupExecute->setChecked(false);
	} else if (groupValue == 1) {
			groupRead->setChecked(false);
			groupWrite->setChecked(false);
			groupExecute->setChecked(true);
	} else if (groupValue == 0) {
			groupRead->setChecked(false);
			groupWrite->setChecked(false);
			groupExecute->setChecked(false);
	}


	int otherValue = code[2].digitValue();

	if (otherValue == 7) {
			otherRead->setChecked(true);
			otherWrite->setChecked(true);
			otherExecute->setChecked(true);
	} else if (otherValue == 6) {
			otherRead->setChecked(true);
			otherWrite->setChecked(true);
			otherExecute->setChecked(false);
	} else if (otherValue == 5) {
			otherRead->setChecked(true);
			otherWrite->setChecked(false);
			otherExecute->setChecked(true);
	} else if (otherValue == 4) {
			otherRead->setChecked(true);
			otherWrite->setChecked(false);
			otherExecute->setChecked(false);
	} else if (otherValue == 3) {
			otherRead->setChecked(false);
			otherWrite->setChecked(true);
			otherExecute->setChecked(true);
	} else if (otherValue == 2) {
			otherRead->setChecked(false);
			otherWrite->setChecked(true);
			otherExecute->setChecked(false);
	} else if (otherValue == 1) {
			otherRead->setChecked(false);
			otherWrite->setChecked(false);
			otherExecute->setChecked(true);
	} else if (otherValue == 0) {
			otherRead->setChecked(false);
			otherWrite->setChecked(false);
			otherExecute->setChecked(false);
	}
}

QString& PermissionsWidget::code() {
	int ownerValue = 0;
	int groupValue = 0;
	int otherValue = 0;
		
	if (ownerRead->isChecked())
		ownerValue += 4;
	if (ownerWrite->isChecked())
		ownerValue += 2;
	if (option->maximumValue != "666" && ownerExecute->isChecked())
		ownerValue += 1;

	if (groupRead->isChecked())
		groupValue += 4;
	if (groupWrite->isChecked())
		groupValue += 2;
	if (option->maximumValue != "666" && groupExecute->isChecked())
		groupValue += 1;

	if (otherRead->isChecked())
		otherValue += 4;
	if (otherWrite->isChecked())
		otherValue += 2;
	if (option->maximumValue != "666" && otherExecute->isChecked())
		otherValue += 1;

	currentCode = QVariant(ownerValue).toString() + QVariant(groupValue).toString() + QVariant(otherValue).toString();
	return currentCode;
}

QString PermissionsWidget::codeForFstab() {
	return option->optionValues[0]->text + code();
}

bool PermissionsWidget::isDefaultValue() {
	if (code() != option->maximumValue)
		return false;
	return true;
}
