//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#include <QToolButton>
#include <QApplication>
#include <QDesktopWidget>
#include <QTextBrowser>
#include <QLabel>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QCursor>
#include "popupwindow.h"
#include "const.h"

PopupWindow::PopupWindow(QWidget *parent) : QDialog(parent) {

	setWindowFlags(Qt::Popup);

	header = new QLabel;

	browser = new QTextBrowser;

	cursor = new QCursor();
	
	closeButton = new QToolButton;
	closeButton->setIcon(QIcon(ICONS_PATH"close_popup.png"));
	connect(closeButton,SIGNAL(clicked()),this,SLOT(hide()));

	
	QHBoxLayout *topLayout = new QHBoxLayout;
	topLayout->addWidget(header);
	topLayout->addStretch();
	topLayout->addWidget(closeButton);
	
	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addLayout(topLayout);
	mainLayout->addWidget(browser);
	mainLayout->setMargin(3);
	mainLayout->setSpacing(3);

	setLayout(mainLayout);
	resize(300,200);
}

PopupWindow::~PopupWindow() {
	delete browser;
	delete closeButton;
	delete header;
	delete cursor;
}

void PopupWindow::setText(const QString &text) {
	browser->setHtml(text);
}

void PopupWindow::setHeaderText(const QString &headerText) {
	header->setText("<b>" + headerText + "</b>");
}

void PopupWindow::showPopup() {
	int x = 0;
	int y = 0;
	x = cursor->pos().x();
	y = cursor->pos().y();
	if (x < 0) x = 0;
	if (y < 0) y = 0;
	if (x + width() > QApplication::desktop()->width())
		x = QApplication::desktop()->width() - width() - 10;
	if (y + height() > QApplication::desktop()->height())
		y = QApplication::desktop()->height() - height() - 10;
	move(QPoint(x,y));
	show();
}

