//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#include <QComboBox>
#include <QLineEdit>
#include <QGridLayout>
#include <QPushButton>
#include <QLabel>
#include "usbmanagerfsoptionsdialog.h"

UsbManagerFsOptionsDialog::UsbManagerFsOptionsDialog(QWidget *parent) : QDialog(parent) {

	fileSystems = new QComboBox;
	fileSystems->addItem("","");
	fileSystems->addItem("Fat","vfat");
	fileSystems->addItem("Ntfs","ntfs");
	fileSystems->addItem("Ext2","ext2");
	fileSystems->addItem("Ext3","ext3");
	fileSystems->addItem("ReiserFs","reiserfs");
	connect(fileSystems,SIGNAL(currentIndexChanged(int)),this,SLOT(fileSystemChangedSlot(int)));

	optionsLine = new QLineEdit;
	connect(optionsLine,SIGNAL(textChanged(const QString &)),this,SLOT(optionsChangedSlot(const QString &)));
	
	okButton = new QPushButton("Ok");
	
	QHBoxLayout *bottomLayout = new QHBoxLayout;
	bottomLayout->addStretch();
	bottomLayout->addWidget(okButton);

	connect(okButton,SIGNAL(clicked()),this,SLOT(hide()));

	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->addWidget(new QLabel(tr("File system") + ":"),0,0);
	mainLayout->addWidget(fileSystems,0,1);
	mainLayout->addWidget(new QLabel(tr("Options") + ":"),1,0);
	mainLayout->addWidget(optionsLine,1,1);
	mainLayout->addLayout(bottomLayout,2,0,1,2);
	setLayout(mainLayout);
	setWindowTitle(tr("Edit options"));
}

UsbManagerFsOptionsDialog::~UsbManagerFsOptionsDialog() {
	delete okButton;
	delete fileSystems;
	delete optionsLine;
}

void UsbManagerFsOptionsDialog::setFileSystem(const QString &newFileSystem) {
	bool itemWasFound = false;
	for (int i = 0; i < fileSystems->count(); i++)
		if (fileSystems->itemData(i).toString() == newFileSystem) {
			fileSystems->setCurrentIndex(i);
			itemWasFound = true;
			break;
		}
	if (!itemWasFound) {
		fileSystems->addItem(newFileSystem,newFileSystem);
		fileSystems->setCurrentIndex(fileSystems->count()-1);
	}
	currentFileSystem = newFileSystem;
}

void UsbManagerFsOptionsDialog::setOptions(const QString &newOptions) {
	currentOptions = newOptions;
	optionsLine->setText(newOptions);
}

const QString& UsbManagerFsOptionsDialog::options() const {
	return currentOptions;
}

const QString& UsbManagerFsOptionsDialog::fileSystem() const {
	return currentFileSystem;
}

void UsbManagerFsOptionsDialog::optionsChangedSlot(const QString &options) {
	currentOptions = options;
	emit (optionsChanged(currentOptions));
}

void UsbManagerFsOptionsDialog::fileSystemChangedSlot(int index) {
	currentFileSystem = fileSystems->itemData(index).toString();
	emit (fileSystemChanged(currentFileSystem));
}
