#include "udevrule.h"

UdevRule::UdevRule() {
	removeMountPoint = false;
}

void UdevRule::setName(const QString& n) {
	name = n;
}

void UdevRule::setVendor(const QString& v) {
	vendor = v;
}

void UdevRule::setModel(const QString& m) {
	model = m;
}

void UdevRule::setSubsystem(const QString& s) {
	subsystem = s;
}

void UdevRule::setBus(const QString& b) {
	bus = b;
}

void UdevRule::setMountPoint(const QString& mp) {
	mountPoint = mp;
}

void UdevRule::setRemoveMountPoint(bool rmp) {
	removeMountPoint = rmp;
}

void UdevRule::setGroup(const QString& g) {
	group = g;
}

void UdevRule::setOwner(const QString& o) {
	owner = o;
}

void UdevRule::addOptionsWithFileSystem(const QString& fileSystem,const QString& options) {
	optionsWithFileSystems.insert(fileSystem,options);
}

void UdevRule::clearOptionsWithFileSystems() {
	optionsWithFileSystems.clear();
}

QString UdevRule::getName() const {
	return name;
}

QString UdevRule::getVendor() const {
	return vendor;
}

QString UdevRule::getModel() const {
	return model;
}

QString UdevRule::getSubsystem() const {
	return subsystem;
}

QString UdevRule::getBus() const {
	return bus;
}

QString UdevRule::getMountPoint() const {
	return mountPoint;
}

bool UdevRule::getRemoveMountPoint() const {
	return removeMountPoint;
}

QString UdevRule::getGroup() const {
	return group;
}

QString UdevRule::getOwner() const {
	return owner;
}

const QMap<QString,QString>& UdevRule::getOptionsWithFileSystems() const {
	return optionsWithFileSystems;
}

QString UdevRule::getFileStringOfTheRule() {
	QString ruleString;
	if (mountPoint.isEmpty() || optionsWithFileSystems.isEmpty())
		return ruleString;
	
	if (removeMountPoint)
		ruleString += "#CreateDir#\n" + definitionRuleString() + QString("ACTION==\"add\", RUN+=\"/bin/mkdir -p %1\"\n").arg(mountPoint);
	
	foreach (QString fileSystem,optionsWithFileSystems.keys()) {
		ruleString += "#Mount#\n";
		ruleString += definitionRuleString();
		ruleString += "ACTION==\"add\", ";
		if (!group.isEmpty())
			ruleString += "GROUP=\"" + group + "\", ";
		if (!owner.isEmpty())
			ruleString += "OWNER=\"" + owner + "\", ";
		ruleString += QString("PROGRAM==\"/lib/udev/vol_id -t %N\", RESULT==\"%1\", ").arg(fileSystem);
		ruleString += QString("RUN+=\"/bin/mount -t %1 -o %2 /dev/%k %3\"\n")
				.arg(fileSystem)
				.arg(optionsWithFileSystems[fileSystem])
				.arg(mountPoint);
			
	}
	if (removeMountPoint) {
		ruleString += "#UmountDir#\n" + definitionRuleString() +
				QString("ACTION==\"remove\", RUN+=\"/bin/umount -l %1\"\n").arg(mountPoint);
		ruleString += "#RemoveDir#\n" + definitionRuleString() +
				QString("ACTION==\"remove\", RUN+=\"/bin/rmdir %1\"\n").arg(mountPoint);
	}
	return ruleString;
}

QString UdevRule::definitionRuleString() {
	QString ruleString;
	if (!name.isEmpty())
		ruleString += "KERNEL==\"" + name + "\", ";
	if (!vendor.isEmpty())
		ruleString += "SYSFS{vendor}==\"" + vendor + "\", ";
	if (!model.isEmpty())
		ruleString += "SYSFS{model}==\"" + model + "\", ";
	if (!subsystem.isEmpty())
		ruleString += "SUBSYSTEM==\"" + subsystem + "\", ";
	if (!bus.isEmpty())
		ruleString += "BUS==\"" + bus + "\", ";
	return ruleString;
}

bool UdevRule::isNull() const {
	return name.isEmpty() && vendor.isEmpty() && model.isEmpty();
}
