//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef VOLUMEWIDGET_H
#define VOLUMEWIDGET_H

#include <QtGui/QWidget>

class QPushButton;
class QLabel;
class QCheckBox;
class QLineEdit;
class QComboBox;
class OptionsView;
class DiskDevice;
class DiskCore;
class PopupWindow;
class InfoButton;
class ChooseMountPointWidget;
class QAction;
class QSpinBox;

class VolumeWidget : public QWidget
{
	Q_OBJECT
	signals:
		void showWarning(const QString& warningText,QList<QAction *> actions);
		void optionsChanged();
	private slots:
		void updateOptionLine();
		void udfOrIsoChangedSlot(int index);
		void useNtfs3g(bool use);
		void setMountPoint(const QString&);
	private:
		DiskDevice *device;

		ChooseMountPointWidget *mountPointLine;
		QCheckBox *dump;
		QSpinBox *fsck;

		QAction *changeMountPointAction;
		
		// Cd's can have file system udf or iso9660, but in
		// /etc/fstab user can write as file system "udf,iso9660" or "udf" or "iso9660" if user have DVD-Rom
		QComboBox *udfOrIsoComboBox;
		QLabel *udfOrIsoLabel;
		
		QCheckBox *showDefaultOptions;
		QCheckBox *useNtfs3gOptions;
		
		QLineEdit *optionsLine;
		InfoButton *optionsLineInfoButton;

		OptionsView *optionsView;
		// rw,suid,dev,exec,auto,nouser,async == defaults
		void replaceDefaultOptionsOnOneWord(QString&);
		QString fileSystem();
	public:
		VolumeWidget(DiskCore *core,DiskDevice *device,PopupWindow *popupWindow);
		~VolumeWidget();

		const QString& mountPoint() const;
		QString options();
		QString fstabLine(bool warn = false,const QString& format = "name");
};

#endif
