# Movable Type (r) Open Source (C) 2001-2008 Six Apart, Ltd.
# This program is distributed under the terms of the
# GNU General Public License, version 2.
#
# $Id: en_us.pm 2819 2008-07-18 23:57:07Z mpaschal $

package MT::L10N::en_us;   # American English

use strict;
use MT::L10N;
use vars qw( @ISA %Lexicon );
@ISA = qw( MT::L10N );

sub ascii_only { ((ref $_[0]) || $_[0]) eq __PACKAGE__ }

%Lexicon = (
    'AUTO DETECT' => 'Auto-detect',
    '_USER_ENABLE' => 'Enable',
    '_USER_DISABLE' => 'Disable',
    '_USER_ENABLED' => 'Enabled',
    '_USER_DISABLED' => 'Disabled',
    '_USER_PENDING' => 'Pending',
    '_USER_STATUS_CAPTION' => 'Status',
    '_external_link_target' => '_new',
    '_BLOG_CONFIG_MODE_BASIC' => 'Basic Mode',
    '_BLOG_CONFIG_MODE_DETAIL' => 'Detailed Mode',
    '_SEARCH_SIDEBAR' => 'Search',

    '_ERROR_CONFIG_FILE' => 'Your Movable Type configuration file is missing or cannot be read properly. Please see the <a href="javascript:void(0)">Installation and Configuration</a> section of the Movable Type manual for more information.',
    '_ERROR_DATABASE_CONNECTION' => 'Your database settings are either invalid or not present in your Movable Type configuration file. Please see the <a href="javascript:void(0)">Installation and Configuration</a> section of the Movable Type manual for more information.',
    '_ERROR_CGI_PATH' => 'Your CGIPath configuration setting is either invalid or not present in your Movable Type configuration file. Please see the <a href="javascript:void(0)">Installation and Configuration</a> section of the Movable Type manual for more information.',
    '_USAGE_REBUILD' => '<a href="javascript:void(0)" onclick="doRebuild()">REBUILD</a> to see those changes reflected on your public site.',
    '_USAGE_VIEW_LOG' => 'Check the <a href="[_1]">Activity Log</a> for the error.',

    '_USAGE_FORGOT_PASSWORD_1' => 'You requested recovery of your Movable Type password. Your password has been changed in the system; here is the new password:',
    '_USAGE_FORGOT_PASSWORD_2' => 'You should be able to log in to Movable Type using this new password from the URL below. Once you have logged in, you should change your password to something more memorable.',

    '_BACKUP_TEMPDIR_WARNING' => 'Requested data has been backed up successfully in the [_1] directory.  Make sure that you download and <strong>then delete</strong> files listed above from [_1] <strong>immediately</strong> because backup files contain sensitive information.',
    '_BACKUP_DOWNLOAD_MESSAGE' => 'Downloading of the backup file will start automatically in a few seconds.  If for some reason it does not, click <a href="javascript:(void)" onclick="submit_form()">here</a> to start downloading manually.  Please note that you can download the backup file only once for a session.',
    '_USAGE_BOOKMARKLET_1' => 'Setting up QuickPost to post to Movable Type allows you to perform one-click posting and publishing without ever entering through the main Movable Type interface.',
    '_USAGE_BOOKMARKLET_2' => 'Movable Type\'s QuickPost structure allows you to customize the layout and fields on your QuickPost page. For example, you may wish to add the ability to add excerpts through the QuickPost window. By default, a QuickPost window will always have: a pulldown menu for the weblog to post to; a pulldown menu to select the Post Status (Draft or Publish) of the new entry; a text entry box for the Title of the entry; and a text entry box for the entry body.',
    '_USAGE_BOOKMARKLET_3' => 'To install the Movable Type QuickPost bookmark, drag the following link to your browser\'s menu or Favorites toolbar:',
    '_USAGE_BOOKMARKLET_4' => 'After installing QuickPost, you can post from anywhere on the web. When viewing a page that you want to post about, click the "QuickPost" QuickPost to open a popup window with a special Movable Type editing window. From that window you can select a weblog to post the entry to, then enter you post, and publish.',
    '_USAGE_BOOKMARKLET_5' => 'Alternatively, if you are running Internet Explorer on Windows, you can install a "QuickPost" option into the Windows right-click menu. Click on the link below and accept the browser prompt to "Open" the file. Then quit and restart your browser to add the link to the right-click menu.',
    '_USAGE_ARCHIVE_MAPS' => 'This advanced feature allows you to map any archive template to multiple archive types. For example, you may want to create two different views of your monthly archives: one in which the entries for a particular month are presented as a list, and the other representing the entries in a calendar view of that month.',
    '_USAGE_ARCHIVING_1' => 'Select the frequencies/types of archiving that you would like on your site. For each type of archiving that you choose, you have the option of assigning multiple Archive Templates to be applied to that particular type. For example, you might wish to create two different views of your monthly archives: one a page containing each of the entries for a particular month, and the other a calendar view of that month.', 
    '_USAGE_ARCHIVING_2' => 'When you associate multiple templates with a particular archive type--or even when you associate only one--you can customize the output path for the archive files using Archive File Templates.',
    '_USAGE_ARCHIVING_3' => 'Select the archive type to which you would like to add a new archive template. Then select the template to associate with that archive type.',

    '_USAGE_BANLIST' => 'Below is the list of IP addresses who you have banned from commenting on your site or from sending TrackBack pings to your site. To add a new IP address, enter the address in the form below. To delete a banned IP address, check the delete box in the table below, and press the DELETE button.',

    '_USAGE_PREFS' => 'This screen allows you to set a variety of optional settings concerning your blog, your archives, your comments, and your publicity &amp; notification settings. When you create a new blog, these values will be set to reasonable defaults.',

    '_USAGE_FEEDBACK_PREFS' => 'This screen allows you to configure the ways that readers can contribute feedback to your blog.',

    '_USAGE_PROFILE' => 'Edit your user profile here. If you change your username or your password, your login credentials will be automatically updated. In other words, you will not need to re-login.',
    '_GENL_USAGE_PROFILE' => 'Edit the user\'s profile here. If you change the username or the password, the user\'s login credentials will be automatically updated. In other words, they will not need to re-login.',
    '_USAGE_GROUP_PROFILE' => 'This screen allows you to edit the group\'s profile.',
    '_USAGE_PASSWORD_RESET' => 'You can initiate password recovery on behalf of this user. If you choose to do so, an email will be sent to directly to <strong>[_1]</strong> with a randomly generated new password.',
    '_WARNING_PASSWORD_RESET_SINGLE' => 'You are about to reset the password for "[_1]". A new password will be randomly generated and sent directly to their email address ([_2]).  Do you wish to continue?',
    '_WARNING_PASSWORD_RESET_MULTI' => 'You are about to reset the password for the selected users. New passwords will be randomly generated and sent directly to their email address(es). Do you wish to continue?',
    '_USAGE_NEW_AUTHOR' => 'From this screen you can create a new user in the system.',
    '_USAGE_NEW_GROUP' => 'From this screen you can create a new group in the system.',
    '_USAGE_ROLES' => 'From this screen you can view the roles you have for your weblogs, and create roles. You can see the details for the different roles by clicking on their names.',
    '_USAGE_ROLE_PROFILE' => 'From this screen you can define a role and its permissions.',
    '_USAGE_ASSOCIATIONS' => 'From this screen you can view permissions and create permissions.',

    '_USAGE_CATEGORIES' => 'Use categories to group your entries for easier reference, archiving and blog display. You can assign a category to a particular entry when creating or editing entries. To edit an existing category, click the category\'s title. To create a subcategory click the corresponding "Create" button. To move a category, click the corresponding "Move" button.',
    '_USAGE_CATEGORY_PING_URL' => 'This is the URL that others will use to send TrackBacks to your weblog. If you wish for anyone to send TrackBacks to your weblog when they have an entry specific to this category, publish this URL publicly. If you choose to only allow a select group of individuals to TrackBack, send this URL to them privately. To include a list of incoming TrackBacks in your Main Index Template, check the documentation for template tags related to TrackBacks.',

    '_USAGE_TAGS' => 'Use tags to group your entries for easier reference and blog display.',

    '_USAGE_COMMENT' => 'Edit the selected comment. Press SAVE when you are finished. You will need to rebuild for these changes to take effect.',

    '_USAGE_PERMISSIONS_1' => 'You are editing the permissions of <b>[_1]</b>. Below you will find a list of blogs to which you have user-editing access; for each blog in the list, assign permissions to <b>[_1]</b> by checking the boxes for the access permissions you wish to grant.',
    '_USAGE_PERMISSIONS_2' => 'To edit permissions for a different user, select a new user from the pull-down menu, then press EDIT.',
    '_USAGE_PERMISSIONS_3' => 'You have two ways to edit users and grant/revoke access privileges. For quick access, select a user from the menu below and select edit. Alternatively, you may browse the complete list of users and, from there, select a person to edit or delete.',
    '_USAGE_PERMISSIONS_4' => 'Each blog may have multiple users. To add a user, enter the user\'s information in the forms below. Next, select the blogs on which the user will have some sort of privileges.  Once you press SAVE and the user is in the system, you can edit the user\'s privileges.',

    '_USAGE_PLACEMENTS' => 'Use the editing tools below to manage the secondary categories to which this entry is assigned. The list to the left consists of the categories to which this entry is not yet assigned as either a primary or secondary category; the list to the right consists of the secondary categories to which this entry is assigned.',

    '_USAGE_ENTRYPREFS' => 'Select the set of fields to be displayed on the entry editor.',

    '_USAGE_IMPORT' => 'You can import entries for your weblog from a file in the <code>import</code> directory where Movable Type is installed, or uploaded by following forms. Entries can be imported from other Movable Type installations or other applications.',
    '_USAGE_EXPORT_1' => 'Export the entries, comments and TrackBacks of a blog. An export is not considered a <em>complete</em> backup of a blog.',
    '_USAGE_EXPORT_2' => 'To export your entries, click on the link below ("Export Entries From [_1]"). To save the exported data to a file, you can hold down the <code>option</code> key on the Macintosh, or the <code>Shift</code> key on a PC, while clicking on the link. Alternatively, you can select all of the data, then copy it into another document. (<a href="javascript:void(0)" onclick="openManual(\'importing\', \'export_ie\');return false;">Exporting from Internet Explorer?</a>)',
    '_USAGE_EXPORT_3' => 'Clicking the link below will export all of your current weblog entries to the Tangent server. This is generally a one-time push of your entries, to be done after you have installed the Tangent add-on for Movable Type, but conceivably it could be executed whenever you wish.',

    '_NO_SUPERUSER_DISABLE' => 'Because you are a system administrator on the Movable Type system, you can not disable yourself.',

    '_USAGE_AUTHORS' => 'This is a list of all of the users in the Movable Type system. You can edit a user\'s profile by clicking on his/her name.',
    '_USAGE_AUTHORS_1' => 'This is a list of all of the users in the Movable Type system. You can edit a user\'s profile by clicking on his/her name. You can create, edit and delete user records by using CSV-based command file.',
    '_USAGE_AUTHORS_LDAP' => 'This is a list of all of the users in the Movable Type system. You can edit a user\'s profile by clicking on his/her name. You can disable users by checking the checkbox next to their name, then pressing DISABLE. By doing this, the user will not be able to login to Movable Type.',
    '_USAGE_AUTHORS_2' => 'You can create, edit and delete users in bulk by uploading a CSV-formatted file containing those commands and relevant data.',

    '_USAGE_GROUPS' => 'Below is a list of all groups in the Movable Type system. You can enable or disable a group by checking the checkbox next to its name, then pressing either the Enable or Disable button. You can edit a group by clicking on its name.',
    '_USAGE_GROUPS_USER' => 'Below is a list of the groups in which the user is a member. You can remove the user from a group by checking the checkbox next to that group and clicking REMOVE.',
    '_USAGE_GROUPS_LDAP' => 'Below is a list of all groups in the Movable Type system. You can enable or disable a group by checking the checkbox next to its name, then pressing either the Enable or Disable button.',
    '_USAGE_GROUPS_USER_LDAP' => 'Below is a list of the groups in which the user is a member.',

    '_USAGE_PLUGINS' => 'This is a list of all plugins currently registered with Movable Type.',

    '_USAGE_LIST_POWER' => 'Here is the list of entries for [_1] in batch-editing mode. In the form below, you may change any of the values for any of the entries displayed; after making the desired modifications, press the SAVE button. The standard List &amp; Edit Entries controls (filters, paging) work in batch mode in the manner to which you are accustomed.',

    '_USAGE_ENTRY_LIST_BLOG' => 'Here is the list of entries for [_1] which you can filter, manage and edit.',
    '_USAGE_ENTRY_LIST_OVERVIEW' => 'Here is the list of entries for all weblogs which you can filter, manage and edit.',

    '_USAGE_COMMENTERS_LIST' => 'Here is the list of all authenicated commenters to [_1]. Below you may flag any commenter as trusted or banned, or get more information.',

    '_USAGE_PING_LIST_BLOG' => 'Here is the list of TrackBacks for [_1]  which you can filter, manage and edit.',
    '_USAGE_PING_LIST_OVERVIEW' => 'Here is the list of TrackBacks for all weblogs which you can filter, manage and edit.',
    
    '_USAGE_PING_LIST_ALL_WEBLOGS' => 'Here is the list of TrackBack pings for all weblogs  which you can filter, manage and edit.',

    '_USAGE_NOTIFICATIONS' => 'Here is the list of users who wish to be notified when you publish to your site. To add a new user, enter their email address in the form below. The URL field is optional. To delete a user, check the delete box in the table below and press the DELETE button.',

    '_USAGE_SEARCH' => 'You can use the Search &amp; Replace tool to find and optionally replace text or data found in many item listings within Movable Type. IMPORTANT: be careful when doing a replace, because there is <b>no undo</b>.',

    '_USAGE_UPLOAD' => 'You can upload the file to a subdirectory in the selected path. The subdirectory will be created if it does not exist.',

     '_THROTTLED_COMMENT' => 'Too many comments have been submitted from you in a short period of time.  Please try again in a short while.',
     '_NOTIFY_REQUIRE_CONFIRMATION' => 'An email has been sent to [_1]. To complete your subscription, 
please follow the link contained in that email. This will verify that
the address you provided is correct and belongs to you.',

    '_INDEX_INTRO' => '<p>If you are installing Movable Type, you may want to review the <a href="http://www.sixapart.com/movabletype/docs/mtinstall.html">installation instructions</a> and view the <a rel="nofollow" href="mt-check.cgi">Movable Type System Check</a> to make sure that your system has what it needs.</p>',
    '_LOG_TABLE_BY' => 'By',
    '_REBUILD_PUBLISH' => 'Publish',
    '_DATE_FROM' => 'From',
    '_DATE_TO' => 'To',
    '_LOCALE_WEEK_START' => '0',
    '_SHORT_MAY' => 'May',
    '_MTCOM_URL' => 'http://www.movabletype.com/',
    '_CATEGORY_BASENAME' => 'Basename',

    '_AUTO' => 1,
    'DAILY_ADV' => 'Daily',
    'WEEKLY_ADV' => 'Weekly',
    'MONTHLY_ADV' => 'Monthly',
    'YEARLY_ADV' => 'Yearly',
    'INDIVIDUAL_ADV' => 'Entry',
    'PAGE_ADV' => 'Page',
    'AUTHOR_ADV' => 'Author',
    'AUTHOR-YEARLY_ADV' => 'Author Yearly',
    'AUTHOR-MONTHLY_ADV' => 'Author Monthly',
    'AUTHOR-WEEKLY_ADV' => 'Author Weekly',
    'AUTHOR-DAILY_ADV' => 'Author Daily',
    'CATEGORY_ADV' => 'Category',
    'CATEGORY-YEARLY_ADV' => 'Category Yearly',
    'CATEGORY-MONTHLY_ADV' => 'Category Monthly',
    'CATEGORY-WEEKLY_ADV' => 'Category Weekly',
    'CATEGORY-DAILY_ADV' => 'Category Daily',
    'Daily' => 'Daily',
    'Weekly' => 'Weekly',
    'Monthly' => 'Monthly',
    'Yearly' => 'Yearly',
    'Individual' => 'Individual',
    'Category' => 'Category',
    'Category Archive' => 'Category Archive',   
    'Date-Based Archive' => 'Date-Based Archive',   
    'Individual Entry Archive' => 'Individual Entry Archive',
    'Atom Index' => 'Atom Index',    
    'Dynamic Site Bootstrapper' => 'Dynamic Site Bootstrapper',    
    'Main Index' => 'Main Index',    
    'Master Archive Index' => 'Master Archive Index',    
    'RSD' => 'RSD',    
    'RSS 1.0 Index' => 'RSS 1.0 Index', 
    'RSS 2.0 Index' => 'RSS 2.0 Index', 
    'Stylesheet' => 'Stylesheet',

    'UTC+11' => 'UTC+11 (East Australian Daylight Savings Time)',
    'UTC+10' => 'UTC+10 (East Australian Standard Time)',

    '_POWERED_BY' => 'Powered by <a href="http://www.movabletype.com/" rel="generator"><$MTProductName$></a>',
    '_DISPLAY_OPTIONS_SHOW' => 'Show',
    'Blog Administrator' => 'Blog Administrator',
    'Create Entries' => 'Create Entries',
    'Edit All Entries' => 'Edit All Entries',
    'Manage Templates' => 'Manage Templates',
    'Configure Weblog' => 'Configure Weblog',
    'Rebuild Files' => 'Rebuild Files',
    'Send Notifications' => 'Send Notifications',
    'Manage Categories' => 'Manage Categories',
    'Add/Manage Categories' => 'Add/Manage Categories',
    'Manage Tags' => 'Manage Tags',
    'Manage Notification List' => 'Manage Notification List',
    'View This Weblog\'s Activity Log' => 'View This Weblog\'s Activity Log',
    'Publish Entries' => 'Publish Entries',
    'Unpublish Entries' => 'Unpublish Entries',
    'Unpublish TrackBack(s)' => 'Unpublish TrackBack(s)',
    'Unpublish Comment(s)' => 'Unpublish Comment(s)',
    'Trust Commenter(s)' => 'Trust Commenter(s)',
    'Untrust Commenter(s)' => 'Untrust Commenter(s)',
    'Ban Commenter(s)' => 'Ban Commenter(s)',
    'Unban Commenter(s)' => 'Unban Commenter(s)',
    'Untrust Commenter(s)' => 'Untrust Commenter(s)',
    'Unban Commenter(s)' => 'Unban Commenter(s)',
    'Add Tags...' => 'Add Tags...',
    'Remove Tags...' => 'Remove Tags...',
    'Tags to add to selected entries' => 'Tags to add to selected entries',
    'Tags to remove from selected entries' => 'Tags to remove from selected entries',
    'Manage my Widgets' => 'Manage my Widgets',
    'Select a Design using StyleCatcher' => 'Select a Design using StyleCatcher',
    'This page contains a single entry from the blog created on <strong>[_1]</strong>.' => 'This page contains a single entry from the blog created on <strong>[_1]</strong>.',
    'The previous entry in this blog was <a href="[_1]">[_2]</a>.' => 'The previous entry in this blog was <a href="[_1]">[_2]</a>.',
    'The next entry in this blog is <a href="[_1]">[_2]</a>.' => 'The next entry in this blog is <a href="[_1]">[_2]</a>.',
    'Many more can be found on the <a href="[_1]">main index page</a> or by looking through <a href="[_2]">the archives</a>.' => 'Many more can be found on the <a href="[_1]">main index page</a> or by looking through <a href="[_2]">the archives</a>.',
    'Install <a href=\'http://greasemonkey.mozdev.org/\'>GreaseMonkey</a>' => 'Install <a href=\'http://greasemonkey.mozdev.org/\'>GreaseMonkey</a>',
    'Create a feed widget' => 'Create a feed widget',
    'Or return to the <a href="[_1]">Main Menu</a> or <a href="[_2]">System Overview</a>.' => 'Or return to the <a href="[_1]">Main Menu</a> or <a href="[_2]">System Overview</a>.',
    'An error occurred processing [_1]. Check <a href="http://www.feedvalidator.org/check.cgi?url=[_2]">here</a> for more detail and please try again.' => 'An error occurred processing [_1]. Check <a href="http://www.feedvalidator.org/check.cgi?url=[_2]">here</a> for more detail and please try again.',
    'Congratulations! A template module Widget named <strong>[_1]</strong> has been created which you can further <a href="[_2]">edit</a> to customize its display.' => 'Congratulations! A template module Widget named <strong>[_1]</strong> has been created which you can further <a href="[_2]">edit</a> to customize its display.',
    'It can be included onto your published blog using <a href="[_1]">WidgetManager</a> or this MTInclude tag' => 'It can be included onto your published blog using <a href="[_1]">WidgetManager</a> or this MTInclude tag',
    'StyleCatcher lets you easily browse through styles and then apply them to your blog in just a few clicks. To find out more about Movable Type styles, or for new sources for styles, visit the <a href=\'http://www.sixapart.com/movabletype/styles\'>Movable Type styles</a> page.' => 'StyleCatcher lets you easily browse through styles and then apply them to your blog in just a few clicks. To find out more about Movable Type styles, or for new sources for styles, visit the <a href=\'http://www.sixapart.com/movabletype/styles\'>Movable Type styles</a> page.',
    'To download more plugins, check out the <a href="http://www.sixapart.com/pronet/plugins/">Six Apart Plugin Directory</a>.' => 'To download more plugins, check out the <a href="http://www.sixapart.com/pronet/plugins/">Six Apart Plugin Directory</a>.',
    'Adds template tags to allow you to search for content from Google. You will need to configure this plugin using a <a href=\'http://www.google.com/apis/\'>license key.</a>' => 'Adds template tags to allow you to search for content from Google. You will need to configure this plugin using a <a href=\'http://www.google.com/apis/\'>license key.</a>',
    'Please enter the parameters necessary for connecting to your database.If your database type is not listed in the dropdown below, you may be missing the Perl module necessary to connect to your database.  If this is the case, please check your installation and click <a href="?__mode=configure">here</a> to re-test your installation.' => 'Please enter the parameters necessary for connecting to your database.If your database type is not listed in the dropdown below, you may be missing the Perl module necessary to connect to your database.  If this is the case, please check your installation and click <a href="?__mode=configure">here</a> to re-test your installation.',
    'The above settings have been written to the file <tt>[_1]</tt>. If any of these settings are incorrect, you may click the \'Back\' button below to reconfigure them.' => 'The above settings have been written to the file <tt>[_1]</tt>. If any of these settings are incorrect, you may click the \'Back\' button below to reconfigure them.',
    'The following modules are <strong>optional</strong>. If your server does not have these modules installed, you only need to install them if you require the functionality that the module provides.' => 'The following modules are <strong>optional</strong>. If your server does not have these modules installed, you only need to install them if you require the functionality that the module provides.',
    '<p>You must define a global theme repository where themes can be stored locally.  If a particular blog has not been configured for it\'s own theme paths, it will use these settings directly. If a blog has it\'s own theme paths, then the theme will be copied to that location when applied to that weblog. The paths defined here must physically exist and be writable by the webserver.</p>' => '<p>You must define a global theme repository where themes can be stored locally.  If a particular blog has not been configured for it\'s own theme paths, it will use these settings directly. If a blog has it\'s own theme paths, then the theme will be copied to that location when applied to that weblog. The paths defined here must physically exist and be writable by the webserver.</p>',
    'Drag and drop the widgets you want into the <strong>Installed</strong> column.' => 'Drag and drop the widgets you want into the <strong>Installed</strong> column.',
    'If your import file is located on your computer, you can upload it here.  Otherwise, Movable Type will automatically look in the <code>import</code> folder of your Movable Type directory.' => 'If your import file is located on your computer, you can upload it here.  Otherwise, Movable Type will automatically look in the <code>import</code> folder of your Movable Type directory.',
    '<em><strong>Please Note:</strong> The Movable Type export format is not comprehensive and is not suitable for creating full-fidelity backups. Please see the Movable Type manual for full details.</em>' => '<em><strong>Please Note:</strong> The Movable Type export format is not comprehensive and is not suitable for creating full-fidelity backups. Please see the Movable Type manual for full details.</em>',
    'Recover Password(s)' => 'Recover Password(s)',
    'Refresh Template(s)' => 'Refresh Template(s)',
    'This page contains all entries published to [_1] in <strong>[_2]</strong>. They are listed from oldest to newest.' => 'This page contains all entries published to [_1] in <strong>[_2]</strong>. They are listed from oldest to newest.',
    '<a href="[_1]">[_2]</a> is the next category.' => '<a href="[_1]">[_2]</a> is the next category.',
    '<a href="[_1]">[_2]</a> is the previous category.' => '<a href="[_1]">[_2]</a> is the previous category.',
    'This page contains an archive of all entries published to [_1] in the <strong>[_2]</strong> category.  They are listed from oldest to newest.' => 'This page contains an archive of all entries published to [_1] in the <strong>[_2]</strong> category.  They are listed from oldest to newest.',
    '<a href="[_1]">[_2]</a> is the next archive.' => '<a href="[_1]">[_2]</a> is the next archive.',
    '<a href="[_1]">[_2]</a> is the previous archive.' => '<a href="[_1]">[_2]</a> is the previous archive.',
    'Refreshing (with <a href="?__mode=view&amp;blog_id=[_1]&amp;_type=template&amp;id=[_2]">backup</a>) template \'[_3]\'.' => 'Refreshing (with <a href="?__mode=view&amp;blog_id=[_1]&amp;_type=template&amp;id=[_2]">backup</a>) template \'[_3]\'.',
    'Skipping template \'[_1]\' since it appears to be a custom template.' => 'Skipping template \'[_1]\' since it appears to be a custom template.',
    'Refreshing template \'[_1]\'.' => 'Refreshing template \'[_1]\'.',
    '4th argument to add_callback must be a CODE reference.' => '4th argument to add_callback must be a CODE reference.',
    'An error occurred while testing for the new tag name.' => 'An error occurred while testing for the new tag name.',
    'Assigning user types...' => 'Assigning user types...',
    'Assigning basename for categories...' => 'Assigning basename for categories...',
    'Assigning blog administration permissions...' => 'Assigning blog administration permissions...',
    'Assigning category parent fields...' => 'Assigning category parent fields...',
    'Assigning comment/moderation settings...' => 'Assigning comment/moderation settings...',
    'Assigning custom dynamic template settings...' => 'Assigning custom dynamic template settings...',
    'Assigning entry basenames for old entries...' => 'Assigning entry basenames for old entries...',
    'Assigning spam status for comments...' => 'Assigning spam status for comments...',
    'Assigning spam status for TrackBacks...' => 'Assigning spam status for TrackBacks...',
    'Assigning template build dynamic settings...' => 'Assigning template build dynamic settings...',
    'Assigning visible status for comments...' => 'Assigning visible status for comments...',
    'Assigning visible status for TrackBacks...' => 'Assigning visible status for TrackBacks...',
    'Bad CGIPath config' => 'Bad CGIPath config',
    'Bad ObjectDriver config: [_1] ' => 'Bad ObjectDriver config: [_1] ',
    'Bad ObjectDriver config' => 'Bad ObjectDriver config',
    'Creating entry category placements...' => 'Creating entry category placements...',
    'DBI and DBD::SQLite2 are required if you want to use the SQLite2 database backend.' => 'DBI and DBD::SQLite2 are required if you want to use the SQLite2 database backend.',
    'Download file' => 'Download file',
    'Error creating temporary file; please check your TempDir setting in mt.cfg (currently \'[_1]\') this location should be writable.' => 'Error creating temporary file; please check your TempDir setting in mt.cfg (currently \'[_1]\') this location should be writable.',
    'Error loading default templates.' => 'Error loading default templates.',
    'Error saving entry: [_1]' => 'Error saving entry: [_1]',
    'Error sending mail ([_1]); please fix the problem, then try again to recover your password.' => 'Error sending mail ([_1]); please fix the problem, then try again to recover your password.',
    'File with name \'[_1]\' already exists. (Install File::Temp if you\'d like to be able to overwrite existing uploaded files.)' => 'File with name \'[_1]\' already exists. (Install File::Temp if you\'d like to be able to overwrite existing uploaded files.)',
    'File with name \'[_1]\' already exists; Tried to write to tempfile, but open failed: [_2]' => 'File with name \'[_1]\' already exists; Tried to write to tempfile, but open failed: [_2]',
    'If present, 3rd argument to add_callback must be an object of type MT::Plugin' => 'If present, 3rd argument to add_callback must be an object of type MT::Plugin',
    'If you have a TypeKey identity, you can ' => 'If you have a TypeKey identity, you can ',
    'index' => 'index',
    'Insufficient permissions for modifying templates for this weblog.' => 'Insufficient permissions for modifying templates for this weblog.',
    'Invalid date format \'[_1]\'; must be \'MM/DD/YYYY HH:MM:SS AM|PM\' (AM|PM is optional)' => 'Invalid date format \'[_1]\'; must be \'MM/DD/YYYY HH:MM:SS AM|PM\' (AM|PM is optional)',
    'Invalid priority level [_1] at add_callback' => 'Invalid priority level [_1] at add_callback',
    'Migrating any "tag" categories to new tags...' => 'Migrating any "tag" categories to new tags...',
    'Missing configuration file. Maybe you forgot to move mt-config.cgi-original to mt-config.cgi?' => 'Missing configuration file. Maybe you forgot to move mt-config.cgi-original to mt-config.cgi?',
    'Movable Type ships with directory named <strong>mt-static</strong> which contains a number of important files such as images, javascript files and stylesheets.' => 'Movable Type ships with directory named <strong>mt-static</strong> which contains a number of important files such as images, javascript files and stylesheets.',
    'Movable Type ships with directory named <strong>mt-static</strong> which contains a number of important files such as images, javascript files and stylesheets.' => 'Movable Type ships with directory named <strong>mt-static</strong> which contains a number of important files such as images, javascript files and stylesheets.',
    'No executable code' => 'No executable code',
    'Created <MTIfNonEmpty tag="EntryAuthorDisplayName">by [_1] </MTIfNonEmpty>on [_2]' => 'Created <MTIfNonEmpty tag="EntryAuthorDisplayName">by [_1] </MTIfNonEmpty>on [_2]',
    'Powered by [_1]' => 'Powered by [_1]',
    'Processing templates for weblog \'[_1]\'' => 'Processing templates for weblog \'[_1]\'',
    'Search Template' => 'Search Template',
    'Sending mail via SMTP requires that your server have Mail::Sendmail installed: [_1]' => 'Sending mail via SMTP requires that your server have Mail::Sendmail installed: [_1]',
    'Setting blog allow pings status...' => 'Setting blog allow pings status...',
    'Setting blog basename limits...' => 'Setting blog basename limits...',
    'Setting default blog file extension...' => 'Setting default blog file extension...',
    'Setting new entry defaults for weblogs...' => 'Setting new entry defaults for weblogs...',
    'To enable comment registration, you need to add a TypeKey token in your weblog config or user profile.' => 'To enable comment registration, you need to add a TypeKey token in your weblog config or user profile.',
    'Two plugins are in conflict' => 'Two plugins are in conflict',
    'Updating [_1] records...' => 'Updating [_1] records...',
    'Updating user web services passwords...' => 'Updating user web services passwords...',
    'Updating blog comment email requirements...' => 'Updating blog comment email requirements...',
    'Updating blog old archive link status...' => 'Updating blog old archive link status...',
    'Updating category placements...' => 'Updating category placements...',
    'Updating commenter records...' => 'Updating commenter records...',
    'Updating comment status flags...' => 'Updating comment status flags...',
    'Updating entry week numbers...' => 'Updating entry week numbers...',
    'Updating user permissions for editing tags...' => 'Updating user permissions for editing tags...',
    'View image' => 'View image',
    'You do not have a valid path to sendmail on your machine. Perhaps you should try using SMTP?' => 'You do not have a valid path to sendmail on your machine. Perhaps you should try using SMTP?',
    'You must define a Comment Listing template in order to display dynamic comments.' => 'You must define a Comment Listing template in order to display dynamic comments.',
    'You must define an Individual template in order to display dynamic comments.' => 'You must define an Individual template in order to display dynamic comments.',
    'You need to provide a password if you are going to create new users for each user listed in your blog.' => 'You need to provide a password if you are going to create new users for each user listed in your blog.',
    'You used an [_1] tag outside of a Daily, Weekly, or Monthly context.' => 'You used an [_1] tag outside of a Daily, Weekly, or Monthly context.',
    'You used an \'[_1]\' tag outside of the context of a comment; perhaps you mistakenly placed it outside of an \'MTComments\' container?' => 'You used an \'[_1]\' tag outside of the context of a comment; perhaps you mistakenly placed it outside of an \'MTComments\' container?',
    'You used an \'[_1]\' tag outside of the context of an entry; perhaps you mistakenly placed it outside of an \'MTEntries\' container?' => 'You used an \'[_1]\' tag outside of the context of an entry; perhaps you mistakenly placed it outside of an \'MTEntries\' container?',
    'You used an \'[_1]\' tag outside of the context of a ping; perhaps you mistakenly placed it outside of an \'MTPings\' container?' => 'You used an \'[_1]\' tag outside of the context of a ping; perhaps you mistakenly placed it outside of an \'MTPings\' container?',
     'Clone Weblog' => 'Clone Weblog',
     'Deleting a user is an irrevocable action which creates orphans of the author\'s entries.  If you wish to retire a user or remove their access to the system, removing all of their permissions is th e recommended course of action.  Are you sure you want to delete the [_1] selected users?' => 'Deleting a user is an irrevocable action which creates orphans of the author\'s entries.  If you wish to retire a user or remove their access to the system, removing all of their permissions is th e recommended course of action.  Are you sure you want to delete the [_1] selected users?',
     'Deleting a user is an irrevocable action which creates orphans of the author\'s entries.  If you wish to retire a user or remove their access to the system, removing all of their permissions is the recommended course of action.  Are you sure you want to delete this author?' => 'Deleting a user is an irrevocable action which creates orphans of the author\'s entries.  If you wish to retire a user or remove their access to the system, removing all of their permissions is the recommended course of action.  Are you sure you want to delete this author?',
     '_WARNING_DELETE_USER_EUM' => 'Deleting a user is an irrevocable action which creates orphans of the user\'s entries. If you wish to retire a user or remove their access to the system, disabling their account is the recommended course of action. Are you sure you want to delete the selected user(s)? They will be able to re-create themselves if selected user(s) still exist in your external directory.',
     '_WARNING_DELETE_USER' => 'Deleting a user is an irrevocable action which creates orphans of the user\'s entries. If you wish to retire a user or remove their access to the system, disabling their account is the recommended course of action. Are you sure you want to delete the selected user(s)?',
     'You are currently performing a search. Please wait until your search is completed.' => 'You are currently performing a search. Please wait until your search is completed.',
    '_WARNING_REFRESH_TEMPLATES_FOR_BLOGS' => 'This action will restore the templates in the selected blog(s) to factory settings. Are you sure you want to refresh templates in the selected blog(s)?',
    'Weblog Administrator' => 'Weblog Administrator',
    'Writer' => 'Writer',
    'Writer (can upload)' => 'Writer (can upload)',
    'Editor' => 'Editor',
    'Editor (can upload)' => 'Editor (can upload)',
    'Designer' => 'Designer',
    'Manager' => 'Manager',
    'Publisher' => 'Publisher',
    'Communicator' => 'Communicator',
    'Taxonomist' => 'Taxonomist',
    'Secretary' => 'Secretary',
    'Communications Manager' => 'Communications Manager',
    'Tagger' => 'Tagger',
    'Monitor' => 'Monitor',

    # Missing phrases only found in ja.pm but not in other languages...
    
'Assigning user status...' => 'Assigning user status...',
'Migrating permissions to roles...' => 'Migrating permissions to roles...',
'Can administer the weblog.' => 'Can administer the weblog.',
'Can edit, manage and rebuild weblog templates.' => 'Can edit, manage and rebuild weblog templates.',
'Can edit all entries/categories/tags on a weblog and rebuild.' => 'Can edit all entries/categories/tags on a weblog and rebuild.',
'Can upload files, edit all entries/categories/tags on a weblog and rebuild.' => 'Can upload files, edit all entries/categories/tags on a weblog and rebuild.',
'Can upload files, edit all entries/categories/tags on a weblog, rebuild and send notifications.' => 'Can upload files, edit all entries/categories/tags on a weblog, rebuild and send notifications.',
'Can create entries and edit their own.' => 'Can create entries and edit their own.',
'Can create entries, edit their own and upload files.' => 'Can create entries, edit their own and upload files.',
'Invalid login attempt from user [_1]: [_2]' => 'Invalid login attempt from user [_1]: [_2]',
'The following groups were deleted' => 'The following groups were deleted',
'Invalid LDAPAuthURL scheme: [_1].' => 'Invalid LDAPAuthURL scheme: [_1].',
'Error connecting to LDAP server [_1]: [_2]' => 'Error connecting to LDAP server [_1]: [_2]',
'A user by that name already exists.' => 'A user by that name already exists.',
'You cannot modify your own permissions.' => 'You cannot modify your own permissions.',
'You are not allowed to edit the permissions of this user.' => 'You are not allowed to edit the permissions of this user.',
'You are not allowed to edit the profile of this user.' => 'You are not allowed to edit the profile of this user.',
'Edit Permissions' => 'Edit Permissions',
'Edit Profile' => 'Edit Profile',
'Perl module Image::Size is required to determine width and height of uploaded images.' => 'Perl module Image::Size is required to determine width and height of uploaded images.',
'Permission denied' => 'Permission denied',
'Future' => 'Future',
'Entry "[_1]" added by user "[_2]"' => 'Entry "[_1]" added by user "[_2]"',
'Wrong object type' => 'Wrong object type',
'Permission denied for non-superuser' => 'Permission denied for non-superuser',
'You cannot disable yourself' => 'You cannot disable yourself',
'No new user status given' => 'No new user status given',
'Can\'t enable/disable that way' => 'Can\'t enable/disable that way',
'An error occured during synchronization: [_1]' => 'An error occured during synchronization: [_1]',
'Are you sure you want to delete the selected user(s)? They will be able to re-create themselves if selected user(s) still exist in LDAP.' => 'Are you sure you want to delete the selected user(s)? They will be able to re-create themselves if selected user(s) still exist in LDAP.',
'Are you sure you want to delete the selected user(s)?' => 'Are you sure you want to delete the selected user(s)?',
'Are you sure you want to delete the selected group(s)?' => 'Are you sure you want to delete the selected group(s)?',
'The last system administrator cannot be deleted under ExternalUserManagement.' => 'The last system administrator cannot be deleted under ExternalUserManagement.',
'No new status given' => 'No new status given',
'Edit Role' => 'Edit Role',
'Invalid author' => 'Invalid author',
'An error occurred when enabling this user.' => 'An error occurred when enabling this user.',
'Found' => 'Found',
'Not Found' => 'Not Found',
'Cloning categories for weblog.' => 'Cloning categories for weblog.',
'Now you can comment.' => 'Now you can comment.',
'. Now you can comment.' => '. Now you can comment.',
'Name:' => 'Name:',
'URL:' => 'URL:',
'<$MTCategoryTrackbackLink$> must be used in the context of a category, or with the \'category\' attribute to the tag.' => '<$MTCategoryTrackbackLink$> must be used in the context of a category, or with the \'category\' attribute to the tag.',
'Hello, world' => 'Hello, world',
'Hello, [_1]' => 'Hello, [_1]',
'Error assigning weblog administration rights to user \'[_1] (ID: [_2])\' for weblog \'[_3] (ID: [_4])\'. No suitable weblog administrator role was found.' => 'Error assigning weblog administration rights to user \'[_1] (ID: [_2])\' for weblog \'[_3] (ID: [_4])\'. No suitable weblog administrator role was found.',
'(None)' => '(None)',
'You did not select any [_1] to delete.' => 'You did not select any [_1] to delete.',
'Deleting a user is an irrevocable action which creates orphans of the user\'s entries.  If you wish to retire a user or remove their access to the system, removing all of their permissions is the recommended course of action.  Are you sure you want to delete this user?' => 'Deleting a user is an irrevocable action which creates orphans of the user\'s entries.  If you wish to retire a user or remove their access to the system, removing all of their permissions is the recommended course of action.  Are you sure you want to delete this user?',
'Are you sure you want to delete this [_1]?' => 'Are you sure you want to delete this [_1]?',
'Are you sure you want to delete the [_1] selected [_2]?' => 'Are you sure you want to delete the [_1] selected [_2]?',
'Showing' => 'Showing',
'Now you can comment.' => 'Now you can comment.',
'Name:' => 'Name:',
'URL:' => 'URL:',
'Insufficient permissions to modify templates for weblog \'[_1]\'' => 'Insufficient permissions to modify templates for weblog \'[_1]\'',
'Refreshing (with <a href=\"?__mode=view&amp;blog_id=[_1]&amp;_type=template&amp;id=[_2]\">backup</a>) template \'[_3]\'.' => 'Refreshing (with <a href=\"?__mode=view&amp;blog_id=[_1]&amp;_type=template&amp;id=[_2]\">backup</a>) template \'[_3]\'.',
'Error creating new template: ' => 'Error creating new template: ',
'Created template \'[_1]\'.' => 'Created template \'[_1]\'.',
'No weblog was selected to clone.' => 'No weblog was selected to clone.',
'This action can only be run for a single weblog at a time.' => 'This action can only be run for a single weblog at a time.',
'Invalid blog_id' => 'Invalid blog_id',
'Finished! You can <a href=\'[_1]\'>return to the weblogs listing</a> or <a href=\'[_2]\'>view the new weblog</a>.' => 'Finished! You can <a href=\'[_1]\'>return to the weblogs listing</a> or <a href=\'[_2]\'>view the new weblog</a>.',
'If you want to change the SitePath and SiteURL, <a href=\'[_1]\'>click here</a>.' => 'If you want to change the SitePath and SiteURL, <a href=\'[_1]\'>click here</a>.',
'Finished! You can <a href=\"javascript:void(0);\" onclick="closeDialog(\'[_1]\');\">return to the weblogs listing</a> or <a href=\"javascript:void(0);\" onclick="closeDialog(\'[_2]\');\">configure the Site root and URL of the new weblog</a>.' => 'Finished! You can <a href=\"javascript:void(0);\" onclick="closeDialog(\'[_1]\');\">return to the weblogs listing</a> or <a href=\"javascript:void(0);\" onclick="closeDialog(\'[_2]\');\">configure the Site root and URL of the new weblog</a>.',
'No pages were found containing "[_1]".' => 'No pages were found containing "[_1]".',
'By default, this search engine looks for all words in any order. To search for an exact phrase, enclose the phrase in quotes:' => 'By default, this search engine looks for all words in any order. To search for an exact phrase, enclose the phrase in quotes:',
'Movable type' => 'Movable type',
'The LDAP directory ID for this group.' => 'The LDAP directory ID for this group.',
'Grant a new role to [_1]' => 'Grant a new role to [_1]',
'Create Group Association' => 'Create Group Association',
'Create User Association' => 'Create User Association',
'You can not create associations for disabled users.' => 'You can not create associations for disabled users.',
'You can not create associations for disabled groups.' => 'You can not create associations for disabled groups.',
'Delete selected users (x)' => 'Delete selected users (x)',
'Personal weblog clone source ID' => 'Personal weblog clone source ID',
'Enter the ID of the weblog you wish to use as the source for new personal weblogs. The new weblog will be identical to the source except for the name, publishing paths and permissions.' => 'Enter the ID of the weblog you wish to use as the source for new personal weblogs. The new weblog will be identical to the source except for the name, publishing paths and permissions.',
'Your changes to [_1]\'s profile has been updated.' => 'Your changes to [_1]\'s profile has been updated.',
'While Movable Type may run, it is an <strong>untested and unsupported environment</strong>.  We strongly recommend upgrading to at least Perl [_1].' => 'While Movable Type may run, it is an <strong>untested and unsupported environment</strong>.  We strongly recommend upgrading to at least Perl [_1].',
'List Users' => 'List Users',
'Comment Pending Message' => 'Comment Pending Message',
'Your profile has been updated.' => 'Your profile has been updated.',
'Weblog Associations' => 'Weblog Associations',
'Other...' => 'Other...',
'Movable Type Enterprise has just attempted to disable your account during synchronization with the external directory. Some of the external user management settings must be wrong. Please correct your configuration before proceeding.' => 'Movable Type Enterprise has just attempted to disable your account during synchronization with the external directory. Some of the external user management settings must be wrong. Please correct your configuration before proceeding.',
'Third-Party Services' => 'Third-Party Services',
'all rows' => 'all rows',
'Another amount...' => 'Another amount...',
'Step 4 of 4' => 'Step 4 of 4',
'We were unable to create your configuration file. If you would like to check the directory permissions and retry, click the \'Retry\' button.' => 'We were unable to create your configuration file. If you would like to check the directory permissions and retry, click the \'Retry\' button.',
'The settings below have been written to the file <tt>[_1]</tt>. If any of these settings are incorrect, you may click the \'Back\' button below to reconfigure them.' => 'The settings below have been written to the file <tt>[_1]</tt>. If any of these settings are incorrect, you may click the \'Back\' button below to reconfigure them.',
'Step 2 of 4' => 'Step 2 of 4',
'Database Path' => 'Database Path',
'The physical file path for your BerkeleyDB or SQLite database. ' => 'The physical file path for your BerkeleyDB or SQLite database. ',
'A default location of \'./db\' will store the database file(s) underneath your Movable Type directory.' => 'A default location of \'./db\' will store the database file(s) underneath your Movable Type directory.',
'You must set your Database Path.' => 'You must set your Database Path.',
'Step 1 of 4' => 'Step 1 of 4',
'Installation instructions.' => 'Installation instructions.',
'Enable External User Management' => 'Enable External User Management',
'Synchronization Frequency' => 'Synchronization Frequency',
'Frequency of synchronization in minutes. (Default is 60 minutes)' => 'Frequency of synchronization in minutes. (Default is 60 minutes)',
'Search Results (max 10 entries)' => 'Search Results (max 10 entries)',
'No groups were found with these settings.' => 'No groups were found with these settings.',
'IP Address:' => 'IP Address:',
'Some ([_1]) of the selected user(s) could not be updated.' => 'Some ([_1]) of the selected user(s) could not be updated.',
'Last Entry' => 'Last Entry',
'An error occured during synchronization.  See the <a href=\'[_1]\'>activity log</a> for detailed information.' => 'An error occured during synchronization.  See the <a href=\'[_1]\'>activity log</a> for detailed information.',
'You can not add disabled users to groups.' => 'You can not add disabled users to groups.',
'Below is a list of the members in the <b>[_1]</b> group. Click on a user\'s username to see the details for that user.' => 'Below is a list of the members in the <b>[_1]</b> group. Click on a user\'s username to see the details for that user.',
'You can not add users to a disabled group.' => 'You can not add users to a disabled group.',
'You need to create some roles.' => 'You need to create some roles.',
'Before you can do this, you need to create some roles. <a href="javascript:void(0);" onclick="closeDialog(\'[_1]\');">Click here</a> to create a role.' => 'Before you can do this, you need to create some roles. <a href="javascript:void(0);" onclick="closeDialog(\'[_1]\');">Click here</a> to create a role.',
'You need to create some groups.' => 'You need to create some groups.',
'Before you can do this, you need to create some groups. <a href="javascript:void(0);" onclick="closeDialog(\'[_1]\');">Click here</a> to create a group.' => 'Before you can do this, you need to create some groups. <a href="javascript:void(0);" onclick="closeDialog(\'[_1]\');">Click here</a> to create a group.',
'You need to create some users.' => 'You need to create some users.',
'Before you can do this, you need to create some users. <a href="javascript:void(0);" onclick="closeDialog(\'[_1]\');">Click here</a> to create a user.' => 'Before you can do this, you need to create some users. <a href="javascript:void(0);" onclick="closeDialog(\'[_1]\');">Click here</a> to create a user.',
'You need to create some weblogs.' => 'You need to create some weblogs.',
'Before you can do this, you need to create some weblogs. <a href="javascript:void(0);" onclick="closeDialog(\'[_1]\');">Click here</a> to create a weblog.' => 'Before you can do this, you need to create some weblogs. <a href="javascript:void(0);" onclick="closeDialog(\'[_1]\');">Click here</a> to create a weblog.',
'Invalid login attempt from user \'[_1]\' (ID: [_2])' => 'Invalid login attempt from user \'[_1]\' (ID: [_2])',
'Failed login attempt with incorrect password by user \'[_1]\' (ID: [_2])' => 'Failed login attempt with incorrect password by user \'[_1]\' (ID: [_2])',
'User \'[_1]\' (user #[_2]) logged in successfully' => 'User \'[_1]\' (user #[_2]) logged in successfully',
'User \'[_1]\' (user #[_2]) logged out' => 'User \'[_1]\' (user #[_2]) logged out',
'New TrackBack for entry #[_1] \'[_2]\'.' => 'New TrackBack for entry #[_1] \'[_2]\'.',
'New TrackBack for category #[_1] \'[_2]\'.' => 'New TrackBack for category #[_1] \'[_2]\'.',
'TrackBack for category #[_1] \'[_2]\'.' => 'TrackBack for category #[_1] \'[_2]\'.',
'Advanced' => 'Advanced',
'No birthplace, cannot recover password' => 'No birthplace, cannot recover password',
'Password was reset for user \'[_1]\' (ID:[_2]) and sent to address: [_3]' => 'Password was reset for user \'[_1]\' (ID:[_2]) and sent to address: [_3]',
'Application log for blog \'[_1]\' reset by \'[_2]\' (user #[_3])' => 'Application log for blog \'[_1]\' reset by \'[_2]\' (user #[_3])',
'Application log reset by \'[_1]\' (user #[_2])' => 'Application log reset by \'[_1]\' (user #[_2])',
'Category \'[_1]\' created by \'[_2]\' (user #[_3])' => 'Category \'[_1]\' created by \'[_2]\' (user #[_3])',
'Weblog \'[_1]\' created by \'[_2]\' (user #[_3])' => 'Weblog \'[_1]\' created by \'[_2]\' (user #[_3])',
'User \'[_1]\' created by \'[_2]\' (user #[_3])' => 'User \'[_1]\' created by \'[_2]\' (user #[_3])',
'Template \'[_1]\' created by \'[_2]\' (user #[_3])' => 'Template \'[_1]\' created by \'[_2]\' (user #[_3])',
'Weblog \'[_1]\' deleted by \'[_2]\' (user #[_3])' => 'Weblog \'[_1]\' deleted by \'[_2]\' (user #[_3])',
'Notification \'[_1]\' (#[_2]) deleted by \'[_3]\' (user #[_4])' => 'Notification \'[_1]\' (#[_2]) deleted by \'[_3]\' (user #[_4])',
'User \'[_1]\' (#[_2]) deleted by \'[_3]\' (user #[_4])' => 'User \'[_1]\' (#[_2]) deleted by \'[_3]\' (user #[_4])',
'Category \'[_1]\' (category #[_2]) deleted by \'[_3]\' (user #[_4])' => 'Category \'[_1]\' (category #[_2]) deleted by \'[_3]\' (user #[_4])',
'Comment \'[_1]\' (#[_2]) deleted by \'[_3]\' (user #[_4]) from entry \'[_5]\' (entry #[_6])' => 'Comment \'[_1]\' (#[_2]) deleted by \'[_3]\' (user #[_4]) from entry \'[_5]\' (entry #[_6])',
'Entry \'[_1]\' (entry #[_2]) deleted by \'[_3]\' (user #[_4])' => 'Entry \'[_1]\' (entry #[_2]) deleted by \'[_3]\' (user #[_4])',
'Ping \'[_1]\' (ping #[_2]) deleted by \'[_3]\' (user #[_4])' => 'Ping \'[_1]\' (ping #[_2]) deleted by \'[_3]\' (user #[_4])',
'Template \'[_1]\' (#[_2]) deleted by \'[_3]\' (user #[_4])' => 'Template \'[_1]\' (#[_2]) deleted by \'[_3]\' (user #[_4])',
'Tags \'[_1]\' (tags #[_2]) deleted by \'[_3]\' (user #[_4])' => 'Tags \'[_1]\' (tags #[_2]) deleted by \'[_3]\' (user #[_4])',
'User \'[_1]\' (#[_2]) trusted commenter \'[_3]\' (#[_4]).' => 'User \'[_1]\' (#[_2]) trusted commenter \'[_3]\' (#[_4]).',
'User \'[_1]\' (#[_2]) banned commenter \'[_3]\' (#[_4]).' => 'User \'[_1]\' (#[_2]) banned commenter \'[_3]\' (#[_4]).',
'User \'[_1]\' (#[_2]) unbanned commenter \'[_3]\' (#[_4]).' => 'User \'[_1]\' (#[_2]) unbanned commenter \'[_3]\' (#[_4]).',
'User \'[_1]\' (#[_2]) untrusted commenter \'[_3]\' (#[_4]).' => 'User \'[_1]\' (#[_2]) untrusted commenter \'[_3]\' (#[_4]).',
'Invalid username \'[_1]\' in password recovery attempt' => 'Invalid username \'[_1]\' in password recovery attempt',
'Username or password recovery phrase is incorrect.' => 'Username or password recovery phrase is incorrect.',
'Password recovery for user \'[_1]\' failed due to lack of recovery phrase specified in profile.' => 'Password recovery for user \'[_1]\' failed due to lack of recovery phrase specified in profile.',
'No password recovery phrase set in user profile. Please see your system administrator for password recovery.' => 'No password recovery phrase set in user profile. Please see your system administrator for password recovery.',
'Invalid attempt to recover password (used recovery phrase \'[_1]\')' => 'Invalid attempt to recover password (used recovery phrase \'[_1]\')',
'Username or password recovery phrase is incorrect.' => 'Username or password recovery phrase is incorrect.',
'Password recovery for user \'[_1]\' failed due to lack of email specified in profile.' => 'Password recovery for user \'[_1]\' failed due to lack of email specified in profile.',
'No email specified in user profile.  Please see your system administrator for password recovery.' => 'No email specified in user profile.  Please see your system administrator for password recovery.',
'New comment for entry #[_1] \'[_2]\'.' => 'New comment for entry #[_1] \'[_2]\'.',
'IP Address:' => 'IP Address:',
'Commenter Feed (Disabled)' => 'Commenter Feed (Disabled)',
'Authored On' => 'Authored On',
'Error during upgrade: [_1]' => 'Error during upgrade: [_1]',
'Enables use of the MTMultiBlog tag without include_blogs/exclude_blogs attributes. Comma-separated BlogIDs or \'all\' (include_blogs only) are acceptable values.' => 'Enables use of the MTMultiBlog tag without include_blogs/exclude_blogs attributes. Comma-separated BlogIDs or \'all\' (include_blogs only) are acceptable values.',



);

1;
