/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gestures for Mozilla.
 *
 * The Initial Developer of the Original Code is Jochen.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Jens Bannmann <jens.b@web.de> (mappingsLocalizer)
 *  Jochen <bugs@krickelkrackel.de>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var mgPrefs = {
  init : function() {
    if (!this.prefs) {
      var prefService = Components.classes["@mozilla.org/preferences-service;1"]
                        .getService(Components.interfaces.nsIPrefService);

      this.root = prefService.getBranch(null);   // root preferences branch
      this.prefs = prefService.getBranch("mozgest.");
    }

    var g = this.get;
    var p = this;

    for (var each in mgDefaultSettings.defaultPrefs.prefs)
      p[each] = g(each);

    if (p.lefthanded)
      p.mousebutton = Math.abs(p.mousebutton - 2);

    p.gestureCondition = "e.button==" + p.mousebutton;

    if (p["modifier.ctrl"] && !p["modifier.ctrlDisables"])
      p.gestureCondition += " && e.ctrlKey";
    if (p["modifier.alt"] && !p["modifier.altDisables"])
      p.gestureCondition += " && e.altKey";
    if (p["modifier.shift"] && !p["modifier.shiftDisables"])
      p.gestureCondition += " && e.shiftKey";
    if (navigator.platform.indexOf("Mac") == 0 && (p["modifier.meta"] && !p["modifier.metaDisables"]))
      p.gestureCondition += " && e.metaKey";
  },

  get : function(name) {
    if (!name || !(name in mgDefaultSettings.defaultPrefs.prefs))
      return null;

    var mgDefault = mgDefaultSettings.defaultPrefs.prefs[name];
    var getter;
    var setter;

    switch(typeof mgDefault[0]) {
      case "number":
        getter = mgPrefs.prefs.getIntPref;
        setter = mgPrefs.prefs.setIntPref;
        break;
      case "boolean":
        getter = mgPrefs.prefs.getBoolPref;
        setter = mgPrefs.prefs.setBoolPref;
        break;
      case "string":
        getter = mgPrefs.prefs.getCharPref;
        setter = mgPrefs.prefs.setCharPref;
        break;
      default:
        break;
    }

    var notfound = false;
    var value;

    try {
      value = getter(name);
    }
    catch (e) {
      notfound = true;
    }

    if (notfound || (getter == mgPrefs.prefs.getIntPref && (value < mgDefault[1] || value > mgDefault[2]))) {
      setter(name, mgDefault[0]);
      value = mgDefault[0];
    }

    return value;
  }
}

var mgCommon = {
  winMediator  : Components.classes["@mozilla.org/appshell/window-mediator;1"]
                 .getService(Components.interfaces.nsIWindowMediator),

  winWatcher   : Components.classes["@mozilla.org/embedcomp/window-watcher;1"]
                 .getService().QueryInterface(Components.interfaces.nsIWindowWatcher),

  prompt       : Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                 .getService(Components.interfaces.nsIPromptService),

  mouseService : false,

  init : function() {
    this.bundle = Components.classes["@mozilla.org/intl/stringbundle;1"].getService()
                  .QueryInterface(Components.interfaces.nsIStringBundleService)
                  .createBundle("chrome://mozgest/locale/mozgest.properties");

    this.getString = this.bundle.GetStringFromName;

    this.appInfo.init();
    this.mappingLocalizer.init();
    this.componentLoader.initMouseService();
    setTimeout("mgCommon.bmService.init()", 0);
  },

  componentLoader : {
    init : false,

    initMouseService : function() {
      if (this.init)
        return;

      this.init = true;

      if (("@mousegestures.org/mgMouseService;1" in Components.classes)) {
        try {
          mgCommon.mouseService = Components.classes["@mousegestures.org/mgMouseService;1"]
                                  .getService().QueryInterface(Components.interfaces.mgIMouseService);
        }
        catch (e) {}
      }
    }
  },

  appInfo : {
    init : function() {
      var em = Components.classes["@mozilla.org/extensions/manager;1"]
               .getService(Components.interfaces.nsIExtensionManager);

      this.mozgestID = "{FFA36170-80B1-4535-B0E3-A4569E497DD0}";
      this.mozgestVersion = em.getItemForID(this.mozgestID).version;
      var instLoc = em.getInstallLocation(this.mozgestID);
      var itemLoc = instLoc.getItemLocation(this.mozgestID);

      var fileHandler = Components.classes["@mozilla.org/network/io-service;1"]
                        .getService(Components.interfaces.nsIIOService);

      mgPrefs.prefs.setCharPref("misc.location", fileHandler.newFileURI(itemLoc).spec);

      var pHandler = Components.classes['@mozilla.org/network/io-service;1']
                     .getService(Components.interfaces.nsIIOService)
                     .getProtocolHandler('http')
                     .QueryInterface(Components.interfaces.nsIHttpProtocolHandler);

      this.geckoVersion = pHandler.misc.substring(3);
      this.geckoShortVersion = this.geckoVersion.substring(0,3);
      this.oscpu = pHandler.oscpu;
      this.platform = pHandler.platform;

      var appInfo = Components.classes["@mozilla.org/xre/app-info;1"]
                    .getService(Components.interfaces.nsIXULAppInfo);

      this.appBuildID = appInfo.appBuildID;
      this.ID = appInfo.ID;
      this.name = appInfo.name;

      switch(appInfo.ID) {
        case "{ec8030f7-c20a-464f-9b0e-13a3a9e97384}":
          this.name = "Firefox";
          break;
        case "{3550f703-e582-4d05-9a08-453d09bdfdc6}":
          this.name = "Thunderbird";
          break;
        case "{92650c4d-4b8e-4d2a-b7eb-24ecf4f6b63a}":
          this.name = "SeaMonkey";
          break;
      }

      this.os = appInfo.QueryInterface(Components.interfaces.nsIXULRuntime).OS;
      this.platformBuildID = appInfo.platformBuildID;
      this.vendor = appInfo.vendor;
      this.version = appInfo.version;
    }
  },

  dump : function(aText) {
    try {
      if (mgPrefs["enableDump"])
        dump("Mozgest: " + aText + "\n");
    }
    catch (e) {}
  },

  showWebPage : function(pageUrl) {
    var browserWindow = this.winMediator.getMostRecentWindow("navigator:browser");

    if (browserWindow) {
      try {
        browserWindow.gBrowser.selectedTab = browserWindow.gBrowser.addTab(pageUrl, null, null);
      }
      catch(e) {}
    }
    else {
      var uri = Components.classes["@mozilla.org/network/standard-url;1"]
                .createInstance(Components.interfaces.nsIURI);
      uri.spec = pageUrl;

      var protocolSvc = Components.classes["@mozilla.org/uriloader/external-protocol-service;1"]
                        .getService(Components.interfaces.nsIExternalProtocolService);
      protocolSvc.loadUrl(uri);
    }
  },

  compactCode : function(aCode) {
    var compacted = aCode.substr(0, 1);
    for (var i = 1; i < aCode.length; i++) {
      var c = aCode.substr(i, 1);
      if (c != compacted.substr(compacted.length - 1, 1))
        compacted += c;
    }
    return compacted;
  },

  addTreeRow : function(tChildren, args, id, imgSrc) {
    var ti = document.createElement("treeitem");
    ti.id = id;
    var row = document.createElement("treerow");

    for (var i = 0; i < args.length; i++) {
      var cell = document.createElement("treecell");

      if (i == 1 && imgSrc)
         cell.setAttribute("src", imgSrc);

      cell.setAttribute("label", args[i]);
      row.appendChild(cell);
    }

    ti.appendChild(row);
    tChildren.appendChild(ti);
  },

  openDialog : function(aURL, aParams) {
    if (!this.checkWindowOpen(aURL)) {
      var features = "centerscreen,chrome,resizable,dependent";

      if (mgCommon.appInfo.platform == "Macintosh")
        features = features + ",dialog=no";

      if (aURL == "chrome://mozgest/content/sidebar/mozgestSidebar.xul")
        this.winWatcher.openWindow(null, aURL, "", "chrome,resizable,dialog=no", null);
      else if (aParams)
        openDialog(aURL, "", features, aParams);
      else
        openDialog(aURL, "", features);
    }
  },

  checkWindowOpen : function(aURL, checkOnly) {
    var retVal = false;
    var fromSetting = (document.location.toString().indexOf("chrome://mozgest/content/pref/") == 0) ? true : false;
    var enumText = "mozgest:settingWindow";

    if (aURL == "chrome://mozgest/content/sidebar/mozgestSidebar.xul")
      enumText = "mozgest:sidebarWindow";

    var enumerator = mgCommon.winMediator.getEnumerator(enumText);

    if (enumerator.hasMoreElements()) {
      retVal = true;
      var winArray = new Array();

      while (enumerator.hasMoreElements()) {
        var winToFind = enumerator.getNext();
        winArray[winToFind.document.location] = true;
      }

      if (checkOnly && (aURL in winArray))
        return true;

      if (aURL in winArray)
        retVal = true;
      else if (fromSetting)
        retVal = false;

      var enum2 = mgCommon.winMediator.getEnumerator(enumText);

      while (enum2.hasMoreElements()) {
        var win2 = enum2.getNext();
        win2.focus();
      }
    }

    return retVal;
  },

  makeURI : function(href) {
    var ioService = Components.classes["@mozilla.org/network/io-service;1"]
                    .getService(Components.interfaces.nsIIOService);
    return ioService.newURI(href, null, null);
  },

  notifyObservers : function(aboutWhat) {
    Components.classes["@mozilla.org/observer-service;1"]
    .getService(Components.interfaces.nsIObserverService)
    .notifyObservers(null, "mozgestControl", aboutWhat);
  },

  processURL : function (url, docLoc) {
    url = url.substr(10);
    var parts = url.split("/");

    // check whether command is valid
    switch (parts[0]) {
      case "addmapping":
        this.importMapping(parts, docLoc);
        break;
      case "addgestureset":
        this.importSet(url.substring(14), docLoc);
        break;
      default:
        return;
    }
  },

  importSet : function (url) {
    var aURI;
    try {
      aURI = mgCommon.makeURI(url);
    }
    catch (e) {
      return;
    }
    mgCommon.openDialog("chrome://mozgest/content/pref/importSet.xul", [aURI]);
  },

  importMapping : function (parts, docLoc) {
    if (mgCommon.checkWindowOpen("chrome://mozgest/content/pref/mappings.xul"))
      return;

    if (parts[1] == "window")
      parts[1] = mgWindowType;

    var wTtile = mgCommon.getString("ImportMappingWindow");

    if (!(parts[1] in _mgMS.supportedWindows)) {
      var msg = mgCommon.getString("unknownWindowType");
      msg = msg.replace(/%WINDOWTYPE%/, parts[1]);
      mgCommon.prompt.alert(null, wTtile, msg);
      return;
    }

    var invalidText = mgCommon.getString("invalidCode");

    if (parts[3] != "custom") {
      mgCommon.prompt.alert(null, wTtile,invalidText);
      return;
    }

    var code = false;
    var gestureRegExp = /^(\*{0,1}[1379DLUR]+){1}(;\*{0,1}[1379DLUR]+){0,1}$/;

    if (parts[2].match(/^:[0-2][0-2\+\-]$/) || gestureRegExp.exec(parts[2]))
      code = parts[2];

    if (!code) {
      mgCommon.prompt.alert(null, wTtile, invalidText);
      return;
    }

    var name = "";
    var custom;

    try {
      var name = decodeURIComponent(parts[4]);
    }
    catch (e) {}

    try {
      custom = decodeURIComponent(parts[5]);
    }
    catch (e) {
      mgCommon.prompt.alert(null, wTtile, invalidText);
      return;
    }

    _mgMS.importLocation = docLoc;
    _mgMS.importWinType = parts[1];
    _mgMS.importCode = code;
    _mgMS.importName = name;
    _mgMS.importCustom = custom;

    if (parts.length >= 6 && parts[6].indexOf("cat") == 0)
      _mgMS.importCat = parts[6];
    else
      _mgMS.importCat = "cat0";

    mgCommon.openDialog("chrome://mozgest/content/pref/mappings.xul", ["Import", parts[1], code]);
  },

  mappingLocalizer : {
    dict : null,
    reverse : null,

    init : function() {
      this.gs = mgCommon.getString;
      this.dict = new Array();
      this.dict["R"] = this.gs("a.right");
      this.dict["L"] = this.gs("a.left");
      this.dict["U"] = this.gs("a.up");
      this.dict["D"] = this.gs("a.down");
      this.dict["1"] = this.gs("a.d1");
      this.dict["3"] = this.gs("a.d3");
      this.dict["7"] = this.gs("a.d7");
      this.dict["9"] = this.gs("a.d9");

      this.reverse = new Array();
      var dic = this.dict;

      for (var loc in dic)
        this.reverse[dic[loc]] = loc;
    },

    localize : function(orig) {
      return this.convert(orig, this.dict);
    },

    deLocalize : function(localized) {
      return this.convert(localized, this.reverse);
    },

    convert : function(str, table) {
      if (!str)
        return "";

      if (str.substring(0,1) == ":")
        return str;

      var trans = "";

      for (var i = 0; i < str.length; i++) {
        var o = str.substring(i, i+1);

        if (o != "*" && table[o])
          trans = trans + table[o];
        else
          trans = trans + o;
      }
      return trans;
    }
  },

  backup : {
    cc      : Components.classes,
    ci      : Components.interfaces,

    manualExport : function() {
      var title = mgCommon.getString("expTitle");
      _mgMS.writeMappingsToFile(false);
      var mappingsFile = _mgMS.getMappingsFile();

      var fp = this.cc["@mozilla.org/filepicker;1"].createInstance(this.ci.nsIFilePicker);
      fp.init(window, title, fp.modeSave);

      var now = new Date();
      var year = now.getFullYear();
      var month = now.getMonth() +1;
      month = (month < 10) ? "0"+month : month;
      var day = now.getDate();
      day = (day < 10) ? "0"+day : day;

      fp.defaultString = "mousegestures3_backup_"+mgCommon.appInfo.name+"_"+year+month+day+".js";
      var retVal = fp.show();

      if (retVal == fp.returnOK || retVal == fp.returnReplace) {
        try {
          if (retVal == fp.returnReplace)
            fp.file.remove(false);

          mappingsFile.copyTo(fp.file.parent, fp.file.leafName);
          mgCommon.prompt.alert(null, mgCommon.getString('expTitle'),
                                      mgCommon.getString('expSuccess'));
        }
        catch (e) {}
      }
    },

    manualImport : function() {
      var fp = this.cc["@mozilla.org/filepicker;1"].createInstance(this.ci.nsIFilePicker);
      fp.init(window, mgCommon.getString("impTitle"), fp.modeOpen);
      var retVal = fp.show();

      if (retVal == fp.returnOK)
        mgCommon.processURL("mozgest://addgestureset/" + fp.fileURL.spec, null);
    },

    restoreDefault : function(label) {
      try {
        _mgMS.writeMappingsToFile(true);
        _mgMS.getActiveMappings();
        mgCommon.prompt.alert(null, label, mgCommon.getString('restoreSuccess'));
      }
      catch (err) {}
    }
  },

  bmService : {
    enabled : false,
    cc : Components.classes,
    ci : Components.interfaces,

    init : function() {
      if ("@mozilla.org/browser/bookmarks-service;1" in this.cc) {
        this.enabled = true;

        this.RDFS = this.cc["@mozilla.org/rdf/rdf-service;1"].getService(this.ci.nsIRDFService);
        this.Book = this.RDFS.GetDataSource("rdf:bookmarks");
        this.Icon = this.RDFS.GetResource("http://home.netscape.com/NC-rdf#Icon");
        this.Href = this.RDFS.GetResource("http://home.netscape.com/NC-rdf#URL");
        this.Type = this.RDFS.GetResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        this.Name = this.RDFS.GetResource("http://home.netscape.com/NC-rdf#Name");
        this.KeyW = this.RDFS.GetResource("http://home.netscape.com/NC-rdf#ShortcutURL");
        this.Post = this.RDFS.GetResource("http://home.netscape.com/NC-rdf#PostData");
      }
      else if ("@mozilla.org/browser/nav-history-service;1" in this.cc) {
        this.plEnabled = true;

        this.plHist = this.cc["@mozilla.org/browser/nav-history-service;1"]
                      .getService(this.ci.nsINavHistoryService);
        this.plBook = this.cc["@mozilla.org/browser/nav-bookmarks-service;1"]
                      .getService(this.ci.nsINavBookmarksService);
        this.plLive = this.cc["@mozilla.org/browser/livemark-service;2"]
                      .getService(this.ci.nsILivemarkService);
        this.plIcon = this.cc["@mozilla.org/browser/favicon-service;1"]
                      .getService(this.ci.nsIFaviconService);
      }
    },

    bmInfo : {
      title : null,
      uri : null,
      key : null,
      icon : null,
      isLive : null,
      isBookmark : null,

      getBMInfo : function(bmId, getMore) {
        this.title = null;
        this.uri = null;
        this.key = null;
        this.icon = null;
        this.isLive = null;
        this.isBookmark = null;

        var bmS = mgCommon.bmService;
        var ci = Components.interfaces;

        if ("@mozilla.org/browser/bookmarks-service;1" in Components.classes) {
          try {
            this.uri = bmS.Book.GetTarget(bmS.RDFS.GetResource(bmId), bmS.Href, true);

            if (this.uri) {
              this.uri = this.uri.QueryInterface(ci.nsIRDFLiteral).Value;
              this.uri = mgCommon.makeURI(this.uri);
            }

            this.title = bmS.Book.GetTarget(bmS.RDFS.GetResource(bmId), bmS.Name, true);

            if (this.title)
              this.title = this.title.QueryInterface(ci.nsIRDFLiteral).Value;

            if (!this.title && this.uri)
              this.title = (this.uri.host != "") ? this.uri.host : this.uri.spec;

            this.key = bmS.Book.GetTarget(bmS.RDFS.GetResource(bmId), bmS.KeyW, true);

            if (this.key)
              this.key = this.key.QueryInterface(ci.nsIRDFLiteral).Value;

            if (getMore) {
              this.icon = bmS.Book.GetTarget(bmS.RDFS.GetResource(bmId), bmS.Icon, true);

              if (this.icon)
                this.icon = this.icon.QueryInterface(ci.nsIRDFLiteral).Value;
              else
                this.icon = "chrome://mozgest/skin/placeholder.png";

              var check = bmS.Book.GetTarget(bmS.RDFS.GetResource(bmId), bmS.Type, true);
              check = check.QueryInterface(ci.nsIRDFResource).Value.toLowerCase();

              if (check == "http://home.netscape.com/nc-rdf#livemark")
                this.isLive = true;

              if (check == "http://home.netscape.com/nc-rdf#bookmark")
                this.isBookmark = true;
            }
          }
          catch (err) {}
        }
        else if ("@mozilla.org/browser/nav-history-service;1" in Components.classes) {
          try {
            this.uri = bmS.plBook.getBookmarkURI(bmS.plBook.getItemIdForGUID(bmId));
            this.title = bmS.plBook.getItemTitle(bmS.plBook.getItemIdForGUID(bmId));

            if (!this.title && this.uri)
              this.title = (this.uri.host != "") ? this.uri.host : this.uri.spec;

            this.key =  bmS.plBook.getKeywordForBookmark(bmS.plBook.getItemIdForGUID(bmId));

            if (getMore)
              this.icon = bmS.plIcon.getFaviconImageForPage(this.uri).spec;
          }
          catch (err) {}
        }
      }
    }
  }
}

mgDefaultSettings.defaultPrefs.init();
mgPrefs.init();
mgCommon.init();

var _mgMS = Components.classes["@mousegestures.org/mgMappingsService;1"].getService();
_mgMS = _mgMS.wrappedJSObject;
_mgMS.initMappings();