/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gestures for Mozilla.
 *
 * The Initial Developer of the Original Code is Pavol Vaskovic.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Andy Edmonds <aedmonds@mindspring.com>
 *  Benjamin K. Stuhl <tiriath@yahoo.com>
 *  Brent Schartung <bschartung@gmail.com>
 *  David Illsley <illsleydc@bigfoot.com>
 *  Dorando <mozilla@dorando.at>
 *  HJ van Rantwijk <bugs4HJ@netscape.net>
 *  Jens Bannmann <jens.b@web.de>
 *  Jochen <bugs@krickelkrackel.de>
 *  Martin.T.Kutschker <Martin.T.Kutschker@blackbox.net>
 *  Pavol Vaskovic <pali@pali.sk>
 *  Pekka Aleksi Knuutila <aleksi.knuutila@edu.lahti.fi>
 *  Scott R. Turner <srt@aero.org>
 *  Tim Williamson <chsman@hotmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

//----------------------
//-- Global variables --
//----------------------
var gestureInProgress = false;
var globalOnLink = false; //array that holds a list of all the links traversed during gesture
var globalOnImage = false; //string containing an image href or false
var globalSrcEvent = false; //event which started the active gesture.

var mgWindowElements = {
  statusPopup : null,
  popup : null,
  content : null
}

var mgGestureState = {
  srcEvent : null,
  endEvent : null,
  s : "", //array holding localized stroke names
  currentNode : null,
  gestureDone : false,
  previousSelection : null,
  inputField : null,
  oX : 0, oY : 0,
  gridMoves : new Array(),
  gesture : new Array(),
  localizedGesture : new Array(),
  rockerCode : "",
  gestureTimeout : null,
  statusTimeout : null,
  allowContext : false,
  dismiss : false,
  history : new Array(),
  linkCollection : false,
  imageCollection : false,
  excludedNodes : new Object({"object" : true, "embed" : true}),
  excludedSites : new Array(),
  pluginRape : false,
  lastError : ""
};

var mgObserver = {
  mgPrefTimeout    : null,
  mgRockerInterval : null,
  obs              : Components.classes["@mozilla.org/observer-service;1"]
                     .getService(Components.interfaces.nsIObserverService),

  createEvt : function(what, data) {
    var mData = data.split("|");
    var evt = document.createEvent("MouseEvents");
    evt.initMouseEvent(what, 1, 1, window, 1,
                       mData[1], mData[2], 0, 0, 0, 0, 0, 0, mData[0], window);

    return evt;
  },

  observe : function(subject, topic, data) {
    /*when MozGest pref was changed, we reinitialize
     (except when sidebar settings changed)
     use a timeout to avoid multiple inits if more than
     one pref was changed. Not bullet proof. */
    if (topic.indexOf("nsPref") == 0) {
      if (data.indexOf("misc.") == 0 ||
          (data.indexOf("trails.") == 0 && data != "trails.enabled"))
        return;

      clearTimeout(mgObserver.mgPrefTimeout);
      mgObserver.mgPrefTimeout = setTimeout(mgInitHandler.init, 200, false);
    }

    if (topic == "domwindowopened")
      mgGestureExecute.mgResetRocker(true);

    if (topic == "mozgestStop")
      mgGestureState.dismiss = (data == "true") ? true : false;

    if (topic == "mozgestButtonUp") {
      mgObserver.mgClearInterval();

      if (mgCommon.winWatcher.activeWindow != window) {
        mgGestureExecute.mgResetRocker(true);
        return;
      }

      try {
        mgGestureRecognizer.endGesture(this.createEvt("mouseup", data), true);
        gestureInProgress = false;
      }
      catch (err) {}
    }

    if (mgCommon.winWatcher.activeWindow != window)
      return;

    if (topic == "mozgestButtonDown") {
      mgObserver.mgClearInterval();

      if (mgCommon.appInfo.platform != "Windows") {
        try {
          var p = mgWindowElements.popup;
          var evt = this.createEvt("mousedown", data);

          if (p && mgGestureHelper.mouseInContent(evt)) {
            p = (p.wrappedJSObject) ? p.wrappedJSObject : p;
            var bx = p.boxObject;

            if (evt.screenX >= bx.screenX &&
                evt.screenY >= bx.screenY &&
                evt.screenX <= bx.screenX + bx.width &&
                evt.screenY <= bx.screenY + bx.height)
              return;
            else if (p.id != "autoscroller")
              p.hidePopup();
          }
        }
        catch (err) {}
      }
    }

    if (topic == "mozgestPluginButtonDown") {
      var evt = this.createEvt("mousedown", data);
      mgGestureRecognizer.startGesture(evt, false, false)
    }

    if (topic == "mozgestRockerDown") {
      mgObserver.mgClearInterval();
      gestureInProgress = false;

      try {
        var evt = this.createEvt("mousedown", data);
        mgGestureRecognizer.startGesture(evt, false, true);

        if (mgPrefs.staticRockers)
          mgObserver.mgSetInterval(evt, false, true);
      }
      catch (e) {}
    }
  },

  register : function() {
    mgPrefs.prefs.QueryInterface(Components.interfaces.nsIPrefBranch2)
           .addObserver("", this, false);

    mgCommon.winWatcher.registerNotification(this);

    if (mgCommon.mouseService) {
      this.obs.addObserver(this, "mozgestButtonUp", false);
      this.obs.addObserver(this, "mozgestButtonDown", false);
      this.obs.addObserver(this, "mozgestRockerDown", false);
      this.obs.addObserver(this, "mozgestPluginButtonDown", false);
      this.obs.addObserver(this, "mozgestStop", false);
    }
  },

  unregister : function() {
    mgPrefs.prefs.QueryInterface(Components.interfaces.nsIPrefBranch2)
           .removeObserver("", this);

    mgCommon.winWatcher.unregisterNotification(this);

    if (mgCommon.mouseService) {
      this.obs.removeObserver(this, "mozgestButtonUp");
      this.obs.removeObserver(this, "mozgestButtonDown");
      this.obs.removeObserver(this, "mozgestRockerDown");
      this.obs.removeObserver(this, "mozgestPluginButtonDown");
      this.obs.removeObserver(this, "mozgestStop");
    }
  },

  mgSetInterval : function(e, wheelCode) {
    mgObserver.mgClearInterval();

    if (e) {
      mgObserver.mgRockerInterval = setInterval(mgGestureRecognizer.startGesture,
                                                mgPrefs.staticRockersDelay, e);
    }
    else if (wheelCode) {
      mgObserver.mgRockerInterval = setInterval(mgGestureExecute.mgFireRocker,
                                                mgPrefs.staticWheelRockersDelay, wheelCode);
    }
  },

  mgClearInterval : function() {
    clearInterval(mgObserver.mgRockerInterval);
    mgObserver.mgRockerInterval = null;
  }
}

//--------------------------------
//-- Startup/shutdown functions --
//--------------------------------
var mgInitHandler = {
  startup : function(e) {
    window.removeEventListener("load", mgInitHandler.startup, false);

    if (mgWindowType) {
      mgCommon.dump("Startup");
      mgInitHandler.initNotification();
      mgInitHandler.loadStrings();
      mgInitHandler.init(true);
      mgObserver.register();
      window.addEventListener("unload", function () {mgObserver.unregister()}, false);
    }
  },

  init : function(fromStart) {
    if (!fromStart || !mgPrefs["grid"])
      mgPrefs.init();

    //toggle recognition on/off
    mgInitHandler.addWindowWatch(!mgPrefs["window." + mgWindowType]);

    var ms = mgCommon.mouseService;
    var gs = mgGestureState;
    gs.pluginRape = false;

    if (ms && ms.supports("plugins") && mgPrefs["pluginSupport"]) {
      gs.pluginRape = true;
      delete gs.excludedNodes["embed"];
      delete gs.excludedNodes["object"];
    }
    else {
      gs.excludedNodes["embed"] = true;
      gs.excludedNodes["object"] = true;
    }

    var ex = new Array();
    gs.excludedSites = new Array();
    ex = mgPrefs["sites.excluded"].split("|");

    for (var x = 0; x < ex.length;x++) {
      if (ex[x] != "")
        gs.excludedSites[ex[x]] = true;
    }
  },

  loadStrings : function() {
    //load localized strings
    var gs = mgGestureState;
    var s = mgCommon.getString;

    gs.s = new Array();
    gs.s["R"] = s("a.right");
    gs.s["L"] = s("a.left");
    gs.s["U"] = s("a.up");
    gs.s["D"] = s("a.down");
    gs.s["1"] = s("a.d1");
    gs.s["3"] = s("a.d3");
    gs.s["7"] = s("a.d7");
    gs.s["9"] = s("a.d9");
    gs.s["gesture"] = s("g.gesture");
  },

  addWindowWatch : function(removeOnly) {
    mgCommon.dump("Get Contentarea");
    var we = mgWindowElements;
    var gr = mgGestureRecognizer;
    var gi = mgIntegration;
    var ms = mgCommon.mouseService;

    we.content = mgWindowTypes.getContentArea();
    mgInitHandler.removeWindowWatch();

    if (removeOnly)
      return;

    mgCommon.dump("Adding Listeners");

    we.content.addEventListener("mousedown", gr.startGesture, true);
    window.addEventListener("mouseup", gr.endGesture, true);
    window.addEventListener("mousedown", gi.downListener, true);
    window.addEventListener("mousemove", gr.processCoordinates, true);

    if (mgPrefs.enableWheelRockers)
      we.content.addEventListener("DOMMouseScroll", gr.wheelHandler, true);

    we.content.addEventListener("draggesture", gi.dragListener, true);
    window.addEventListener("keydown", gi.allowContextByKeyPress, true);
    window.addEventListener("popupshowing", gi.popupListener, true);
    we.content.addEventListener("contextmenu", gi.contextMenuListener, true);
    we.content.addEventListener("click", gi.clickListener, true);
    we.content.addEventListener("dblclick", gi.clickListener, true);
  },

  removeWindowWatch : function() {
    mgCommon.dump("Removing Listeners");
    var we = mgWindowElements;
    var gr = mgGestureRecognizer;
    var gi = mgIntegration;
    var ms = mgCommon.mouseService;

    we.content.removeEventListener("mousedown", gr.startGesture, true);
    window.removeEventListener("mouseup", gr.endGesture, true);
    window.removeEventListener("mousedown", gi.downListener, true);
    window.removeEventListener("mousemove", gr.processCoordinates, true);
    we.content.removeEventListener("DOMMouseScroll", gr.wheelHandler, true);
    we.content.removeEventListener("draggesture", gi.dragListener, true);
    we.content.removeEventListener("contextmenu", gi.contextMenuListener, true);
    window.removeEventListener("keydown", gi.allowContextByKeyPress, true);
    window.removeEventListener("popupshowing", gi.popupListener, true);
    we.content.removeEventListener("click", gi.clickListener, true);
    we.content.removeEventListener("dblclick", gi.clickListener, true);
  },

  initNotification : function() {
    if (!document.getElementById("mozgestStatusPopup")) {
      mgWindowElements.statusPopup = document.createElement("tooltip");

      var p = mgWindowElements.statusPopup;
      p.id = "mozgestStatusPopup";
      p.setAttribute("onpopuphiding", "if (gestureInProgress) {event.preventDefault();}");
      p.setAttribute("onmouseover", "if (!gestureInProgress) {this.hidePopup();}");

      var l = document.createElement("label");
      l.id = "mozgestStatusLabel";
      l.setAttribute("crop", "end");
      l.setAttribute("flex", "1");
      p.appendChild(l);

      var sId = "mozgestPopupSet";
      var s = document.getElementById(sId);

      if (!s) {
        s = document.createElement("popupset");
        s.id = sId;
        document.documentElement.appendChild(s);
      }

      s.appendChild(p);

      document.documentElement.addEventListener("DOMAttrModified",
        function (e) {
          if (e.attrName == "active" && !e.newValue)
            mgGestureHelper.hideStatus();
        }, false);
    }
  }
}

//-----------------------
//-- Integration hooks --
//-- everything needed for co-existing with or disabling regular app functions
//-----------------------

var mgIntegration = {
  contextMenuListener : function(e) {
    if (!mgGestureState.allowContext) {
      e.preventDefault();
      e.stopPropagation();
    }
  },

  allowContextByKeyPress : function(e) {
    if (!gestureInProgress) {
      mgGestureState.allowContext = true;
      mgGestureState.gestureDone = false;
    }

    mgGestureHelper.hideStatus();
  },

  popupListener : function(e) {
    if (e.originalTarget.nodeName.indexOf("tooltip") != -1)
      return;

    mgGestureHelper.hideStatus();
    mgWindowElements.popup = e.originalTarget;

    if (e.target.id == "autoscroller") {
      if (!e.target.hasAttribute("mozgestWasHere")) {
        e.target.addEventListener("mousedown", function(evt) {mgGestureRecognizer.startGesture(evt, true)}, true);
        e.target.setAttribute("mozgestWasHere", true);
      }
    }
  },

  downListener : function(e) {
    if (e.button != mgPrefs.mousebutton)
      mgGestureHelper.hideStatus();
  },

  clickListener : function(e) {
    if (mgGestureState.gestureDone) {
      e.preventDefault();
      e.stopPropagation();
      return false;
    }

    if (e.button < 2) {
      var node = e.originalTarget;

      if (!node.localName || node.localName.toLowerCase() != "a")
        return null;

      if (!node.getAttribute || !node.hasAttribute("href"))
        return null;

      var href = node.getAttribute("href");

      if (href.indexOf("mozgest://") == 0) {
        mgCommon.processURL(href, node.ownerDocument.location);
        e.stopPropagation();
        e.preventDefault();
      }
    }
    return null;
  },

  dragListener : function(e) {
    if (gestureInProgress) {
      e.preventDefault();
      e.stopPropagation();
    }
  }
}

//---------------------------------
//-- The gesture recognizer core --
//---------------------------------

var mgGestureRecognizer = {
  processCoordinates : function(e) {
    var gs = mgGestureState;
    var gr = mgGestureRecognizer;

    if (gs.rockerCode.length > 1 &&
        (e.screenX < gs.oX -25 || e.screenX > gs.oX +25 ||
         e.screenY < gs.oY -25 || e.screenY > gs.oY +25))
      mgGestureExecute.mgResetRocker(true);

    if (!mgPrefs.enableStrokes || !gestureInProgress)
      return;

    if (gs.gesture.length < 1) {
      if (mgPrefs.mousebutton == 1 && (e.screenX != gs.oX || e.screenY != gs.oY)) {
        if (mgWindowTypes.stopAutoScroll())
          return;
      }
    }

    var x_dir = e.screenX - gs.oX;
    var y_dir = e.screenY - gs.oY;
    var x = Math.abs(x_dir);
    var y = Math.abs(y_dir);

    if (x >= mgPrefs.grid/2 || y >= mgPrefs.grid/2) { // process each half-grid
      //diagonal movement:
      //mgPrefs.diagonalTolerance = 75 means that a movement is recognized as diagonal when
      //x/y or y/x is between 0.25 and 1
      if ( mgPrefs.diagonalTolerance != 0 && ( (x/y >= (1-mgPrefs.diagonalTolerance/100) && x/y <= 1)
          || (y/x >= (1-mgPrefs.diagonalTolerance/100) && y/x <= 1) ) ) {

        if (x_dir < 0 && y_dir > 0)
          gr.mgPush("1");
        else if (x_dir > 0 && y_dir > 0)
          gr.mgPush("3");
        else if (x_dir < 0 && y_dir < 0)
          gr.mgPush("7");
        else if (x_dir > 0 && y_dir < 0)
          gr.mgPush("9");
      }
      //horizontal move:
      else if (x > y) {
        if (x_dir > 0)
          gr.mgPush("R");
        else if (x_dir < 0)
          gr.mgPush("L");
      }
      //vertical move:
      else if (x < y) {
        if (y_dir > 0)
          gr.mgPush("D");
        else if (y_dir < 0)
          gr.mgPush("U");
      }

      gs.oX = e.screenX;
      gs.oY = e.screenY;
    }

    clearTimeout(gs.gestureTimeout);
    gs.gestureTimeout = setTimeout(mgGestureRecognizer.endGesture, mgPrefs.delay, null);

    if (gs.currentNode != e.originalTarget)
      gr.examineElement(e.originalTarget);

    gs.currentNode = e.originalTarget;
  },

  mgPush : function(code) {
    var gs = mgGestureState;

    gs.gridMoves.push(code);
    if (gs.gridMoves.length == 2) {
      if (gs.gridMoves[0] == gs.gridMoves[1] || gs.gesture.length == 0)
        mgGestureRecognizer.mgDoPush(gs.gridMoves.pop());

      gs.gridMoves.length = 0;
    }
  },

  mgDoPush : function(code) {
    var gs = mgGestureState;

    if (gs.gesture[gs.gesture.length-1] != code) {
      gs.gesture.push(code);
      gs.localizedGesture.push(gs.s[code]);
      mgGestureHelper.showStatus(gs.gesture.join(""));
    }
  },

  examineElement : function(node, inContentCheck) {
    var imgNode = node;
    var CI = Components.interfaces;
    var gs = mgGestureState;

    if (inContentCheck) {
      if (mgCommon.mouseService && gs.rockerCode.length > 1)
        return true;

      globalOnLink = globalOnImage = gs.collectionsChecked = false;
      gs.linkCollection = new Array();
      gs.imageCollection = new Array();
      var checkNode = node;

      for (checkNode; checkNode; checkNode = checkNode.parentNode) {
        var n = checkNode.nodeName.toLowerCase();

        if ((n == "scrollbar" && mgPrefs.mousebutton != 2) ||
            (n in gs.excludedNodes) || checkNode instanceof CI.nsIDOMXULPopupElement)
          return false;
      }
    }

    for (node; node; node = node.parentNode) {
      if (node instanceof CI.nsIDOMHTMLAnchorElement ||
          node instanceof CI.nsIDOMHTMLAreaElement ||
          node instanceof CI.nsIDOMHTMLLinkElement) {
        gs.linkCollection[node.href] = node;
        break;
      }
    }

    for (imgNode; imgNode; imgNode = imgNode.parentNode) {
      if (imgNode instanceof CI.nsIDOMHTMLImageElement ||
          imgNode instanceof CI.nsIDOMHTMLCanvasElement) {
        try {
          if (imgNode instanceof CI.nsIDOMHTMLImageElement && imgNode.src)
            gs.imageCollection[imgNode.src] = imgNode;
          else
            gs.imageCollection[imgNode.toDataURL()] = imgNode;
        }
        catch (err) {
          break;
        }

        break;
      }
    }

    return true;
  },

  checkPrevent : function(e) {
    if (e.altKey && mgPrefs["modifier.altDisables"] ||
        e.ctrlKey && mgPrefs["modifier.ctrlDisables"] ||
        e.shiftKey && mgPrefs["modifier.shiftDisables"] ||
        e.metaKey && mgPrefs["modifier.metaDisables"] || mgGestureState.dismiss)
      return true;

    if (mgWindowType == "browser") {
      try {
        var uri = mgCommon.makeURI(content.document.documentURI);
        if (uri.host in mgGestureState.excludedSites)
          return true;
      }
      catch (err) {}
    }

    return false;
  },

  startGesture : function(e, isPopup, synth) {
    var gs = mgGestureState;
    var ms = mgCommon.mouseService;
    mgGestureExecute.mgReleaseRocker(e);
    gs.allowContext = false;
    gs.gestureDone = false;
    gs.oX = e.screenX;
    gs.oY = e.screenY;

    if (mgGestureRecognizer.checkPrevent(e) ||
        (!gestureInProgress && !mgGestureHelper.mouseInContent(e))) {
      gs.allowContext = true;
      return;
    }

    if (e.button != mgPrefs.mousebutton)
      mgGestureHelper.hideStatus();

    if (ms && !isPopup && !synth)
      ms.setContentRect(gs.ctx, gs.cty, gs.ctb, gs.ctWidth, gs.ctHeight, (e.button == 1) ? true : false);

    if (mgGestureRecognizer.examineElement(e.originalTarget, true) &&
        !mgGestureExecute.mgCheckForRocker(e) && !isPopup) {
      globalSrcEvent = gs.srcEvent = e;
      gs.currentNode = e.originalTarget;

      if (gs.pluginRape && e.button == 2 && gs.currentNode) {
        var nName = gs.currentNode.nodeName.toLowerCase();

        if (nName == "embed" || nName == "object") {
          gs.currentNode.mozgestPluginRape = true;
          e.stopPropagation();
        }
      }

      if (!gestureInProgress && mgPrefs.enableStrokes && eval(mgPrefs.gestureCondition)) {
        if (ms && mgPrefs["trails.enabled"])
          ms.initTrails();

        gestureInProgress = true;
        gs.gesture.length = gs.localizedGesture.length = 0;

        if (mgPrefs.mousebutton == 0) {
          gs.inputField = null;
          var nodeName;

          try {
            nodeName = gs.srcEvent.target.nodeName.toLowerCase();
          }
          catch (e) {}

          if (nodeName == "input" || nodeName == "textarea") {
            gs.inputField = gs.srcEvent.target;
            gs.selStart = gs.inputField.selectionStart;
            gs.selEnd = gs.inputField.selectionEnd;
          }

          gs.previousSelection = null;
          var sel = mgBuiltInFunctions.mgGetSelection();

          if (sel && sel.rangeCount > 0)
            gs.previousSelection = sel.getRangeAt(0);

          gs.gestureTimeout = setTimeout("mgGestureRecognizer.endGesture(null);", mgPrefs.lmbGestureLimit);
        }
      }
    }
  },

  endGesture : function(e, synth) {
    var gs = mgGestureState;
    var ms = mgCommon.mouseService;
    var mh = mgGestureHelper;

    gs.endEvent = e;
    mgGestureExecute.mgReleaseRocker(e);

    clearTimeout(gs.statusTimeout);
    clearTimeout(gs.gestureTimeout);

    if (e && !gestureInProgress && mgGestureRecognizer.checkPrevent(e))
      return;

    if (gestureInProgress) {
      gestureInProgress = false;

      if (ms)
        ms.stopTrails();

      gs.gestureDone = (gs.gesture.join("") != "") ? true : false;

      if (e == null) {
        if (gs.gestureDone)
          mh.showStatus(null, mgCommon.getString("g.aborted"));
      }
      else if (gs.gestureDone)
        setTimeout(mgGestureExecute.mgFireGesture, 0, gs.gesture.join(""));
    }

    if (mgPrefs["status.isEnabled"])
      gs.statusTimeout = setTimeout(mh.hideStatus, mgPrefs["status.timeout"]);

    if (e && !synth) {
      var n = e.originalTarget;

      if (gs.gestureDone) {
        var nName = n.nodeName.toLowerCase();

        if (nName == "embed" || nName == "object") {
          e.preventDefault();
          e.stopPropagation();
        }
      }
    }

    if (e && !synth && !gs.gestureDone && e.button == 2) {
      gs.allowContext = true;

      if (n.mozgestPluginRape) {
        mh.hideStatus();
        ms.fakeContext();
      }

      //contextmenu on mousedown
      if (mgCommon.appInfo.platform != "Windows") {
        if (mh.mouseInContent(e)) {
          var dwu = e.view.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
                    .getInterface(Components.interfaces.nsIDOMWindowUtils);

          var evt = Components.interfaces.nsIDOMNSEvent;
          var mods = 0;

          if (e.shiftKey)
            mods |= evt.SHIFT_MASK;
          if (e.ctrlKey)
            mods |= evt.CONTROL_MASK;
          if (e.altKey)
            mods |= evt.ALT_MASK;
          if (e.metaKey)
            mods |= evt.META_MASK;

          dwu.sendMouseEvent("contextmenu", e.clientX, e.clientY, 2, 1, mods);
        }
      }
    }
  },

  wheelHandler : function(e) {
    var gs = mgGestureState;

    if (gs.rockerCode.length < 2)
      return;

    var dir = e.detail > 0 ? "+" : "-";

    if (gs.rockerCode && mgGestureHelper.getMapping(gs.rockerCode+dir)[0]) {
      e.preventDefault();
      e.stopPropagation();
      mgGestureExecute.mgFireRocker(gs.rockerCode + dir);

      if (mgCommon.mouseService && mgPrefs.staticWheelRockers)
        mgObserver.mgSetInterval(null, gs.rockerCode + dir);
    }
  }
}

var mgGestureHelper = {
  mouseInContent : function(e) {
    var bx = mgWindowElements.content.boxObject;
    var gs = mgGestureState;

    if (mgWindowType == "messenger") {
      var mBox = document.getElementById("messengerBox");
      var tabC = document.getElementById("tabpanelcontainer");

      if (tabC && tabC.selectedIndex == 0 && mBox && !mBox.collapsed)
        bx = document.getElementById("messagepanebox").boxObject;
    }

    gs.ctLeft = bx.screenX;
    gs.ctTop = bx.screenY;
    gs.ctRight = bx.screenX + bx.width;
    gs.ctBottom = bx.screenY + bx.height;
    gs.ctWidth = bx.width;
    gs.ctHeight = bx.height;

    bx = document.documentElement.boxObject;
    gs.ctx = gs.ctLeft - bx.screenX;
    gs.cty = gs.ctTop - bx.screenY;
    gs.ctb = (bx.screenY + bx.height) - gs.ctBottom;

    if (e.screenX >= gs.ctLeft &&
        e.screenX <= gs.ctRight &&
        e.screenY >= gs.ctTop &&
        e.screenY <= gs.ctBottom)
      return true;
    else
      return false;
  },

  showStatus : function(code, errorMSG) {
    if (mgPrefs["status.isEnabled"]) {
      clearTimeout(mgGestureState.statusTimeout);
      var gs = mgGestureState;
      var sp = mgWindowElements.statusPopup;
      var spText;

      if (typeof errorMSG == "undefined") {
        spText = gs.s["gesture"] + " " + gs.localizedGesture;
        var nameTemp = mgGestureHelper.getMapping(code)[1];

        if (nameTemp)
          spText += " (" + nameTemp + ")";
      }
      else
        spText = errorMSG = (errorMSG) ? errorMSG : " ";

      sp.firstChild.setAttribute("value", spText);
      var state = sp.popupBoxObject.popupState;

      if (state != "open" && state != "showing") {
        var wX = window.screenX +1;
        var wY = window.screenY +1;
        var wCX = window.outerWidth -2;
        var wCY = window.outerHeight -2;

        sp.width = sp.minWidth = sp.maxWidth = (wCX < 500) ? wCX : 500;

        switch(mgPrefs["status.align"]) {
          case 0: //topLeft
            break;
          case 1: //topRight
            wX = wX + wCX - sp.width;
            break;
          case 2: //bottomLeft
            wY = wY + wCY;
            break;
          case 3: //bottomRight
            wX = wX + wCX - sp.width;
            wY = wY + wCY;
            break;
        }

        sp.openPopupAtScreen(wX, wY, false);
      }

      if (errorMSG)
        gs.statusTimeout = setTimeout("mgGestureHelper.hideStatus();", mgPrefs["status.timeout"]);
    }
  },

  hideStatus : function() {
    if (mgPrefs["status.isEnabled"] && document.getElementById("mozgestStatusPopup"))
      mgWindowElements.statusPopup.hidePopup();
  },

  getMapping : function(code) {
    var aM = _mgMS.activeMappings;
    var mapping = false;
    var name = false;

    if (code in aM[mgWindowType]) {
      mapping = aM[mgWindowType][code];
      name = decodeURIComponent(mapping.name);
    }

    return [mapping, name];
  },

  urlCheck : function(aURL, aPrincipal, aFlags) {
    const nsIScriptSecurityManager = Components.interfaces.nsIScriptSecurityManager;
    var secMan = Components.classes["@mozilla.org/scriptsecuritymanager;1"]
                 .getService(nsIScriptSecurityManager);

    if (aFlags === undefined)
      aFlags = nsIScriptSecurityManager.STANDARD;

    try {
      secMan.checkLoadURIStrWithPrincipal(aPrincipal, aURL, aFlags);
      return true;
    }
    catch (err) {
      return false;
    }
  }
}
