// ***** BEGIN LICENSE BLOCK *****
// Version: MPL 1.1/GPL 2.0/LGPL 2.1
//
// The contents of this file are subject to the Mozilla Public License Version
// 1.1 (the "License"); you may not use this file except in compliance with
// the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// The Original Code is mozilla.org code.
//
// The Initial Developer of the Original Code is
// the Mozilla Organization.
// Portions created by the Initial Developer are Copyright (C) 1998-2002
// the Initial Developer. All Rights Reserved.
//
// Contributor(s):
//   Robert Kaiser <KaiRo@KaiRo.at>
//   Nagarjuna Venna (vnagarjuna@yahoo.com)
//
// Alternatively, the contents of this file may be used under the terms of
// either the GNU General Public License Version 2 or later (the "GPL"), or
// the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
// in which case the provisions of the GPL or the LGPL are applicable instead
// of those above. If you wish to allow use of your version of this file only
// under the terms of either the GPL or the LGPL, and not to allow others to
// use your version of this file under the terms of the MPL, indicate your
// decision by deleting the provisions above and replace them with the notice
// and other provisions required by the GPL or the LGPL. If you do not delete
// the provisions above, a recipient may use your version of this file under
// the terms of any one of the MPL, the GPL or the LGPL.
//
// ***** END LICENSE BLOCK *****


// --- strings specific to that single Language Pack ---
var prettyName = "Traduction fran\u00e7aise";
var langcode = "fr";
var regioncode = "FR";
var version = "1.7";
// --- end pack-specific strings ---


// this function verifies disk space in kilobytes
function verifyDiskSpace(dirPath, spaceRequired) {
  var spaceAvailable;

  // Get the available disk space on the given path
  spaceAvailable = fileGetDiskSpaceAvailable(dirPath);

  // Convert the available disk space into kilobytes
  spaceAvailable = parseInt(spaceAvailable / 1024);

  // do the verification
  if(spaceAvailable < spaceRequired) {
    logComment("Insufficient disk space: " + dirPath);
    logComment("  required : " + spaceRequired + " K");
    logComment("  available: " + spaceAvailable + " K");
    return(false);
  }

  return(true);
}

// this function converts an error number to the error code
function ErrCode(errornum)
{
    if (errornum == 0)  {
        errorstring = "SUCCESS";
    }
    else if (errornum == -200)  {
        errorstring = "BAD_PACKAGE_NAME";
    }
    else if (errornum == -201) {
        errorstring = "UNEXPECTED_ERROR";
    }
    else if (errornum == -202) {
        errorstring = "ACCESS_DENIED";
    }
    else if (errornum == -203) {
        errorstring = "TOO_MANY_CERTIFICATES";
    }
    else if (errornum == -204) {
        errorstring = "NO_INSTALL_SCRIPT";
    }
    else if (errornum == -205) {
        errorstring = "NO_CERTIFICATE";
    }
    else if (errornum == -206) {
        errorstring = "NO_MATCHING_CERTIFICATE";
    }
    else if (errornum == -207) {
        errorstring = "CANT_READ_ARCHIVE";
    }
    else if (errornum == -208) {
        errorstring = "INVALID_ARGUMENTS";
    }
    else if (errornum == -209) {
        errorstring = "ILLEGAL_RELATIVE_PATH";
    }
    else if (errornum == -210) {
        errorstring = "USER_CANCELLED";
    }
    else if (errornum == -211) {
        errorstring = "INSTALL_NOT_STARTED";
    }
    else if (errornum == -212) {
        errorstring = "SILENT_MODE_DENIED";
    }
    else if (errornum == -213) {
        errorstring = "NO_SUCH_COMPONENT";
    }
    else if (errornum == -214) {
        errorstring = "DOES_NOT_EXIST";
    }
    else if (errornum == -215) {
        errorstring = "READ_ONLY";
    }
    else if (errornum == -216) {
        errorstring = "IS_DIRECTORY";
    }
    else if (errornum == -217) {
        errorstring = "NETWORK_FILE_IS_IN_USE";
    }
    else if (errornum == -218) {
        errorstring = "APPLE_SINGLE_ERR";
    }
    else if (errornum == -219) {
        errorstring = "INVALID_PATH_ERR";
    }
    else if (errornum == -220) {
        errorstring = "PATCH_BAD_DIFF";
    }
    else if (errornum == -221) {
        errorstring = "PATCH_BAD_CHECKSUM_TARGET";
    }
    else if (errornum == -222) {
        errorstring = "PATCH_BAD_CHECKSUM_RESULT";
    }
    else if (errornum == -223) {
        errorstring = "UNINSTALL_FAILED";
    }
    else if (errornum == -224) {
        errorstring = "PACKAGE_FOLDER_NOT_SET";
    }
    else if (errornum == -225) {
        errorstring = "EXTRACTION_FAILED";
    }
    else if (errornum == -226) {
        errorstring = "FILENAME_ALREADY_USED";
    }
    else if (errornum == -227) {
        errorstring = "INSTALL_CANCELLED";
    }
    else if (errornum == -228) {
        errorstring = "DOWNLOAD_ERROR";
    }
    else if (errornum == -229) {
        errorstring = "SCRIPT_ERROR";
    }
    else if (errornum == -230) {
        errorstring = "ALREADY_EXISTS";
    }
    else if (errornum == -231) {
        errorstring = "IS_FILE";
    }
    else if (errornum == -232) {
        errorstring = "SOURCE_DOES_NOT_EXIST";
    }
    else if (errornum == -233) {
        errorstring = "SOURCE_IS_DIRECTORY";
    }
    else if (errornum == -234) {
        errorstring = "SOURCE_IS_FILE";
    }
    else if (errornum == -235) {
        errorstring = "INSUFFICIENT_DISK_SPACE";
    }
    else if (errornum == -236) {
        errorstring = "FILENAME_TOO_LONG";
    }
    else if (errornum == -237) {
        errorstring = "UNABLE_TO_LOCATE_LIB_FUNCTION";
    }
    else if (errornum == -238) {
        errorstring = "UNABLE_TO_LOAD_LIBRARY";
    }
    else if (errornum == -239) {
        errorstring = "CHROME_REGISTRY_ERROR";
    }
    else if (errornum == -240) {
        errorstring = "MALFORMED_INSTALL";
    }
    else if (errornum == -299) {
        errorstring = "OUT_OF_MEMORY";
    }
    else if (errornum == 999) {
        errorstring = "REBOOT_NEEDED";
    }
    else if (errornum == -5550) {
        errorstring = "GESTALT_UNKNOWN_ERROR";
    }
    else if (errornum == -5551) {
        errorstring = "GESTALT_INVALID_ARGUMENT";
    }
    else {
        errorstring = "Error No. " + errornum;
    }

    return(errorstring);
}

// this function converts an error number to a string with code and number
//function ErrWithCode(errornum)
//{
//  return(err + " (" + ErrCode(err) + ")");
//}

// OS type detection - which platform?
function getPlatform() {
  var platformStr;
  var platformNode;

  if('platform' in Install) {
    platformStr = new String(Install.platform);

    if (!platformStr.search(/^Macintosh/))
      platformNode = 'mac';
    else if (!platformStr.search(/^Win/))
      platformNode = 'win';
    else
      platformNode = 'unix';
  }
  else {
    var fOSMac  = getFolder("Mac System");
    var fOSWin  = getFolder("Win System");

    logComment("fOSMac: "  + fOSMac);
    logComment("fOSWin: "  + fOSWin);

    if(fOSMac != null)
      platformNode = 'mac';
    else if(fOSWin != null)
      platformNode = 'win';
    else
      platformNode = 'unix';
  }

  return platformNode;
}

// *** start main install routine ***

var srDest = 600;
var err;
var fProgram;
var platformNode;
var profileInstall = 0;
var alertstring;

platformNode = getPlatform();
logComment("language pack installation: platform type detected as: " + platformNode);

var chromeNode = langcode + "-" + regioncode;
//var regionFile = regioncode + ".jar";
var regName    = "locales/mozilla/" + chromeNode;
var chromeName = chromeNode + "-mail.jar";

var platformName = langcode + "-" + platformNode + ".jar";
var localeName = "locale/" + langcode + "-" + regioncode + "/";
var regionName = "locale/" + regioncode + "/";

err = initInstall(prettyName, regName, version); 
logComment("initInstall: " + ErrCode(err));

var messages = loadResources("install.properties");

fProgram = getFolder("Program");
logComment("fProgram: " + fProgram);

if ((err == 0) && verifyDiskSpace(fProgram, srDest)) {
  var chromeType = LOCALE;
  var tellRestart = 0;
// well, just try to do it right (tm) on unix as well for Mozilla 1.3 !!!  
//  if (platformNode == 'unix') {
    // DELAYED_CHROME is still needed on many unix systems for bug 109044; this needs a Mozilla restart!
//    logComment("detected a unix system: using DELAYED_CHROME for registerChrome because of bug 109044");
//    chromeType |= DELAYED_CHROME;
//    tellRestart = 1;
//  }
  err = addDirectory("", "chrome", fProgram, "chrome");
  logComment("addDirectory() for chrome returned: " + ErrCode(err));
  err = addDirectory("", "defaults", fProgram, "defaults");
  logComment("addDirectory() for defaults returned: " + ErrCode(err));
  //err = addDirectory("", "components", fProgram, "components");
  //logComment("addDirectory() for defaults returned: " + ErrCode(err));

  if (err != 0) {
    // return value 0 is SUCCESS
    logComment("addDirectory() to " + fProgram + "failed!");
 
// well, just try to do it right (tm) on unix as well for Mozilla 1.3 !!!  
//    if (platformNode != 'unix') {
      // couldn't install globally, try installing to the profile (does only install chrome part, no defaults, no searchplugins)
      // does not work with DELAYED_CHROME !!! (see comment above - bug 109044)
      resetError();
      chromeType |= PROFILE_CHROME;
      profileInstall = 1;
      fProgram = getFolder("Profile");
      logComment("try installing to the user profile:" + fProgram);
      err = addDirectory("", "chrome", fProgram, "chrome");
      logComment("addDirectory() for profile chrome returned: " + ErrCode(err));
//    }
//    else {
//      logComment("sorry, can't use user profile on unix systems due to bug 109044");
//    }
  }
 
  setPackageFolder(fProgram);
 
  // check return value: 0 is SUCCESS, 999 is REBOOT_NEEDED
  if ((err == 0) || (err == 999)) {
    var tellReboot = 0;
    if (err == 999) {
      tellReboot = 1;
      resetError();
    }
    // register chrome
    var cf = getFolder(fProgram, "chrome/"+chromeName);
    var pf = getFolder(fProgram, "chrome/"+platformName);
    //var rf = getFolder(fProgram, "chrome/"+regionFile);


      registerChrome(chromeType, cf, "locale/necko/");
      registerChrome(chromeType, cf, localeName + "communicator/");
      registerChrome(chromeType, cf, localeName + "navigator/");
      registerChrome(chromeType, cf, "locale/global/");
      registerChrome(chromeType, cf, "locale/pipnss/");
      registerChrome(chromeType, cf, "locale/pippki/");
      registerChrome(chromeType, cf, localeName + "editor/");
      registerChrome(chromeType, cf, localeName + "mozldap/");
      registerChrome(chromeType, cf, localeName + "navigator/");
      registerChrome(chromeType, cf, "locale/mozapps/");
      registerChrome(chromeType, cf, localeName + "messenger/");
      registerChrome(chromeType, cf, localeName + "messenger-smime/");
      registerChrome(chromeType, cf, localeName + "messenger-offline/");
      registerChrome(chromeType, cf, localeName + "messenger-newsblog/");
      registerChrome(chromeType, cf, localeName + "messenger-mapi/");
      //      registerChrome(chromeType, cf, localeName + "inspector/");
      registerChrome(chromeType, cf, regionName + "messenger-region/");
      registerChrome(chromeType, cf, "locale/global-region/");
      registerChrome(chromeType, cf, "locale/global-platform/");

      //registerChrome(chromeType, rf, regionName + "navigator-region/");
      //registerChrome(chromeType, rf, regionName + "messenger-region/");
      //registerChrome(chromeType, rf, regionName + "communicator-region/");
      //registerChrome(chromeType, rf, regionName + "global-region/");
      //registerChrome(chromeType, rf, regionName + "editor-region/");
      

      registerChrome(chromeType, pf, localeName + "navigator-platform/");
      //      registerChrome(chromeType, pf, localeName + "global-platform/");
      registerChrome(chromeType, pf, localeName + "communicator-platform/");

      //      if (platformNode == 'win') {
      //	registerChrome(chromeType, pf, localeName + "messenger-mapi/");
      //      }


      err = performInstall(); 
      logComment("performInstall() returned: " + ErrCode(err));
      if (err == 999) {
	tellReboot = 1;
	resetError(); err = 0;
      }
      if (err == 0) {
	if (profileInstall == 1) {
	  alertstring = "Installation r\u00e9ussie dans le r\u00e9pertoire de profil. L'extension sera disponible uniquement pour le profil courant.";
	}
	else {
	  alertstring = "Installation globale r\u00e9ussie. L'extension sera disponible pour tous les profils.";
	}
	if (tellReboot == 1) {
	  alertstring = alertstring + "\n\n Vous devez red\u00e9marrer votre syst\u00e8me avant de pouvoir changer de langue.";
	  logComment("REBOOT_NEEDED (999): warning user that he needs to reboot his system.");
	  cancelInstall(REBOOT_NEEDED);
	}
	else {
	  if (tellRestart == 1) {
	    alertstring = alertstring + "\n\n Vous devez red\u00e9marrer Thunderbird pour prendre en compte la langue fran\u00e7aise.";
	    logComment("we were using DELAYED_CHROME: warning user that he needs to restart Mozilla.");
	  }
	}
	alertstring = alertstring + "\n\n Pour basculer sur la nouvelle langue, veuillez lancer Thunderbird avec les options :\n\u00ab -contentLocale FR -UILocale fr-FR \u00bb.";
      }
      else {
	alertstring = "L'installation a \u00e9chou\u00e9e. Le code d'erreur est " + ErrCode(err) + ".";
	cancelInstall(err);
      }
  } else {
    cancelInstall(err);
    logComment("cancelInstall due to error: " + ErrCode(err));
    alertstring = "L'installation a \u00e9t\u00e9 annul\u00e9e. Le code d'erreur est " + ErrCode(err) + ".";
    if ((err == -202) || (err == -215)) {
      // -202 is ACCESS_DENIED, -215 is READ_ONLY
      alertstring = alertstring + "\n\n Vous n'avez visiblement pas les droits en \u00e9criture dans le r\u00e9pertoire 'chrome' de Thunderbird. Essayez d'installer en tant que root / administrateur.";
      if (err == -202) {
        logComment("ACCESS_DENIED (-202): warning user that he probably has no write access to chrome.");
      }
      else {
        logComment("READ_ONLY (-215): warning user that he probably has no write access to chrome.");
      }
    }
  }
  alert(alertstring);
}
else {
  if (err == 0)
    cancelInstall(INSUFFICIENT_DISK_SPACE);
  else
    cancelInstall(err);
}
