/* input_line

   Written by Matthias Hensler
   Copyright WSPse 1999+2000
   eMail: wsp@gmx.de

Created: 1999/06/12
Updated: 2000/03/20
*/

/* Copying:
   This program is free software; you can redistribute it and/or modify it under
   the terms of the GNU Gerneral Public License as published by the Free Soft-
   ware Foundation; either version 2 of License, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILTY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 675 Mass
   Ave, Cambridge, MA 02139, USA.
   */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <ncurses.h>
#include "mp3creat.h"

#ifdef HAVE_CTYPE_H
#include <ctype.h>
#endif

/* Externals */
extern WINDOW *c_newwin(int h, int l, int y, int x, void *proc, int arg1, int arg2);
extern void c_delwin(WINDOW *win);
extern void store_win_poi(WINDOW *win, void *pointer);
extern void *pop_win_poi(WINDOW *win);
extern void wuuush(int);
extern void win_effect(WINDOW *win, BOOL e_refresh, BOOL save_coor);
extern int set_active_win(WINDOW *win);
extern char config_fancy_colors;
extern BOOL eased_char_hand;

/* Globals */
int ib_startpos, ib_curspos;
int ib_len;
char *ib_string;
BOOL ib_cancel;
BOOL ib_changed;
BOOL ib_first;
char *ib_des1 = NULL;
char *ib_des2 = NULL;
char *ib_des3 = NULL;
char *ib_des4 = NULL;
char *ib_des5 = NULL;
char *ib_des6 = NULL;
BOOL ib_destr = FALSE;

/* draw cancel-field (selected or not) */
void ib_setcancel(WINDOW *win, int x, BOOL act)
{
  chtype old_ch;

  old_ch = getbkgd(win);
  if(act) wbkgdset(win, COLOR_PAIR(4) | A_BOLD);
  else    wbkgdset(win, COLOR_PAIR(1));
  mvwaddstr(win, 3, x, _(" Cancel "));
  wbkgdset(win, old_ch);

  if(act) curs_set(0);
  else    curs_set(1);
}

/* output textstring in box */
void ib_text(WINDOW *win, int maxx)
{
  chtype old_ch=0;
  
  wmove(win, 1, 1);
  whline(win, ' ', maxx-2);
  if(ib_first && (!ib_cancel)) {
    old_ch = getbkgd(win);
    wbkgdset(win, old_ch | A_REVERSE);
  }
  waddnstr(win, (ib_string + ib_startpos), maxx-2);
  if(ib_first && (!ib_cancel)) wbkgdset(win, old_ch);
}

/* draw box, or rebuild it (on resize/refresh) */
void ib_refresh(WINDOW *win, int arg1, int arg2)
{
  int maxy, maxx;
  BOOL refr;
  char *usage;
  chtype old_ch;
  int inp_ch;

  usage = pop_win_poi(win);
  getmaxyx(stdscr, maxy, maxx);
  refr = FALSE;    /* need to resize window? */

  while(ib_curspos > (maxx-2)) {
    ib_curspos  -= (maxx>>1);
    ib_startpos += (maxx>>1);
    refr         = TRUE;
  }

  while((ib_startpos > 0) && (ib_curspos < (maxx>>1))) {
    ib_curspos  += (maxx>>1);
    ib_startpos -= (maxx>>1);
  }
  if(ib_startpos < 0) {
    ib_curspos += ib_startpos;
    ib_startpos = 0;
  }

  if(arg2 != maxx) refr = TRUE;
  if(ib_destr) {
    if(arg1 > (maxy - 11)) {
      refr = TRUE;
      mvwin(win, maxy-12, 0);
    }
  } else {
    if(arg1 > (maxy - 4)) {
      refr = TRUE;
      mvwin(win, maxy-5, 0);
    }
  }
  if(refr) {
    wresize(win, 5, maxx);
    ib_changed = TRUE;
  }
  
  wclear(win);
  box(win,0,0);
  mvwaddch(win, 2, 0, ACS_LTEE);
  whline(win, ACS_HLINE, maxx-2);
  mvwaddch(win, 2, maxx-1, ACS_RTEE);

  if(ib_destr) {
    mvwaddch(win, 4, 0, ACS_LTEE);
    whline(win, ACS_HLINE, maxx-2);
    mvwaddch(win, 4, maxx-1, ACS_RTEE);

    if(ib_des1) mvwaddnstr(win, 5,  1, ib_des1, maxx-1);
    if(ib_des2) mvwaddnstr(win, 6,  1, ib_des2, maxx-1);
    if(ib_des3) mvwaddnstr(win, 7,  1, ib_des3, maxx-1);
    if(ib_des4) mvwaddnstr(win, 8,  1, ib_des4, maxx-1);
    if(ib_des5) mvwaddnstr(win, 9,  1, ib_des5, maxx-1);
    if(ib_des6) mvwaddnstr(win, 10, 1, ib_des6, maxx-1);
  }

  if(usage) {
    old_ch = getbkgd(win);
    wbkgdset(win, COLOR_PAIR(2) | A_BOLD);
    inp_ch = maxx - strlen(usage);
    if(inp_ch < 2) inp_ch = 2;
    mvwaddnstr(win, 0, inp_ch>>1, usage, maxx-2);
    wbkgdset(win, old_ch);
  }

  ib_setcancel(win, (maxx-strlen(_(" Cancel ")))>>1, ib_cancel);
  ib_text(win, maxx);
  wmove(win, 1, ib_curspos+1);
  wrefresh(win);
}

/* move cursor to left */
void ib_handle_left(WINDOW *win, int maxx)
{
  BOOL refresh;
  
  if(ib_cancel) return;

  refresh = FALSE;
  if(ib_startpos + ib_curspos > 0) {
    if(ib_curspos == 0) {
      ib_startpos--;
      refresh = TRUE;
    } else ib_curspos--;
    while((ib_startpos > 0) && (ib_curspos < 10)) {
      ib_curspos  += (maxx>>1);
      ib_startpos -= (maxx>>1);
      refresh = TRUE;
    }
    if(ib_startpos < 0) {
      ib_curspos += ib_startpos;
      ib_startpos = 0;
    }
    if(refresh) ib_text(win, maxx);
    wmove(win, 1, ib_curspos+1);
  }
}

/* move cursor right */
void ib_handle_right(WINDOW *win, int maxx)
{
  BOOL refresh;
  
  if(ib_cancel) return;

  refresh = FALSE;
  if(*(ib_string + ib_startpos + ib_curspos) != 0) {
    if(ib_curspos == maxx-2) {
      ib_startpos++;
      refresh = TRUE;
    } else ib_curspos++;
    if(ib_curspos > maxx-10) {
      refresh = TRUE;
      ib_startpos += (maxx>>1);
      ib_curspos  -= (maxx>>1);
    }
    if(refresh) ib_text(win, maxx);
    wmove(win, 1, ib_curspos+1);
  }
}

/* delete char */
void ib_handle_del(WINDOW *win, int maxx)
{
  if(ib_startpos + ib_curspos == 0) return;

  memmove((ib_string + ib_startpos + ib_curspos - 1),
	  (ib_string + ib_startpos + ib_curspos),
	  (ib_len - (ib_startpos + ib_curspos)));
  ib_text(win, maxx);
  ib_handle_left(win, maxx);
  wrefresh(win);
}

/* insert char */
void ib_handle_insert(WINDOW *win, int maxx, int key)
{
  if(strlen(ib_string) < ib_len) {
    ib_len += 16;
    ib_string = (char *) realloc(ib_string, sizeof(char) * ib_len);
    if(ib_string == NULL) {
      perror("realloc");
      wuuush(1);
    }
  }
  *(ib_string + strlen(ib_string) + 1) = 0;
  memmove((ib_string + ib_startpos + ib_curspos + 1),
	  (ib_string + ib_startpos + ib_curspos),
	  strlen(ib_string + ib_startpos + ib_curspos));
  *(ib_string + ib_startpos + ib_curspos) = (char) key;
  ib_text(win, maxx);
  ib_handle_right(win, maxx);
  wrefresh(win);
}

/* handle mask of field */
void ib_handle_first(WINDOW *win, int maxx)
{
  if((! ib_first) || ib_cancel) return;
  ib_first = FALSE;
  ib_text(win, maxx);
  wmove(win, 1, ib_curspos+1);
  wrefresh(win);
}
void ib_handle_first2(WINDOW *win, int maxx)
{
  if((! ib_first) || ib_cancel) return;
  ib_first = FALSE;
  *ib_string  = 0;
  ib_startpos = 0;
  ib_curspos  = 0;
  ib_text(win, maxx);
  wmove(win, 1, 1);
  wrefresh(win);
}

/* inputbox (for one line)
   return value = pointer to new allocated string with inputtext
   arguments:
   -int    = height of inputline
   -char * = default inputstring
   -char * = description string for inputbox
   -BOOL   = select default string
 */
char *input_line(int y_line, char *def_str, char *usage_str, BOOL select)
{
  int maxy, maxx;
  WINDOW *ib_win;
  int inp_ch;
  char *ret_str;

  getmaxyx(stdscr, maxy, maxx);
  if(ib_destr) {
    if((y_line < 1) || (y_line > (maxy-13))) y_line = maxy-12;
    ib_win = c_newwin(12, maxx, y_line-1, 0, ib_refresh, y_line, maxx);
  } else {
    if((y_line < 1) || (y_line > (maxy-6))) y_line = maxy-5;
    ib_win = c_newwin(5, maxx, y_line-1, 0, ib_refresh, y_line, maxx);
  }
  ib_changed  = FALSE;
  wbkgd(ib_win, COLOR_PAIR(1) | A_BOLD);
  store_win_poi(ib_win, usage_str);
  ib_cancel = FALSE;
  ib_first  = select;

  if(def_str) ib_string = (char *) malloc(sizeof(char) * (strlen(def_str)+1));
  else        ib_string = (char *) malloc(sizeof(char));
  if(ib_string == NULL) {
    perror("malloc");
    wuuush(1);
  }
  if(def_str) {
    memcpy(ib_string, def_str, strlen(def_str)+1);
    ib_len = strlen(def_str)+1;
    ib_startpos = 0;
    ib_curspos  = strlen(def_str);
    while(ib_curspos >= maxx-2) {
      ib_startpos += (maxx>>1);
      ib_curspos  -= (maxx>>1);
    }
  } else {
    *ib_string  = 0;
    ib_startpos = 0;
    ib_curspos  = 0;
    ib_len      = 1;
  }
  ib_refresh(ib_win, y_line, maxx);

  cbreak();
  noecho();
  keypad(ib_win, TRUE);
  if(config_fancy_colors)
    halfdelay(1);
  else
    nodelay(ib_win, FALSE);
  
  while(1) {
    inp_ch = wgetch(ib_win);
    if(ib_changed) {
      getmaxyx(ib_win, maxy, maxx);
      ib_changed = FALSE;
    }
    if(config_fancy_colors) {
      win_effect(ib_win, TRUE, FALSE);
      wmove(ib_win, 1, ib_curspos+1);
    }
    if(ib_cancel && (inp_ch == ' ' || inp_ch == 'q' || inp_ch == 'Q')) {
      c_delwin(ib_win);
      curs_set(0);
      free(ib_string);
      return NULL;
    }
    switch(inp_ch) {
      case '\t':
	if(ib_cancel) ib_cancel = FALSE;
	else          ib_cancel = TRUE;
	ib_setcancel(ib_win, (maxx-8)>>1, ib_cancel);
	ib_text(ib_win, maxx);
	break;
      case KEY_ENTER:
      case '\n':
      case '\r':
	c_delwin(ib_win);
	curs_set(0);
	if(ib_cancel) {
	  free(ib_string);
	  return NULL;
	}
	ret_str = (char *) malloc(sizeof(char) * (strlen(ib_string)+1));
	if(ret_str == NULL) {
	  perror("malloc");
	  wuuush(1);
	}
	memcpy(ret_str, ib_string, strlen(ib_string)+1);
	free(ib_string);
	return ret_str;
	break;
      case 27:
	c_delwin(ib_win);
	curs_set(0);
	free(ib_string);
	return NULL;
	break;
      case KEY_LEFT:
	ib_handle_first(ib_win, maxx);
	ib_handle_left(ib_win, maxx);
	break;
      case KEY_RIGHT:
	ib_handle_first(ib_win, maxx);
	ib_handle_right(ib_win, maxx);
	break;
      case KEY_BACKSPACE:
      case MP3C_BACKSPACE:
      case 127:
	ib_handle_first2(ib_win, maxx);
	ib_handle_del(ib_win, maxx);
	break;
      case KEY_DC:
	if(*(ib_string + ib_startpos + ib_curspos) != 0) {
	  ib_handle_right(ib_win, maxx);
	  ib_handle_del(ib_win, maxx);
	}
	break;
      case KEY_HOME:
      case 362:
	ib_handle_first(ib_win, maxx);
	if(ib_startpos || ib_curspos) {
	  if(ib_startpos == 0) {
	    ib_curspos = 0;
	    wmove(ib_win, 1, 1);
	  } else {
	    ib_curspos  = 0;
	    ib_startpos = 0;
	    ib_text(ib_win, maxx);
	    wmove(ib_win, 1, 1);
	  }
	}
	break;
      case KEY_END:
      case 385:
	ib_handle_first(ib_win, maxx);
	if(*(ib_string + ib_startpos + ib_curspos) != 0) {
	  ib_curspos  = strlen(ib_string);
	  ib_startpos = 0;
	  while(ib_curspos >= maxx-2) {
    	    ib_startpos += (maxx>>1);
	    ib_curspos  -= (maxx>>1);
	  }
	  ib_text(ib_win, maxx);
	  wmove(ib_win, 1, ib_curspos+1);
	}
	break;
      case '':
	set_active_win(ib_win);
	break;
      default:
	inp_ch &= 255;
	if(inp_ch == 0x7f) inp_ch = '_';
	if((isprint(inp_ch)) || (eased_char_hand && (inp_ch > 32) && (inp_ch < 256))) {
	  ib_handle_first2(ib_win, maxx);
	  ib_handle_insert(ib_win, maxx, inp_ch);
	}
	break;
    }
  } 
}

char *input_line2(int y_line, char *def_str, char *usage_str,
		  char *des1, char *des2, char *des3, char *des4,
		  char *des5, char *des6, BOOL select)
{
  char *ret;
  
  ib_des1 = des1;
  ib_des2 = des2;
  ib_des3 = des3;
  ib_des4 = des4;
  ib_des5 = des5;
  ib_des6 = des6;

  ib_destr = TRUE;
  
  ret = input_line(y_line, def_str, usage_str, select);

  ib_des1 = NULL;
  ib_des2 = NULL;
  ib_des3 = NULL;
  ib_des4 = NULL;
  ib_des5 = NULL;
  ib_des6 = NULL;

  ib_destr = FALSE;
  
  return ret;
}

