/***************************************************************************
                          preferences.cpp  -  description
                             -------------------
    begin                : Fri Feb 23 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "preferences.h"
#include "resources.h"

#include <qlabel.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qfont.h>
#include <qvbox.h>
#include <qvaluelist.h>
#include <qtooltip.h>

#include <klocale.h>
#include <kconfig.h>
#include <kiconloader.h>
#include <kapp.h>
#include <kfiledialog.h>
#include <iostream.h>

static const char *file_type[] = {
     "None",
     "Artist - Title.mp3",
     "Title - Artist.mp3",
     "Title (Artist).mp3",
     "Title - Album.mp3",
     "Artist - Album - Title.mp3",
     "Artist - Title - Album.mp3",
     NULL };



Preferences::Preferences(QWidget *parent, const char *name) :KDialogBase( IconList, i18n("Configure"), Default|User1|Ok|Cancel,
		Ok, parent, name, true, true, i18n("Save") )
{
     initGeneral();
     cerr << "initGeneral" << endl;
     initMp3Options();
     cerr << "initMp3Option" << endl;
     initFontOptions();
     cerr << "init Font" << endl;
     initExportOptions();
     cerr << "initExport" << endl;
     initViewOptions();
     cerr << "initView" << endl;

     setOptions();
		 cerr << "setOptions" << endl;
     modified=false;

     connect(this, SIGNAL(user1Clicked()), this, SLOT(slotSave()));
     connect(this, SIGNAL(okClicked()), this, SLOT(slotOk()));
     connect(this, SIGNAL(cancelClicked()), this, SLOT(slotCancel()));

     resize (490, 330);
}

Preferences::~Preferences()
{
}

void Preferences::initGeneral ()
{

QFrame *page = addPage(i18n("General"), i18n("General Options"),
               BarIcon("configure", KIcon::SizeMedium ) );

QGridLayout* layout= new QGridLayout ( page, 2, 1, 15, 15);

/*Options Group for Add Volume*/

QGroupBox* groupvol = new QGroupBox (page);
groupvol->setTitle(i18n("Add Volume Options"));
layout->addWidget (groupvol,0,0);

QGridLayout* groupvolL = new QGridLayout ( groupvol, 2, 2, 20, 20);

recursiveVol = new QCheckBox (groupvol);
recursiveVol->setText(i18n("Recursive"));
groupvolL->addWidget ( recursiveVol, 0, 0);

/* Options Group for Add Cd-Rom*/

QGroupBox* groupcd = new QGroupBox (page);
groupcd->setTitle(i18n("Add Cd-Rom Options"));

layout->addWidget(groupcd, 1,0);

QGridLayout* groupcdL = new QGridLayout (groupcd, 2, 3, 20, 20);

QLabel* lcdpath = new QLabel (i18n("Cd-Rom Path"), groupcd);
groupcdL->addWidget ( lcdpath, 1, 0);

cdpath = new QLineEdit (groupcd);
groupcdL->addMultiCellWidget(cdpath, 1, 1, 1, 2);

eject = new QCheckBox (groupcd);
eject->setText(i18n("Eject"));
groupcdL->addWidget(eject,0,0);

recursiveCd = new QCheckBox (groupcd);
recursiveCd->setText(i18n("Recursive"));
groupcdL->addWidget(recursiveCd,0, 2);


}

void Preferences::initFontOptions()
{
     QVBox *page = addVBoxPage(i18n("Font"), i18n("Font List"),
               BarIcon("fonts", KIcon::SizeMedium ) );

     QString txt=i18n("Font");
     mFont = new KFontChooser( page,txt,false,QStringList(),false,6 );
     mFont->setSampleText( i18n("Guns n' Roses - November Rain") );
}

void Preferences::initMp3Options()
{
QFrame *page = addPage(i18n("Mp3"), i18n("Mp3 Options"),
               BarIcon("multimedia", KIcon::SizeMedium ) );

QGridLayout* layout = new QGridLayout(page, 3, 1, 20, 15);

groupWriteTag = new QButtonGroup(3, Horizontal, page);
groupWriteTag->setTitle(i18n("Write Tag Options"));
layout->addWidget (groupWriteTag,0,0);

idv1 = new QRadioButton(i18n("Id3 V1.1"), groupWriteTag);
groupWriteTag->insert(idv1);

idv2 = new QRadioButton(i18n("Id3 V2.x"), groupWriteTag);
groupWriteTag->insert(idv2);

idv1and2 = new QRadioButton(i18n("Both"), groupWriteTag);
groupWriteTag->insert(idv1and2);

QGroupBox* groupType = new QGroupBox (page);
groupType->setTitle(i18n("Mp3 File Type"));
layout->addWidget (groupType,1,0);

QGridLayout* groupTypeL = new QGridLayout (groupType, 1, 1, 15, 15);
filetype = new QComboBox(groupType);
for(int i=0; file_type[i] != NULL; i++)
     filetype->insertItem(file_type[i], i);

filetype->setFixedWidth(220);
groupTypeL->addWidget(filetype, 0,0, AlignHCenter);

QGroupBox* groupPlayer = new QGroupBox(page);
groupPlayer->setTitle(i18n("Mp3 Player"));
layout->addWidget(groupPlayer,2,0);

QGridLayout* groupPlayerL = new QGridLayout (groupPlayer, 1, 1, 15, 15);
playerExe = new QComboBox(groupPlayer);
     playerExe->insertItem("None", 0);
     playerExe->insertItem("Xmms", 1);
     playerExe->insertItem("GQmpeg", 2);
playerExe->setFixedWidth(220);
groupPlayerL->addWidget(playerExe, 0, 0, AlignHCenter);
/*
QLabel pathl = new QLabel(this);
pathl->setText(i18n("File path (without executable)"));
groupPlayerL->addWidget(pathl, 1,0);

playerPath = new QLineEdit(this);
groupPlayerL->addMultiCellWidget(playerExe, 1, 1, 1, 2);
 */
}

void Preferences::initExportOptions()
{
QFrame *page = addPage(i18n("Export"), i18n("Export Options"),
               BarIcon("html", KIcon::SizeMedium ) );

QGridLayout* layout = new QGridLayout(page, 3, 3, 15, 15);

/*QButtonGroup**/ groupEx = new QButtonGroup(page);
groupEx->setTitle(i18n("Export"));
QGridLayout* groupExL = new QGridLayout (groupEx, 4, 4, 15, 4);

titleEx = new QCheckBox (i18n("Title"), groupEx);
groupEx->insert(titleEx, ID_TITLE);
groupExL->addWidget(titleEx, 0, 0);

artistEx= new QCheckBox (i18n("Artist"), groupEx);
groupEx->insert(artistEx, ID_ARTIST);
groupExL->addWidget(artistEx, 0, 1);

albumEx= new QCheckBox (i18n("Album"), groupEx);
groupEx->insert(albumEx, ID_ALBUM);
groupExL->addWidget(albumEx, 0, 2);

lengthEx= new QCheckBox (i18n("Length"), groupEx);
groupEx->insert(lengthEx, ID_LENGTH);
groupExL->addWidget(lengthEx, 0, 3);

genreEx= new QCheckBox (i18n("Genre"), groupEx);
groupEx->insert(genreEx, ID_GENRE);
groupExL->addWidget(genreEx, 1, 0);

yearEx= new QCheckBox (i18n("Year"), groupEx);
groupEx->insert(yearEx, ID_YEAR);
groupExL->addWidget(yearEx, 1, 1);

trackEx= new QCheckBox (i18n("Track"), groupEx);
groupEx->insert(trackEx, ID_TRACK);
groupExL->addWidget(trackEx, 1, 2);

commentEx= new QCheckBox (i18n("Comment"), groupEx);
groupEx->insert(commentEx, ID_COMMENT);
groupExL->addWidget(commentEx, 1, 3);

volumeEx= new QCheckBox (i18n("Volume"), groupEx);
groupEx->insert(volumeEx, ID_VOLUME);
groupExL->addWidget(volumeEx, 2, 0);

pathEx= new QCheckBox (i18n("Path"), groupEx);
groupEx->insert(pathEx, ID_PATH);
groupExL->addWidget(pathEx, 2, 1 );

nameEx= new QCheckBox (i18n("File"), groupEx);
groupEx->insert(nameEx, ID_FNAME);
groupExL->addWidget(nameEx, 2, 2);

sizeEx= new QCheckBox (i18n("Size"), groupEx);
groupEx->insert(sizeEx, ID_SIZE);
groupExL->addWidget(sizeEx, 2, 3);

modeEx= new QCheckBox (i18n("Mode"), groupEx);
groupEx->insert(modeEx, ID_MODE);
groupExL->addWidget(modeEx, 3, 0);

bitrateEx= new QCheckBox (i18n("Kbit/s"), groupEx);
groupEx->insert(bitrateEx, ID_BIT);
groupExL->addWidget(bitrateEx, 3, 1);

sampleEx= new QCheckBox (i18n("KHz"), groupEx);
groupEx->insert(sampleEx, ID_SAMPLE);
groupExL->addWidget(sampleEx, 3, 2);

// cerr << "ID: " << groupEx->id(titleEx) << " " << groupEx->id(artistEx) << endl;

layout->addMultiCellWidget (groupEx, 0,0, 0,2);

createLinkEx = new QCheckBox (i18n("Create Links to Files"), page);
layout->addMultiCellWidget(createLinkEx, 1, 1, 0, 1);

useTemplateEx = new QRadioButton (i18n("Use Template"), page);
layout->addWidget(useTemplateEx, 2, 0);
QToolTip::add(useTemplateEx,i18n("Is a Html file that contains \n"
                                 "this Html Tag: <!-- Mp3Kult -->\n"
                                 "in a new line"));

templatePathEx = new QLineEdit (page);
layout->addWidget(templatePathEx, 2, 1);

butTempDialEx = new QPushButton (page, "Dir..." );
     butTempDialEx->setText ("...");
     butTempDialEx->setMaximumWidth (30);
     layout->addWidget (butTempDialEx, 2,2);

connect (butTempDialEx, SIGNAL (clicked()), this, SLOT (slotButTempDialEx()));
connect (useTemplateEx, SIGNAL (toggled(bool)), templatePathEx, SLOT(setEnabled(bool)));
connect (useTemplateEx, SIGNAL (toggled(bool)), butTempDialEx, SLOT(setEnabled(bool)));
}

void Preferences::initViewOptions()
{
QFrame *page = addPage(i18n("View"), i18n("View Options"),
               BarIcon("text_block", KIcon::SizeMedium ) );

QGridLayout* layout = new QGridLayout(page, 1, 1, 15, 15);

groupView = new QButtonGroup(page);
groupView->setTitle(i18n("View columns"));
QGridLayout* groupViewL = new QGridLayout (groupView, 4, 4, 15, 4);

titleView = new QCheckBox (i18n("Title"), groupView);
groupView->insert(titleView, ID_TITLE);
//titleView->setChecked(true);
groupViewL->addWidget(titleView, 0, 0);

artistView= new QCheckBox (i18n("Artist"), groupView);
groupView->insert(artistView, ID_ARTIST);
//artistView->setChecked(true);
groupViewL->addWidget(artistView, 0, 1);

albumView= new QCheckBox (i18n("Album"), groupView);
groupView->insert(albumView, ID_ALBUM);
//albumView->setChecked(true);
groupViewL->addWidget(albumView, 0, 2);

lengthView= new QCheckBox (i18n("Length"), groupView);
groupView->insert(lengthView, ID_LENGTH);
//lengthView->setChecked(true);
groupViewL->addWidget(lengthView, 0, 3);

genreView= new QCheckBox (i18n("Genre"), groupView);
groupView->insert(genreView, ID_GENRE);
//genreView->setChecked(true);
groupViewL->addWidget(genreView, 1, 0);

yearView= new QCheckBox (i18n("Year"), groupView);
groupView->insert(yearView, ID_YEAR);
//yearView->setChecked(true);
groupViewL->addWidget(yearView, 1, 1);

trackView= new QCheckBox (i18n("Track"), groupView);
groupView->insert(trackView, ID_TRACK);
groupViewL->addWidget(trackView, 1, 2);

commentView= new QCheckBox (i18n("Comment"), groupView);
groupView->insert(commentView, ID_COMMENT);
//commentView->setChecked(true);
groupViewL->addWidget(commentView, 1, 3);

volumeView= new QCheckBox (i18n("Volume"), groupView);
groupView->insert(volumeView, ID_VOLUME);
//volumeView->setChecked(true);
groupViewL->addWidget(volumeView, 2, 0);

pathView= new QCheckBox (i18n("Path"), groupView);
groupView->insert(pathView, ID_PATH);
//pathView->setChecked(true);
groupViewL->addWidget(pathView, 2, 1 );

nameView= new QCheckBox (i18n("File"), groupView);
groupView->insert(nameView, ID_FNAME);
//nameView->setChecked(true);
groupViewL->addWidget(nameView, 2, 2);

sizeView= new QCheckBox (i18n("Size"), groupView);
groupView->insert(sizeView, ID_SIZE);
//sizeView->setChecked(true);
groupViewL->addWidget(sizeView, 2, 3);

modeView= new QCheckBox (i18n("Mode"), groupView);
groupView->insert(modeView, ID_MODE);
//modeView->setChecked(true);
groupViewL->addWidget(modeView, 3, 0);

bitrateView= new QCheckBox (i18n("Kbit/s"), groupView);
groupView->insert(bitrateView, ID_BIT);
//bitrateView->setChecked(true);
groupViewL->addWidget(bitrateView, 3, 1);

sampleView= new QCheckBox (i18n("KHz"), groupView);
groupView->insert(sampleView, ID_SAMPLE);
//sampleView->setChecked(true);
groupViewL->addWidget(sampleView, 3, 2);

layout->addWidget(groupView, 0, 0);
}

void Preferences::setOptions()
{
     KConfig* config;
     QFont font;
     config = kapp->config();

     config->setGroup("OPTIONS");
          cdpath->setText(config->readEntry("Cdpath",""));
          eject->setChecked(config->readBoolEntry("Eject", false));
          recursiveCd->setChecked(config->readBoolEntry("RecursiveCd", true));
          recursiveVol->setChecked(config->readBoolEntry("RecursiveVol", false));
          filetype->setCurrentItem(config->readNumEntry("FileType", 0));
          switch ( config->readNumEntry("WriteTag",2) ) {
            case 0 :  idv1->setChecked(true);
                      break;
            case 1 :  idv2->setChecked(true);
                      break;
            default:  idv1and2->setChecked(true);
                      break;
            }

     config->setGroup("Font");
          font.setFamily(config->readEntry("Family","Helvetica"));
	     font.setPointSize(config->readNumEntry("Size",12));
	     font.setWeight(config->readNumEntry("Weight",50));
	     font.setItalic(config->readBoolEntry("Italic",false));
	     mFont->setFont(font);

     config->setGroup("Player");
          playerExe->setCurrentItem(config->readNumEntry("PlayerExeN", 0));
        /*  playerPath->setCurrentItem(config->readEntry("PlayerPath", "/usr/bin/"));*/

     config->setGroup("Export");
        QValueList<int> lst;
        lst = config->readIntListEntry("ExItem");
        if (!(lst.isEmpty()))
            for (int i=0; i<NUMCOL; i++)
            {
                ((QCheckBox*)groupEx->find(i))->setChecked(lst[i]);
               // cerr << "Setto " << i << ": " << lst[i] << endl;
            }
        else
           for (int i=0; i<NUMCOL; i++)
           {
                ((QCheckBox*)groupEx->find(i))->setChecked(true);
           }
        createLinkEx->setChecked(config->readBoolEntry("CreateLinks", false));
        useTemplateEx->setChecked(config->readBoolEntry("UseTemplate", false));
        templatePathEx->setText(config->readEntry("TempPath", ""));
        if (!(useTemplateEx->isChecked()))
        {
            templatePathEx->setEnabled(false);
            butTempDialEx->setEnabled(false);
        }

        lst.clear();

        config->setGroup("View");
        lst = config->readIntListEntry("ColumnsVis");
        if (!(lst.isEmpty()))
            for (uint i=0; i<lst.count(); i++)
            {
                ((QCheckBox*)groupView->find(i))->setChecked(lst[i]);
              //  cerr << "Setto Hide" << i << ": " << lst[i] << endl;
            }
        else
           for (int i=0; i<NUMCOL; i++)
           {
                ((QCheckBox*)groupView->find(i))->setChecked(true);
           }
}

QString Preferences::getCdPath()
{
     return (cdpath->text());
}

bool Preferences::getEject()
{
     return (eject->isChecked());
}

bool Preferences::getRecursiveVol()
{
     return (recursiveVol->isChecked());
}

bool Preferences::getRecursiveCd()
{
     return (recursiveCd->isChecked());
}

QFont Preferences::getFont(){
	return mFont->font();
}

const QString Preferences::getPlayerExe() const
{
     switch (playerExe->currentItem()) {
          case 0 :
               return "";
          case 1 :
               return "xmms";
          case 2 :
               return "gqmpeg";
          default :
               return "";
     }
     return "";
}

/*const QString Preferences::getPlayerPath() const
{
     return playerPath->text();
} */

void Preferences::slotSave()
{
KConfig* config = kapp->config();

config->setGroup("OPTIONS");
     config->writeEntry("Cdpath", getCdPath());
     config->writeEntry("Eject", getEject());
     config->writeEntry("RecursiveCd", getRecursiveCd());
     config->writeEntry("RecursiveVol", getRecursiveVol());
     config->writeEntry("FileType", filetype->currentItem());
     config->writeEntry("WriteTag", groupWriteTag->id(groupWriteTag->selected()));

config->setGroup("Font");
     config->writeEntry("Family",mFont->font().family());
	config->writeEntry("Size",mFont->font().pointSize());
	config->writeEntry("Weight",mFont->font().weight());
	config->writeEntry("Italic",mFont->font().italic());

config->setGroup("Player");
     config->writeEntry("PlayerExe", getPlayerExe());
     config->writeEntry("PlayerExeN", playerExe->currentItem());
  /*   config->writeEntry("PlayerPath", playerPath->text());*/

config->setGroup("Export");
    QValueList<int> lst;
    for ( int i=0; i<NUMCOL; i++)
    {
        lst.append((((QCheckBox*)groupEx->find(i))->isChecked()));
      //  cerr << "Item " << i << ": " << lst[i] << endl;
    }
    config->writeEntry("ExItem", lst);
    config->writeEntry("CreateLinks",createLinkEx->isChecked());
    config->writeEntry("UseTemplate", useTemplateEx->isChecked());
    config->writeEntry("TempPath", templatePathEx->text());

    lst.clear();
config->setGroup("View");
    for ( int i=0; i<NUMCOL; i++)
    {
        lst.append((((QCheckBox*)groupView->find(i))->isChecked()));
       // cerr << "Item " << i << ": " << lst[i] << endl;
    }
    config->writeEntry("ColumnsVis", lst);

modified=true;
}

void Preferences::slotButTempDialEx()
{
     QString file;
     file = KFileDialog::getOpenFileName(QDir::homeDirPath(),
                                         "*.htm *.html *.Html *.Htm|Html File",
                                         this, i18n("Select Template..."));
     templatePathEx->setText(file);
}

void Preferences::slotEnableTemplate()
{
    if ((useTemplateEx->isChecked()))
    {
        templatePathEx->setEnabled(true);
        butTempDialEx->setEnabled(true);
    }
    else
    {
        templatePathEx->setEnabled(false);
        butTempDialEx->setEnabled(false);
    }
}

void Preferences::slotOk()
{
     slotSave();
     modified=false;
     accept();
}

void Preferences::slotCancel()
{
     if(modified)
     {
          modified=false;
          accept();
     }
     else
          reject();
}

#include "preferences.moc"
