/***************************************************************************
                          utils.cpp  -  description
                             -------------------
    begin                : Wed Aug 22 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "utils.h"

#include <qfileinfo.h>

#include "mp3info.h"
#include "ogginfo.h"

Utils::Utils(){
}

Utils::~Utils(){
}

QString Utils::encryptStr(const QString str)
{
	unsigned int i, val;
  unsigned int len = str.length();
  QCString result;
  result.resize(len+1);

  for (i=0; i<len; i++)
  {
    val = str[i] - ' ';
    val = (255-' ') - val;
    result[i] = (char)(val + ' ');
  }
  result[i] = '\0';

  return result;
}

QString Utils::decryptStr(const QString str)
{
	return encryptStr(str);
}

FileInfo* Utils::createInfo (const char* file/*, FileInfo* info*/)
{
	FileInfo* info;
	QString ext;
	QFileInfo filet(file);

	ext = filet.extension(false);

	if (ext.contains("mp3", false) > 0)
	{
		//FileInfo info(file);
		cerr << "Mp3 !!" << endl;
		info = new Mp3Info(file);
		//fileType = 0;
		return info;
	}
	else if (ext.contains("ogg", false) > 0)
	{
		//Ogg info(file);
		cerr << "Ogg !!" << endl;
		info = new OggInfo(file);
		//fileType = 1;
		return info;
	}
	else
		return NULL;
}
