/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import base.drawable.CoordPixelXform;
import base.drawable.TimeBoundingBox;
import viewer.zoomable.ScrollableObject;

public class CoordPixelImage
implements CoordPixelXform {
    private ScrollableObject img_obj;
    private int row_hgt;
    private int row_half_hgt;
    private TimeBoundingBox img_endtimes;
    private double img_starttime;
    private double img_finaltime;
    private int ipix_start;
    private int ipix_final;
    private int ipix_width;

    public CoordPixelImage(ScrollableObject scrollableObject) {
        this.img_obj = scrollableObject;
        this.row_hgt = 0;
        this.row_half_hgt = 0;
    }

    public CoordPixelImage(ScrollableObject scrollableObject, int n, TimeBoundingBox timeBoundingBox) {
        this(scrollableObject);
        this.resetRowHeight(n);
        this.resetTimeBounds(timeBoundingBox);
    }

    public void resetRowHeight(int n) {
        this.row_hgt = n;
        this.row_half_hgt = n / 2 + 1;
    }

    public void resetTimeBounds(TimeBoundingBox timeBoundingBox) {
        this.img_endtimes = timeBoundingBox;
        this.img_starttime = timeBoundingBox.getEarliestTime();
        this.img_finaltime = timeBoundingBox.getLatestTime();
        this.ipix_start = this.img_obj.time2pixel(this.img_starttime);
        this.ipix_final = this.img_obj.time2pixel(this.img_finaltime);
        this.ipix_width = this.ipix_final - this.ipix_start + 1;
    }

    public int convertTimeToPixel(double d) {
        return this.img_obj.time2pixel(d) - this.ipix_start;
    }

    public double convertPixelToTime(int n) {
        return this.img_obj.pixel2time(n + this.ipix_start);
    }

    public int convertRowToPixel(float f) {
        return Math.round(f * (float)this.row_hgt + (float)this.row_half_hgt);
    }

    public float convertPixelToRow(int n) {
        return (float)(n - this.row_half_hgt) / (float)this.row_hgt;
    }

    public boolean contains(double d) {
        return this.img_endtimes.contains(d);
    }

    public boolean overlaps(TimeBoundingBox timeBoundingBox) {
        return this.img_endtimes.overlaps(timeBoundingBox);
    }

    public int getImageWidth() {
        return this.ipix_width;
    }
}

