/*
 * Decompiled with CFR 0.152.
 */
package logformat.clog2;

import java.io.DataInputStream;
import java.io.IOException;
import logformat.clog2.UUID;

public class RecComm {
    public static final int RECTYPE = 9;
    private static final int BYTESIZE = 48;
    public Integer etype;
    public int icomm;
    public int rank;
    public int wrank;
    public UUID gcomm;

    public int readFromDataStream(DataInputStream in) {
        try {
            this.etype = new Integer(in.readInt());
            this.icomm = in.readInt();
            this.rank = in.readInt();
            this.wrank = in.readInt();
            this.gcomm = new UUID();
            this.gcomm.readFromDataStream(in);
        }
        catch (IOException ioerr) {
            ioerr.printStackTrace();
            return 0;
        }
        return 48;
    }

    public int skipBytesFromDataStream(DataInputStream in) {
        try {
            in.skipBytes(48);
        }
        catch (IOException ioerr) {
            ioerr.printStackTrace();
            return 0;
        }
        return 48;
    }

    public static String toCommTypeString(int commtype) {
        switch (commtype) {
            case 0: {
                return "CommWorldCreate";
            }
            case 1: {
                return "CommSelfCreate";
            }
            case 10: {
                return "CommFree";
            }
            case 100: {
                return "IntraCommCreate";
            }
            case 101: {
                return "LocalIntraComm";
            }
            case 102: {
                return "RemoteIntraComm";
            }
            case 1000: {
                return "InterCommCreate";
            }
        }
        return "Unknown(" + commtype + ")";
    }

    public String toString() {
        return "RecComm[ etype=" + RecComm.toCommTypeString(this.etype) + ", icomm=" + this.icomm + ", rank=" + this.rank + ", wrank=" + this.wrank + ", gcomm=" + this.gcomm + " ]";
    }
}

