/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.input;

import base.drawable.Drawable;
import base.drawable.TimeBoundingBox;
import base.io.MixedDataIO;
import base.io.MixedDataInputStream;
import base.io.MixedRandomAccessFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import logformat.slog2.CategoryMap;
import logformat.slog2.FileBlockPtr;
import logformat.slog2.Header;
import logformat.slog2.IteratorOfAllDrawables;
import logformat.slog2.LineIDMap;
import logformat.slog2.LineIDMapList;
import logformat.slog2.TreeDir;
import logformat.slog2.TreeDirValue;
import logformat.slog2.TreeNodeID;
import logformat.slog2.input.IteratorOfGroupObjects;
import logformat.slog2.input.TreeNode;
import logformat.slog2.input.TreeTrunk;

public class InputLog {
    public static final int ITERATE_ALL = 0;
    public static final int ITERATE_ARROWS = 1;
    public static final int ITERATE_STATES = 2;
    private MixedRandomAccessFile rand_file;
    private ByteArrayInputStream bary_ins;
    private MixedDataInputStream data_ins;
    private Header filehdr;
    private TreeDir treedir;
    private CategoryMap objdefs;
    private LineIDMapList lineIDmaps;
    private byte[] buffer;
    private String full_pathname;

    public InputLog(String filename) {
        this.full_pathname = filename;
        this.rand_file = null;
        try {
            this.rand_file = new MixedRandomAccessFile(this.full_pathname, "r");
        }
        catch (IOException ferr) {
            System.err.println("InputLog: Non-recoverable IOException! Exiting ...");
            ferr.printStackTrace();
            System.exit(1);
        }
        this.buffer = null;
        this.bary_ins = null;
        this.data_ins = null;
    }

    public String getPathnameSuffix() {
        String file_sep = System.getProperty("file.separator");
        int start_idx = this.full_pathname.lastIndexOf(file_sep);
        if (start_idx > 0) {
            return this.full_pathname.substring(start_idx + 1);
        }
        return this.full_pathname;
    }

    public String getLineIDMapName(int view_ID) {
        if (this.lineIDmaps != null) {
            if (view_ID >= 0 && view_ID < this.lineIDmaps.size()) {
                LineIDMap lineIDmap = (LineIDMap)this.lineIDmaps.get(view_ID);
                return lineIDmap.getTitle();
            }
            return null;
        }
        return null;
    }

    public boolean isSLOG2() {
        try {
            this.rand_file.seek(0L);
            this.filehdr = new Header(this.rand_file);
        }
        catch (IOException ioerr) {
            System.err.println("InputLog: Non-recoverable IOException! Exiting ...");
            ioerr.printStackTrace();
            System.exit(1);
        }
        return this.filehdr != null && this.filehdr.isSLOG2();
    }

    public String getCompatibleHeader() {
        return this.filehdr.getCompatibleVersionMessage();
    }

    public static void stdoutConfirmation() {
        byte[] str_bytes = new byte[10];
        System.out.print("Do you still want the program to continue ? y/yes to continue : ");
        try {
            System.in.read(str_bytes);
        }
        catch (IOException ioerr) {
            System.err.println("InputLog: Non-recoverable IOException! Exiting ...");
            ioerr.printStackTrace();
            System.exit(1);
        }
        String in_str = new String(str_bytes).trim();
        if (in_str.equals("y") || in_str.equals("yes")) {
            System.out.println("Program continues....");
        } else {
            System.out.println("Program is terminating!...");
            System.exit(1);
        }
    }

    public void initialize() {
        this.buffer = new byte[this.filehdr.getMaxBufferByteSize()];
        this.readTreeDir();
        this.readCategoryMap();
        this.readLineIDMapList();
    }

    public FileBlockPtr getFileBlockPtrToTreeRoot() {
        return this.filehdr.blockptr2treeroot;
    }

    public int getTreeLeafByteSize() {
        return this.filehdr.getTreeLeafByteSize();
    }

    public short getNumChildrenPerNode() {
        return this.filehdr.getNumChildrenPerNode();
    }

    public short getMaxTreeDepth() {
        return this.filehdr.getMaxTreeDepth();
    }

    private String readFilePart(FileBlockPtr blockptr, String filepartname, MixedDataIO filepart) {
        if (blockptr.isNULL()) {
            String err_str = "The file block pointer to the " + filepartname + " " + "is NOT initialized!, can't read it.";
            return err_str;
        }
        if (blockptr.getBlockSize() > this.filehdr.getMaxBufferByteSize()) {
            String err_str = "Oops! Unexpected Error: The block size of the " + filepartname + " is " + "too big to read into buffer for processing.";
            return err_str;
        }
        long blk_fptr = blockptr.getFilePointer();
        int blk_size = blockptr.getBlockSize();
        try {
            this.rand_file.seek(blk_fptr);
            this.rand_file.readFully(this.buffer, 0, blk_size);
            this.bary_ins = new ByteArrayInputStream(this.buffer, 0, blk_size);
            this.data_ins = new MixedDataInputStream(this.bary_ins);
            filepart.readObject(this.data_ins);
            this.data_ins.close();
        }
        catch (IOException ioerr) {
            System.err.println("InputLog: Non-recoverable IOException! Exiting ...");
            ioerr.printStackTrace();
            System.exit(1);
        }
        return null;
    }

    private void readLineIDMapList() {
        this.lineIDmaps = new LineIDMapList();
        String err_str = this.readFilePart(this.filehdr.blockptr2lineIDmaps, "LineIDMapList", this.lineIDmaps);
        if (err_str != null) {
            System.err.println(err_str);
            System.exit(1);
        }
    }

    public LineIDMapList getLineIDMapList() {
        return this.lineIDmaps;
    }

    private void readTreeDir() {
        this.treedir = new TreeDir();
        String err_str = this.readFilePart(this.filehdr.blockptr2treedir, "Tree Directory", this.treedir);
        if (err_str != null) {
            System.err.println(err_str);
            System.exit(1);
        }
    }

    public TreeDir getTreeDir() {
        return this.treedir;
    }

    private void readCategoryMap() {
        this.objdefs = new CategoryMap();
        String err_str = this.readFilePart(this.filehdr.blockptr2categories, "CategoryMap", this.objdefs);
        if (err_str != null) {
            System.err.println(err_str);
            System.exit(1);
        }
    }

    public CategoryMap getCategoryMap() {
        return this.objdefs;
    }

    public TreeNode readTreeNode(FileBlockPtr blockptr) {
        TreeNode treenode;
        if (blockptr.isNULL()) {
            System.err.println("The file block pointer to the TreeNode is NOT initialized!, can't read it.");
            return null;
        }
        if (blockptr.getBlockSize() > this.filehdr.getMaxBufferByteSize()) {
            System.err.println("Oops! Unexpected Error: The block size of the TreeNode is too big to read into buffer for processing.");
            return null;
        }
        long blk_fptr = blockptr.getFilePointer();
        int blk_size = blockptr.getBlockSize();
        try {
            this.rand_file.seek(blk_fptr);
            this.rand_file.readFully(this.buffer, 0, blk_size);
            this.bary_ins = new ByteArrayInputStream(this.buffer, 0, blk_size);
            this.data_ins = new MixedDataInputStream(this.bary_ins);
            treenode = new TreeNode(this.data_ins, this.objdefs);
            this.data_ins.close();
        }
        catch (IOException ioerr) {
            System.err.println("InputLog: Non-recoverable IOException! Program continues ...");
            ioerr.printStackTrace();
            treenode = null;
        }
        return treenode;
    }

    public void close() {
        try {
            this.rand_file.close();
        }
        catch (IOException ioerr) {
            System.err.println("InputLog: Non-recoverable IOException! Exiting ...");
            ioerr.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public String toString() {
        StringBuffer rep = new StringBuffer();
        rep.append(this.filehdr.toString() + "\n");
        rep.append(this.objdefs.toString() + "\n");
        rep.append(this.treedir.toString() + "\n");
        rep.append(this.lineIDmaps.toString() + "\n");
        return rep.toString();
    }

    public String toString(boolean printCategoryMap, boolean printTreeDir, boolean printLineIDMaps) {
        StringBuffer rep = new StringBuffer();
        rep.append(this.filehdr.toString() + "\n");
        if (printCategoryMap) {
            rep.append(this.objdefs.toString() + "\n");
        }
        if (printTreeDir) {
            rep.append(this.treedir.toString() + "\n");
        }
        if (printLineIDMaps) {
            rep.append(this.lineIDmaps.toString() + "\n");
        }
        return rep.toString();
    }

    public Iterator iteratorOfRealDrawables(TimeBoundingBox timeframe, Drawable.Order dobj_order, int itrTopoLevel) {
        return new ItrOfAllRealDobjs(timeframe, dobj_order, itrTopoLevel);
    }

    private class ItrOfAllRealDobjs
    extends IteratorOfGroupObjects {
        private static final boolean IS_COMPOSITE = true;
        private static final short LOWEST_DEPTH = 0;
        private int iterateTopoLevel;
        private Drawable.Order dobj_order;
        private TimeBoundingBox current_timebox;
        private TreeTrunk treetrunk;
        private SortedSet timebox_set;
        private Iterator timeboxes;
        private boolean isStartTimeOrdered;
        private Drawable next_drawable;

        public ItrOfAllRealDobjs(TimeBoundingBox timeframe, Drawable.Order itrOrder, int itrTopoLevel) {
            TimeBoundingBox timebox;
            super(timeframe);
            this.iterateTopoLevel = itrTopoLevel;
            this.dobj_order = itrOrder;
            this.isStartTimeOrdered = this.dobj_order.isStartTimeOrdered();
            this.treetrunk = new TreeTrunk(InputLog.this, this.dobj_order);
            this.treetrunk.initFromTreeTop();
            TreeNode treeroot = this.treetrunk.getTreeRoot();
            if (treeroot == null) {
                this.next_drawable = null;
                return;
            }
            TimeBoundingBox timebox_root = new TimeBoundingBox(treeroot);
            this.timebox_set = new TreeSet(this.dobj_order.getTimeBoundingBoxOrder());
            Iterator entries = InputLog.this.treedir.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                TreeNodeID ID = (TreeNodeID)entry.getKey();
                TreeDirValue val = (TreeDirValue)entry.getValue();
                if (!ID.isLeaf()) continue;
                timebox = new TimeBoundingBox(val.getTimeBoundingBox());
                this.timebox_set.add(timebox);
            }
            if (this.dobj_order.isIncreasingTimeOrdered()) {
                timebox = (TimeBoundingBox)this.timebox_set.first();
                timebox.setEarliestTime(timebox_root.getEarliestTime());
                timebox = (TimeBoundingBox)this.timebox_set.last();
                timebox.setLatestTime(timebox_root.getLatestTime());
            } else {
                timebox = (TimeBoundingBox)this.timebox_set.first();
                timebox.setLatestTime(timebox_root.getLatestTime());
                timebox = (TimeBoundingBox)this.timebox_set.last();
                timebox.setEarliestTime(timebox_root.getEarliestTime());
            }
            this.timeboxes = this.timebox_set.iterator();
            timebox = (TimeBoundingBox)this.timebox_set.first();
            this.treetrunk.growInTreeWindow(treeroot, (short)0, timebox);
            super.setObjGrpItr(this.nextObjGrpItr(timeframe));
            this.next_drawable = this.getNextInQueue();
        }

        protected Iterator nextObjGrpItr(TimeBoundingBox tframe) {
            while (this.timeboxes.hasNext()) {
                TimeBoundingBox timebox = (TimeBoundingBox)this.timeboxes.next();
                this.current_timebox = timebox.getIntersection(tframe);
                if (this.current_timebox == null) continue;
                this.treetrunk.scrollTimeWindowTo(this.current_timebox);
                Iterator nestable_itr = null;
                if (this.iterateTopoLevel == 0 || this.iterateTopoLevel == 2) {
                    nestable_itr = this.treetrunk.iteratorOfRealDrawables(this.current_timebox, this.dobj_order, true, true);
                }
                Iterator nestless_itr = null;
                if (this.iterateTopoLevel == 0 || this.iterateTopoLevel == 1) {
                    nestless_itr = this.treetrunk.iteratorOfRealDrawables(this.current_timebox, this.dobj_order, true, false);
                }
                Iterator dobj_itr = null;
                if (nestable_itr != null && nestless_itr != null) {
                    dobj_itr = new IteratorOfAllDrawables(nestable_itr, nestless_itr, this.dobj_order);
                } else {
                    if (nestable_itr != null) {
                        dobj_itr = nestable_itr;
                    }
                    if (nestless_itr != null) {
                        dobj_itr = nestless_itr;
                    }
                }
                return dobj_itr;
            }
            return null;
        }

        private Drawable getNextInQueue() {
            if (this.isStartTimeOrdered) {
                while (super.hasNext()) {
                    Drawable dobj = (Drawable)super.next();
                    if (!this.current_timebox.containsWithinLeft(dobj.getEarliestTime())) continue;
                    return dobj;
                }
            } else {
                while (super.hasNext()) {
                    Drawable dobj = (Drawable)super.next();
                    if (!this.current_timebox.containsWithinRight(dobj.getLatestTime())) continue;
                    return dobj;
                }
            }
            return null;
        }

        public boolean hasNext() {
            return this.next_drawable != null;
        }

        public Object next() {
            Drawable returning_dobj = this.next_drawable;
            this.next_drawable = this.getNextInQueue();
            return returning_dobj;
        }
    }
}

