/*
 * Decompiled with CFR 0.152.
 */
package logformat.clogTOdrawable;

import base.drawable.Primitive;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import logformat.clog.InputLog;
import logformat.clog.MixedDataInputStream;
import logformat.clog.RecColl;
import logformat.clog.RecComm;
import logformat.clog.RecDefMsg;
import logformat.clog.RecDefState;
import logformat.clog.RecEvent;
import logformat.clog.RecHeader;
import logformat.clog.RecMsg;
import logformat.clog.RecRaw;
import logformat.clog.RecSrc;
import logformat.clog.RecTshift;
import logformat.clogTOdrawable.ColorNameMap;
import logformat.clogTOdrawable.ObjDef;
import logformat.clogTOdrawable.ObjMethod;
import logformat.clogTOdrawable.Topo_Arrow;
import logformat.clogTOdrawable.Topo_State;

public class Print_2pass {
    private static String filename;
    private static InputLog clog_ins;
    private static MixedDataInputStream blk_ins;
    private static int total_bytesize;
    private static int bytes_read;
    private static int rectype;
    private static Map evtdefs;
    private static List objdefs;
    private static ObjDef objdef;
    private static RecHeader header;
    private static RecDefState def;
    private static RecRaw raw;
    private static RecColl coll;
    private static RecComm comm;
    private static RecEvent event;
    private static RecMsg msg;
    private static RecSrc src;
    private static RecTshift tshift;
    private static Topo_Arrow arrowform;
    private static Topo_State stateform;
    private static ObjMethod obj_fn;

    public static final void createDefs() {
        Method start_fn = null;
        Method final_fn = null;
        clog_ins = new InputLog(filename);
        objdefs = new ArrayList();
        evtdefs = new HashMap();
        ColorNameMap.initMapFromRGBtxt("jumpshot.colors");
        ObjDef.setFirstNextCategoryIndex(0);
        arrowform = new Topo_Arrow();
        int def_idx = ObjDef.getNextCategoryIndex();
        objdef = new ObjDef(def_idx, new RecDefMsg(), arrowform, 3);
        objdef.setInfoKeys("(msg_tag=%d, msg_size=%d)");
        arrowform.setCategory(objdef);
        objdefs.add(objdef.getIndex(), objdef);
        Class<?> arrow_class = arrowform.getClass();
        Class[] arglist = new Class[]{RecHeader.class, RecRaw.class};
        try {
            start_fn = arrow_class.getMethod("matchStartEvent", arglist);
            final_fn = arrow_class.getMethod("matchFinalEvent", arglist);
        }
        catch (NoSuchMethodException err) {
            err.printStackTrace();
            System.exit(1);
        }
        obj_fn = new ObjMethod();
        Print_2pass.obj_fn.obj = arrowform;
        Print_2pass.obj_fn.method = start_fn;
        evtdefs.put(Print_2pass.objdef.start_evt, obj_fn);
        obj_fn = new ObjMethod();
        Print_2pass.obj_fn.obj = arrowform;
        Print_2pass.obj_fn.method = final_fn;
        evtdefs.put(Print_2pass.objdef.final_evt, obj_fn);
        total_bytesize = 0;
        while ((blk_ins = clog_ins.getBlockStream()) != null) {
            rectype = 0;
            block17: while (rectype != -1 && rectype != -2) {
                bytes_read = header.readFromDataStream(blk_ins);
                total_bytesize += bytes_read;
                rectype = header.getRecType();
                switch (rectype) {
                    case 6: {
                        bytes_read = def.readFromDataStream(blk_ins);
                        total_bytesize += bytes_read;
                        stateform = new Topo_State();
                        def_idx = ObjDef.getNextCategoryIndex();
                        objdef = new ObjDef(def_idx, def, stateform, 1);
                        stateform.setCategory(objdef);
                        objdefs.add(objdef.getIndex(), objdef);
                        Class<?> state_class = stateform.getClass();
                        try {
                            start_fn = state_class.getMethod("matchStartEvent", arglist);
                            final_fn = state_class.getMethod("matchFinalEvent", arglist);
                        }
                        catch (NoSuchMethodException err) {
                            err.printStackTrace();
                            System.exit(1);
                        }
                        obj_fn = new ObjMethod();
                        Print_2pass.obj_fn.obj = stateform;
                        Print_2pass.obj_fn.method = start_fn;
                        evtdefs.put(Print_2pass.objdef.start_evt, obj_fn);
                        obj_fn = new ObjMethod();
                        Print_2pass.obj_fn.obj = stateform;
                        Print_2pass.obj_fn.method = final_fn;
                        evtdefs.put(Print_2pass.objdef.final_evt, obj_fn);
                        continue block17;
                    }
                    case 1: {
                        bytes_read = raw.skipBytesFromDataStream(blk_ins);
                        total_bytesize += bytes_read;
                        continue block17;
                    }
                    case 3: {
                        bytes_read = coll.skipBytesFromDataStream(blk_ins);
                        total_bytesize += bytes_read;
                        continue block17;
                    }
                    case 4: {
                        bytes_read = comm.skipBytesFromDataStream(blk_ins);
                        total_bytesize += bytes_read;
                        continue block17;
                    }
                    case 5: {
                        bytes_read = event.skipBytesFromDataStream(blk_ins);
                        total_bytesize += bytes_read;
                        continue block17;
                    }
                    case 2: {
                        bytes_read = msg.skipBytesFromDataStream(blk_ins);
                        total_bytesize += bytes_read;
                        continue block17;
                    }
                    case 7: {
                        bytes_read = src.skipBytesFromDataStream(blk_ins);
                        total_bytesize += bytes_read;
                        continue block17;
                    }
                    case 8: {
                        bytes_read = tshift.skipBytesFromDataStream(blk_ins);
                        total_bytesize += bytes_read;
                        continue block17;
                    }
                    case -1: {
                        continue block17;
                    }
                    case -2: {
                        continue block17;
                    }
                }
                System.err.println("Unknown Record type = " + rectype);
            }
        }
        clog_ins.close();
        System.err.println("\n\t objdefs : ");
        for (int idx = 0; idx < objdefs.size(); ++idx) {
            objdef = (ObjDef)objdefs.get(idx);
            System.err.println(objdef.toString());
        }
    }

    public static final void createPrimitives() {
        int Nmatched = 0;
        System.out.println("\n\t Completed Objects : ");
        clog_ins = new InputLog(filename);
        total_bytesize = 0;
        while ((blk_ins = clog_ins.getBlockStream()) != null) {
            rectype = 0;
            block17: while (rectype != -1 && rectype != -2) {
                bytes_read = header.readFromDataStream(blk_ins);
                total_bytesize += bytes_read;
                rectype = header.getRecType();
                switch (rectype) {
                    case 6: {
                        bytes_read = def.skipBytesFromDataStream(blk_ins);
                        total_bytesize += bytes_read;
                        continue block17;
                    }
                    case 1: {
                        bytes_read = raw.readFromDataStream(blk_ins);
                        total_bytesize += bytes_read;
                        int raw_etype = Print_2pass.raw.etype;
                        if (raw_etype == -201 || raw_etype == 0) continue block17;
                        ObjMethod evt_pairing = (ObjMethod)evtdefs.get(Print_2pass.raw.etype);
                        Object[] arglist = new Object[]{header, raw};
                        Primitive obj = null;
                        try {
                            obj = (Primitive)evt_pairing.method.invoke(evt_pairing.obj, arglist);
                        }
                        catch (IllegalAccessException err) {
                            err.printStackTrace();
                            System.err.println("Offending rec_raw = " + raw);
                        }
                        catch (InvocationTargetException err) {
                            err.printStackTrace();
                        }
                        catch (NullPointerException nullerr) {
                            nullerr.printStackTrace();
                            System.err.println("Offending RecHeader = " + header);
                            System.err.println("Offending RecRaw = " + raw);
                            System.exit(1);
                        }
                        if (obj == null) continue block17;
                        System.out.println(Nmatched++ + ", " + obj.toString());
                        continue block17;
                    }
                    case 3: {
                        bytes_read = coll.skipBytesFromDataStream(blk_ins);
                        total_bytesize += bytes_read;
                        continue block17;
                    }
                    case 4: {
                        bytes_read = comm.skipBytesFromDataStream(blk_ins);
                        total_bytesize += bytes_read;
                        continue block17;
                    }
                    case 5: {
                        bytes_read = event.skipBytesFromDataStream(blk_ins);
                        total_bytesize += bytes_read;
                        continue block17;
                    }
                    case 2: {
                        bytes_read = msg.skipBytesFromDataStream(blk_ins);
                        total_bytesize += bytes_read;
                        continue block17;
                    }
                    case 7: {
                        bytes_read = src.skipBytesFromDataStream(blk_ins);
                        total_bytesize += bytes_read;
                        continue block17;
                    }
                    case 8: {
                        bytes_read = tshift.skipBytesFromDataStream(blk_ins);
                        total_bytesize += bytes_read;
                        continue block17;
                    }
                    case -1: {
                        continue block17;
                    }
                    case -2: {
                        continue block17;
                    }
                }
                System.err.println("Unknown Record type = " + rectype);
            }
        }
        clog_ins.close();
        System.err.println("\n\t " + arrowform.getPartialObjects().size() + " Unmatched arrow events");
        System.err.println("\n\t " + stateform.getPartialObjects().size() + " Unmatched state events");
    }

    public static final void main(String[] args) {
        if (args.length != 1) {
            System.err.println("It needs the filename to be the only command line arguemnt");
            System.exit(0);
        }
        filename = args[0];
        Date time1 = new Date();
        Print_2pass.createDefs();
        Date time2 = new Date();
        Print_2pass.createPrimitives();
        Date time3 = new Date();
        System.err.println("Total ByteSize of the logfile = " + total_bytesize);
        System.err.println("timeElapsed between 1 & 2 = " + (time2.getTime() - time1.getTime()) + " msec");
        System.err.println("timeElapsed between 2 & 3 = " + (time3.getTime() - time2.getTime()) + " msec");
    }

    static {
        header = new RecHeader();
        def = new RecDefState();
        raw = new RecRaw();
        coll = new RecColl();
        comm = new RecComm();
        event = new RecEvent();
        msg = new RecMsg();
        src = new RecSrc();
        tshift = new RecTshift();
    }
}

