/*
 * Decompiled with CFR 0.152.
 */
package base.topology;

import base.drawable.CoordPixelXform;
import base.drawable.DrawnBox;
import base.topology.StateBorder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;

public class State {
    private static StateBorder BorderStyle = StateBorder.WHITE_RAISED_BORDER;

    public static void setBorderStyle(StateBorder state_border) {
        BorderStyle = state_border;
    }

    private static int drawForward(Graphics2D g, Color color, Insets insets, CoordPixelXform coord_xform, DrawnBox last_drawn_pos, double start_time, float start_ypos, double final_time, float final_ypos) {
        int iFinal;
        int iStart = coord_xform.convertTimeToPixel(start_time);
        if (last_drawn_pos.coversState(iStart, iFinal = coord_xform.convertTimeToPixel(final_time))) {
            return 0;
        }
        last_drawn_pos.set(iStart, iFinal);
        int jStart = coord_xform.convertRowToPixel(start_ypos);
        int jFinal = coord_xform.convertRowToPixel(final_ypos);
        if (insets != null) {
            iStart += insets.left;
            iFinal -= insets.right;
            jStart += insets.top;
            jFinal -= insets.bottom;
        }
        boolean isStartVtxInImg = iStart >= 0;
        boolean isFinalVtxInImg = iFinal < coord_xform.getImageWidth();
        int iHead = isStartVtxInImg ? iStart : 0;
        int jHead = jStart;
        int iTail = isFinalVtxInImg ? iFinal : coord_xform.getImageWidth() - 1;
        int jTail = jFinal;
        g.setColor(color);
        g.fillRect(iHead, jHead, iTail - iHead + 1, jTail - jHead + 1);
        BorderStyle.paintStateBorder(g, color, iHead, jHead, isStartVtxInImg, iTail, jTail, isFinalVtxInImg);
        return 1;
    }

    private static boolean isPixelIn(CoordPixelXform coord_xform, Point pt, double start_time, float start_ypos, double final_time, float final_ypos) {
        int pt_y = pt.y;
        int jStart = coord_xform.convertRowToPixel(start_ypos);
        if (pt_y < jStart) {
            return false;
        }
        int jFinal = coord_xform.convertRowToPixel(final_ypos);
        if (pt_y > jFinal) {
            return false;
        }
        int pt_x = pt.x;
        int iStart = coord_xform.convertTimeToPixel(start_time);
        if (pt_x < iStart) {
            return false;
        }
        int iFinal = coord_xform.convertTimeToPixel(final_time);
        return pt_x <= iFinal;
    }

    public static int draw(Graphics2D g, Color color, Insets insets, CoordPixelXform coord_xform, DrawnBox last_drawn_pos, double start_time, float start_ypos, double final_time, float final_ypos) {
        if (start_time < final_time) {
            if (start_ypos < final_ypos) {
                return State.drawForward(g, color, insets, coord_xform, last_drawn_pos, start_time, start_ypos, final_time, final_ypos);
            }
            return State.drawForward(g, color, insets, coord_xform, last_drawn_pos, start_time, final_ypos, final_time, start_ypos);
        }
        if (start_ypos < final_ypos) {
            return State.drawForward(g, color, insets, coord_xform, last_drawn_pos, final_time, start_ypos, start_time, final_ypos);
        }
        return State.drawForward(g, color, insets, coord_xform, last_drawn_pos, final_time, final_ypos, start_time, start_ypos);
    }

    public static boolean containsPixel(CoordPixelXform coord_xform, Point pt, double start_time, float start_ypos, double final_time, float final_ypos) {
        if (start_time < final_time) {
            if (start_ypos < final_ypos) {
                return State.isPixelIn(coord_xform, pt, start_time, start_ypos, final_time, final_ypos);
            }
            return State.isPixelIn(coord_xform, pt, start_time, final_ypos, final_time, start_ypos);
        }
        if (start_ypos < final_ypos) {
            return State.isPixelIn(coord_xform, pt, final_time, start_ypos, start_time, final_ypos);
        }
        return State.isPixelIn(coord_xform, pt, final_time, final_ypos, start_time, start_ypos);
    }
}

