/*
 * Decompiled with CFR 0.152.
 */
package viewer.convertor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import logformat.slog2.input.InputLog;
import viewer.common.ActableTextField;
import viewer.common.CustomCursor;
import viewer.common.Dialogs;
import viewer.common.LogFileChooser;
import viewer.common.Routines;
import viewer.common.RuntimeExecCommand;
import viewer.convertor.AdvancingTextArea;
import viewer.convertor.ConvertorConst;
import viewer.convertor.InputStreamThread;
import viewer.convertor.ProgressAction;
import viewer.convertor.SwingProcessWorker;
import viewer.convertor.WaitingContainer;

public class ConvertorPanel
extends JPanel
implements WaitingContainer {
    private static final long serialVersionUID = 11200L;
    private JComboBox cmd_pulldown;
    private ActableTextField cmd_infile;
    private JButton infile_btn;
    private JTextField cmd_outfile;
    private JButton outfile_btn;
    private AdvancingTextArea cmd_textarea;
    private JTextField cmd_outfile_size;
    private JProgressBar cmd_progress;
    private JTextField cmd_option4jvm;
    private JTextField cmd_option4jar;
    private JTextField cmd_path2jvm;
    private ActableTextField cmd_path2jardir;
    private JTextField cmd_path2tracelib;
    private JSplitPane cmd_splitter;
    private JButton cmd_start_btn;
    private JButton cmd_stop_btn;
    private JButton cmd_help_btn;
    private JButton cmd_close4ok_btn;
    private JButton cmd_close4cancel_btn;
    private Window top_window;
    private LogFileChooser file_chooser;
    private String err_msg;
    private SwingProcessWorker logconv_worker;

    public ConvertorPanel(LogFileChooser in_file_chooser) {
        this.initComponents(in_file_chooser != null);
        this.initAllTextFields();
        this.file_chooser = in_file_chooser != null ? in_file_chooser : new LogFileChooser(false);
        this.cmd_pulldown.addActionListener(new PulldownListener());
        this.cmd_infile.addActionListener(new LogNameListener());
        this.infile_btn.addActionListener(new InputFileSelectorListener());
        this.outfile_btn.addActionListener(new OutputFileSelectorListener());
        this.cmd_path2jardir.addActionListener(new JarDirectoryListener());
        this.cmd_start_btn.addActionListener(new StartConvertorListener());
        this.cmd_stop_btn.addActionListener(new StopConvertorListener());
        this.cmd_help_btn.addActionListener(new HelpConvertorListener());
        this.finalizeWaiting();
        this.logconv_worker = null;
    }

    public void init(String filename) {
        this.top_window = SwingUtilities.windowForComponent(this);
        this.cmd_splitter.setDividerLocation(1.0);
        if (filename != null && filename.length() > 0) {
            this.cmd_infile.setText(filename);
            this.cmd_infile.fireActionPerformed();
            this.cmd_pulldown.setSelectedItem(ConvertorConst.getDefaultConvertor(filename));
            if (this.cmd_close4ok_btn != null) {
                this.cmd_close4ok_btn.setEnabled(false);
            }
            if (this.cmd_close4cancel_btn != null) {
                this.cmd_close4cancel_btn.setEnabled(true);
            }
        }
        if (this.err_msg != null) {
            Dialogs.error(this.top_window, this.err_msg);
        }
    }

    private URL getURL(String filename) {
        URL url = null;
        url = this.getClass().getResource(filename);
        return url;
    }

    private void initComponents(boolean has_close4ok_btn) {
        Border raised_border = BorderFactory.createRaisedBevelBorder();
        Border etched_border = BorderFactory.createEtchedBorder();
        Dimension row_pref_sz = new Dimension(410, 30);
        Dimension lbl_pref_sz = new Dimension(130, 26);
        Dimension pfld_pref_sz = new Dimension(lbl_pref_sz.width, 2 * lbl_pref_sz.height);
        Dimension pbar_pref_sz = new Dimension(row_pref_sz.width, pfld_pref_sz.height);
        super.setLayout(new BoxLayout(this, 1));
        Color thumb_color = UIManager.getColor("ScrollBar.thumb");
        Color pulldown_bg_color = Routines.getSlightBrighterColor(thumb_color);
        JPanel upper_panel = new JPanel();
        upper_panel.setAlignmentX(0.5f);
        upper_panel.setLayout(new BoxLayout(upper_panel, 1));
        upper_panel.add(Box.createVerticalStrut(4));
        JPanel cmd_name_panel = new JPanel();
        cmd_name_panel.setAlignmentX(0.5f);
        cmd_name_panel.setLayout(new BoxLayout(cmd_name_panel, 0));
        cmd_name_panel.add(Box.createHorizontalStrut(5));
        this.cmd_pulldown = new JComboBox();
        this.cmd_pulldown.setForeground(Color.yellow);
        this.cmd_pulldown.setBackground(pulldown_bg_color);
        this.cmd_pulldown.setToolTipText(" Logfile Convertor's Name ");
        this.cmd_pulldown.addItem("  CLOG-2  -->  SLOG-2  ");
        this.cmd_pulldown.addItem("  CLOG    -->  SLOG-2  ");
        this.cmd_pulldown.addItem("  RLOG    -->  SLOG-2  ");
        this.cmd_pulldown.addItem("  UTE     -->  SLOG-2  ");
        this.cmd_pulldown.addItem("  TXT     -->  SLOG-2  ");
        this.cmd_pulldown.setBorder(raised_border);
        this.cmd_pulldown.setEditable(false);
        this.cmd_pulldown.setAlignmentX(0.5f);
        cmd_name_panel.add(this.cmd_pulldown);
        cmd_name_panel.add(Box.createHorizontalStrut(5));
        Routines.setShortJComponentSizes(cmd_name_panel, row_pref_sz);
        upper_panel.add(cmd_name_panel);
        upper_panel.add(Box.createVerticalStrut(4));
        Insets btn_insets = new Insets(1, 1, 1, 1);
        JPanel cmd_infile_panel = new JPanel();
        cmd_infile_panel.setAlignmentX(0.5f);
        cmd_infile_panel.setLayout(new BoxLayout(cmd_infile_panel, 0));
        JLabel label = new JLabel(" Input File Spec. : ");
        label.setToolTipText("File Specification of the Input Trace File.");
        Routines.setShortJComponentSizes(label, lbl_pref_sz);
        cmd_infile_panel.add(label);
        this.cmd_infile = new ActableTextField();
        cmd_infile_panel.add(this.cmd_infile);
        URL icon_URL = this.getURL("/images/Open24.gif");
        this.infile_btn = null;
        this.infile_btn = icon_URL != null ? new JButton(new ImageIcon(icon_URL)) : new JButton("Browse");
        this.infile_btn.setToolTipText("Select a new Input Logfile");
        this.infile_btn.setMargin(btn_insets);
        cmd_infile_panel.add(this.infile_btn);
        Routines.setShortJComponentSizes(cmd_infile_panel, row_pref_sz);
        upper_panel.add(cmd_infile_panel);
        upper_panel.add(Box.createVerticalStrut(4));
        JPanel cmd_outfile_panel = new JPanel();
        cmd_outfile_panel.setAlignmentX(0.5f);
        cmd_outfile_panel.setLayout(new BoxLayout(cmd_outfile_panel, 0));
        label = new JLabel(" Output File Name : ");
        label.setToolTipText("File Name of the SLOG-2 File");
        Routines.setShortJComponentSizes(label, lbl_pref_sz);
        cmd_outfile_panel.add(label);
        this.cmd_outfile = new JTextField();
        cmd_outfile_panel.add(this.cmd_outfile);
        icon_URL = this.getURL("/images/Open24.gif");
        this.outfile_btn = null;
        this.outfile_btn = icon_URL != null ? new JButton(new ImageIcon(icon_URL)) : new JButton("Browse");
        this.outfile_btn.setToolTipText("Select a new Output Logfile");
        this.outfile_btn.setMargin(btn_insets);
        cmd_outfile_panel.add(this.outfile_btn);
        Routines.setShortJComponentSizes(cmd_outfile_panel, row_pref_sz);
        upper_panel.add(cmd_outfile_panel);
        upper_panel.add(Box.createVerticalStrut(4));
        this.cmd_textarea = new AdvancingTextArea();
        this.cmd_textarea.setColumns(50);
        this.cmd_textarea.setRows(5);
        this.cmd_textarea.setEditable(false);
        this.cmd_textarea.setLineWrap(false);
        JScrollPane scroller = new JScrollPane(this.cmd_textarea);
        scroller.setAlignmentX(0.5f);
        upper_panel.add(scroller);
        upper_panel.add(Box.createVerticalStrut(4));
        JPanel cmd_outfile_status_panel = new JPanel();
        cmd_outfile_status_panel.setAlignmentX(0.5f);
        cmd_outfile_status_panel.setLayout(new BoxLayout(cmd_outfile_status_panel, 0));
        JPanel cmd_outfile_size_panel = new JPanel();
        cmd_outfile_size_panel.setAlignmentY(0.5f);
        cmd_outfile_size_panel.setLayout(new BoxLayout(cmd_outfile_size_panel, 0));
        cmd_outfile_size_panel.setBorder(new TitledBorder(etched_border, " Output File Size "));
        this.cmd_outfile_size = new JTextField();
        this.cmd_outfile_size.setEditable(false);
        cmd_outfile_size_panel.add(this.cmd_outfile_size);
        Routines.setShortJComponentSizes(cmd_outfile_size_panel, pfld_pref_sz);
        cmd_outfile_status_panel.add(cmd_outfile_size_panel);
        JPanel cmd_progress_panel = new JPanel();
        cmd_progress_panel.setAlignmentY(0.5f);
        cmd_progress_panel.setLayout(new BoxLayout(cmd_progress_panel, 0));
        cmd_progress_panel.setBorder(new TitledBorder(etched_border, " Output to Input Logfile Size Ratio "));
        this.cmd_progress = new JProgressBar();
        this.cmd_progress.setStringPainted(true);
        cmd_progress_panel.add(this.cmd_progress);
        Routines.setShortJComponentSizes(cmd_progress_panel, pbar_pref_sz);
        cmd_outfile_status_panel.add(cmd_progress_panel);
        upper_panel.add(cmd_outfile_status_panel);
        row_pref_sz = new Dimension(410, 27);
        lbl_pref_sz = new Dimension(130, 25);
        JPanel lower_panel = new JPanel();
        lower_panel.setAlignmentX(0.5f);
        lower_panel.setLayout(new BoxLayout(lower_panel, 1));
        lower_panel.add(Box.createVerticalStrut(4));
        JPanel cmd_path2jvm_panel = new JPanel();
        cmd_path2jvm_panel.setAlignmentX(0.5f);
        cmd_path2jvm_panel.setLayout(new BoxLayout(cmd_path2jvm_panel, 0));
        label = new JLabel(" JVM Path : ");
        label.setToolTipText("Full Pathname of the Java Virtual Machine.");
        Routines.setShortJComponentSizes(label, lbl_pref_sz);
        cmd_path2jvm_panel.add(label);
        this.cmd_path2jvm = new JTextField();
        cmd_path2jvm_panel.add(this.cmd_path2jvm);
        Routines.setShortJComponentSizes(cmd_path2jvm_panel, row_pref_sz);
        lower_panel.add(cmd_path2jvm_panel);
        lower_panel.add(Box.createVerticalGlue());
        lower_panel.add(Box.createVerticalStrut(4));
        JPanel cmd_option4jvm_panel = new JPanel();
        cmd_option4jvm_panel.setAlignmentX(0.5f);
        cmd_option4jvm_panel.setLayout(new BoxLayout(cmd_option4jvm_panel, 0));
        label = new JLabel(" JVM Option : ");
        label.setToolTipText("Option to the Java Virtual Machine.");
        Routines.setShortJComponentSizes(label, lbl_pref_sz);
        cmd_option4jvm_panel.add(label);
        this.cmd_option4jvm = new JTextField();
        cmd_option4jvm_panel.add(this.cmd_option4jvm);
        Routines.setShortJComponentSizes(cmd_option4jvm_panel, row_pref_sz);
        lower_panel.add(cmd_option4jvm_panel);
        lower_panel.add(Box.createVerticalGlue());
        lower_panel.add(Box.createVerticalStrut(4));
        JPanel cmd_path2jardir_panel = new JPanel();
        cmd_path2jardir_panel.setAlignmentX(0.5f);
        cmd_path2jardir_panel.setLayout(new BoxLayout(cmd_path2jardir_panel, 0));
        label = new JLabel(" JAR Directory : ");
        label.setToolTipText("Directory of the .jar files.");
        Routines.setShortJComponentSizes(label, lbl_pref_sz);
        cmd_path2jardir_panel.add(label);
        this.cmd_path2jardir = new ActableTextField();
        cmd_path2jardir_panel.add(this.cmd_path2jardir);
        Routines.setShortJComponentSizes(cmd_path2jardir_panel, row_pref_sz);
        lower_panel.add(cmd_path2jardir_panel);
        lower_panel.add(Box.createVerticalGlue());
        lower_panel.add(Box.createVerticalStrut(4));
        JPanel cmd_option4jar_panel = new JPanel();
        cmd_option4jar_panel.setAlignmentX(0.5f);
        cmd_option4jar_panel.setLayout(new BoxLayout(cmd_option4jar_panel, 0));
        label = new JLabel(" JAR Option : ");
        label.setToolTipText("Option to the selected Convertor.");
        Routines.setShortJComponentSizes(label, lbl_pref_sz);
        cmd_option4jar_panel.add(label);
        this.cmd_option4jar = new JTextField();
        cmd_option4jar_panel.add(this.cmd_option4jar);
        Routines.setShortJComponentSizes(cmd_option4jar_panel, row_pref_sz);
        lower_panel.add(cmd_option4jar_panel);
        lower_panel.add(Box.createVerticalGlue());
        lower_panel.add(Box.createVerticalStrut(4));
        JPanel cmd_path2tracelib_panel = new JPanel();
        cmd_path2tracelib_panel.setAlignmentX(0.5f);
        cmd_path2tracelib_panel.setLayout(new BoxLayout(cmd_path2tracelib_panel, 0));
        label = new JLabel(" TraceLibrary Path : ");
        label.setToolTipText("Trace Input Library path of the selected Convertor");
        Routines.setShortJComponentSizes(label, lbl_pref_sz);
        cmd_path2tracelib_panel.add(label);
        this.cmd_path2tracelib = new JTextField();
        cmd_path2tracelib_panel.add(this.cmd_path2tracelib);
        Routines.setShortJComponentSizes(cmd_path2tracelib_panel, row_pref_sz);
        lower_panel.add(cmd_path2tracelib_panel);
        lower_panel.add(Box.createVerticalStrut(4));
        this.cmd_splitter = new JSplitPane(0, true, upper_panel, lower_panel);
        this.cmd_splitter.setAlignmentX(0.5f);
        this.cmd_splitter.setOneTouchExpandable(true);
        this.err_msg = null;
        try {
            this.cmd_splitter.setResizeWeight(1.0);
        }
        catch (NoSuchMethodError err) {
            this.err_msg = "Method JSplitPane.setResizeWeight() cannot be found.\nThis indicates you are running an older Java2 RunTime,\nlike the one in J2SDK 1.2.2 or older. If this is the case,\nsome features in Convertor window may not work correctly,\nFor instance, resize of the window may not resize upper \nTextArea.  Manuel movement of splitter is needed.\n";
        }
        super.add(this.cmd_splitter);
        super.add(Box.createVerticalStrut(4));
        JPanel cmd_button_panel = new JPanel();
        cmd_button_panel.setLayout(new BoxLayout(cmd_button_panel, 0));
        cmd_button_panel.setAlignmentX(0.5f);
        cmd_button_panel.add(Box.createHorizontalGlue());
        btn_insets = new Insets(2, 4, 2, 4);
        this.cmd_start_btn = new JButton("Convert");
        icon_URL = this.getURL("/images/Convert24.gif");
        if (icon_URL != null) {
            this.cmd_start_btn.setIcon(new ImageIcon(icon_URL));
            this.cmd_start_btn.setVerticalTextPosition(0);
            this.cmd_start_btn.setHorizontalTextPosition(4);
            this.cmd_start_btn.setMargin(btn_insets);
        }
        this.cmd_start_btn.setToolTipText("Proceed with the selected logfile conversion.");
        cmd_button_panel.add(this.cmd_start_btn);
        cmd_button_panel.add(Box.createHorizontalGlue());
        this.cmd_stop_btn = new JButton(" Stop ");
        icon_URL = this.getURL("/images/Stop24.gif");
        if (icon_URL != null) {
            this.cmd_stop_btn.setIcon(new ImageIcon(icon_URL));
            this.cmd_stop_btn.setVerticalTextPosition(0);
            this.cmd_stop_btn.setHorizontalTextPosition(4);
        }
        this.cmd_stop_btn.setToolTipText("Stop the ongoing logfile conversion.");
        cmd_button_panel.add(this.cmd_stop_btn);
        cmd_button_panel.add(Box.createHorizontalGlue());
        this.cmd_help_btn = new JButton(" Usage ");
        icon_URL = this.getURL("/images/About24.gif");
        if (icon_URL != null) {
            this.cmd_help_btn.setIcon(new ImageIcon(icon_URL));
            this.cmd_help_btn.setVerticalTextPosition(0);
            this.cmd_help_btn.setHorizontalTextPosition(4);
        }
        this.cmd_help_btn.setToolTipText("Usage information of the selected logfile convertor.");
        cmd_button_panel.add(this.cmd_help_btn);
        cmd_button_panel.add(Box.createHorizontalGlue());
        this.cmd_close4cancel_btn = new JButton("Cancel");
        icon_URL = this.getURL("/images/ConvertCancel24.gif");
        if (icon_URL != null) {
            this.cmd_close4cancel_btn.setIcon(new ImageIcon(icon_URL));
            this.cmd_close4cancel_btn.setVerticalTextPosition(0);
            this.cmd_close4cancel_btn.setHorizontalTextPosition(4);
        }
        this.cmd_close4cancel_btn.setToolTipText("Close this panel.");
        cmd_button_panel.add(this.cmd_close4cancel_btn);
        cmd_button_panel.add(Box.createHorizontalGlue());
        this.cmd_close4ok_btn = null;
        if (has_close4ok_btn) {
            this.cmd_close4ok_btn = new JButton("OK");
            icon_URL = this.getURL("/images/ConvertOk24.gif");
            if (icon_URL != null) {
                this.cmd_close4ok_btn.setIcon(new ImageIcon(icon_URL));
                this.cmd_close4ok_btn.setVerticalTextPosition(0);
                this.cmd_close4ok_btn.setHorizontalTextPosition(4);
            }
            this.cmd_close4ok_btn.setToolTipText("Display the last converted SLOG2 logfile and Exit this dialog box.");
            cmd_button_panel.add(this.cmd_close4ok_btn);
            cmd_button_panel.add(Box.createHorizontalGlue());
        }
        super.add(cmd_button_panel);
    }

    private void initAllTextFields() {
        ConvertorConst.initializeSystemProperties();
        this.cmd_path2jvm.setText(ConvertorConst.getDefaultPathToJVM());
        String path2jardir = ConvertorConst.getDefaultPathToJarDir();
        this.cmd_path2jardir.setText(path2jardir);
        String option4jvm = null;
        try {
            option4jvm = this.cmd_option4jvm.getText();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (option4jvm == null || option4jvm.length() <= 0) {
            // empty if block
        }
        this.cmd_option4jvm.setText("-Xms32m -Xmx64m");
    }

    public String selectLogFile() {
        int istat = this.file_chooser.showOpenDialog(this.top_window);
        if (istat == 0) {
            File selected_file = this.file_chooser.getSelectedFile();
            if (selected_file != null) {
                File selected_dir = selected_file.getParentFile();
                if (selected_dir != null) {
                    this.file_chooser.setCurrentDirectory(selected_dir);
                }
                return selected_file.getPath();
            }
        } else {
            Dialogs.info(this.top_window, "No file chosen", null);
        }
        return null;
    }

    private void printSelectedConvertorHelp() {
        String convertor = (String)this.cmd_pulldown.getSelectedItem();
        String path2jardir = this.cmd_path2jardir.getText();
        String jar_path = ConvertorConst.getDefaultJarPath(path2jardir, convertor);
        File jar_file = new File(jar_path);
        if (!jar_file.exists()) {
            Dialogs.error(this.top_window, jar_path + " does not exist!");
            return;
        }
        if (!jar_file.canRead()) {
            Dialogs.error(this.top_window, jar_path + " is NOT readable!\n");
            return;
        }
        RuntimeExecCommand exec_cmd = new RuntimeExecCommand();
        exec_cmd.addWholeString(this.cmd_path2jvm.getText());
        exec_cmd.addTokenizedString(this.cmd_option4jvm.getText());
        String path2tracelib = this.cmd_path2tracelib.getText();
        if (path2tracelib != null && path2tracelib.length() > 0) {
            exec_cmd.addWholeString("-Djava.library.path=" + path2tracelib);
        }
        exec_cmd.addWholeString("-jar");
        exec_cmd.addWholeString(jar_path);
        exec_cmd.addWholeString("-h");
        this.cmd_textarea.append("Executing " + exec_cmd.toString() + "....");
        Runtime runtime = Runtime.getRuntime();
        try {
            Process proc = runtime.exec(exec_cmd.toStringArray());
            InputStreamThread proc_err_task = new InputStreamThread(proc.getErrorStream(), "Error", this.cmd_textarea);
            InputStreamThread proc_out_task = new InputStreamThread(proc.getInputStream(), "Output", this.cmd_textarea);
            proc_err_task.start();
            proc_out_task.start();
            int proc_istatus = proc.waitFor();
            proc_err_task.stopRunning();
            proc_err_task = null;
            proc_out_task.stopRunning();
            proc_out_task = null;
            this.cmd_textarea.append("\n> Ending with exit status " + proc_istatus + "\n");
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
    }

    private SwingProcessWorker convertSelectedLogFile() {
        String infile_name = this.cmd_infile.getText();
        File infile = new File(infile_name);
        if (!infile.exists()) {
            Dialogs.error(this.top_window, infile_name + " does not exist!\n" + "No conversion will take place.");
            return null;
        }
        if (infile.isDirectory()) {
            Dialogs.error(this.top_window, infile_name + " is a directory!\n" + "No conversion will take place.");
            return null;
        }
        if (!infile.canRead()) {
            Dialogs.error(this.top_window, "File " + infile_name + " is NOT readable!\n" + "No conversion will take place.");
            return null;
        }
        InputLog slog_ins = null;
        try {
            slog_ins = new InputLog(infile_name);
        }
        catch (NullPointerException nperr) {
            slog_ins = null;
        }
        catch (Exception err) {
            slog_ins = null;
        }
        if (slog_ins != null && slog_ins.isSLOG2()) {
            Dialogs.error(this.top_window, infile_name + " is already a SLOG-2 file!\n" + "No conversion will take place.");
            this.cmd_outfile.setText(infile_name);
            return null;
        }
        String outfile_name = this.cmd_outfile.getText();
        File outfile = new File(outfile_name);
        if (outfile.exists()) {
            if (outfile.isDirectory()) {
                Dialogs.error(this.top_window, outfile_name + " is a directory!\n" + "No conversion will take place.");
                return null;
            }
            if (!outfile.canWrite()) {
                Dialogs.error(this.top_window, "File " + outfile_name + " cannot be written!\n" + "No conversion will take place.");
                return null;
            }
            if (!Dialogs.confirm(this.top_window, outfile_name + " already exists! " + "Do you want to overwrite it ?")) {
                Dialogs.info(this.top_window, "Please change the output filename and restart the conversion again.", null);
                return null;
            }
            outfile.delete();
        }
        String convertor = (String)this.cmd_pulldown.getSelectedItem();
        String path2jardir = this.cmd_path2jardir.getText();
        String jar_path = ConvertorConst.getDefaultJarPath(path2jardir, convertor);
        File jar_file = new File(jar_path);
        if (!jar_file.exists()) {
            Dialogs.error(this.top_window, jar_path + " does not exist!");
            return null;
        }
        RuntimeExecCommand exec_cmd = new RuntimeExecCommand();
        exec_cmd.addWholeString(this.cmd_path2jvm.getText());
        exec_cmd.addTokenizedString(this.cmd_option4jvm.getText());
        String path2tracelib = this.cmd_path2tracelib.getText();
        if (path2tracelib != null && path2tracelib.length() > 0) {
            exec_cmd.addWholeString("-Djava.library.path=" + path2tracelib);
        }
        exec_cmd.addWholeString("-jar");
        exec_cmd.addWholeString(jar_path);
        String option4jar = this.cmd_option4jar.getText();
        if (option4jar != null && option4jar.length() > 0) {
            exec_cmd.addTokenizedString(option4jar);
        }
        exec_cmd.addWholeString("-o");
        exec_cmd.addWholeString(outfile_name);
        exec_cmd.addWholeString(infile_name);
        ProgressAction conv_progress = new ProgressAction(this.cmd_outfile_size, this.cmd_progress);
        conv_progress.initialize(infile, outfile);
        SwingProcessWorker conv_worker = new SwingProcessWorker(this, this.cmd_textarea);
        conv_worker.initialize(exec_cmd.toStringArray(), conv_progress);
        conv_worker.start();
        return conv_worker;
    }

    private void resetAllButtons(boolean isConvertingLogfile) {
        this.cmd_start_btn.setEnabled(!isConvertingLogfile);
        this.cmd_stop_btn.setEnabled(isConvertingLogfile);
        this.cmd_help_btn.setEnabled(!isConvertingLogfile);
        if (this.cmd_close4cancel_btn != null) {
            this.cmd_close4cancel_btn.setEnabled(!isConvertingLogfile);
        }
        if (this.cmd_close4ok_btn != null) {
            if (this.logconv_worker != null && this.logconv_worker.isEndedNormally()) {
                this.cmd_close4ok_btn.setEnabled(!isConvertingLogfile);
            } else {
                this.cmd_close4ok_btn.setEnabled(false);
            }
        }
    }

    public void initializeWaiting() {
        Routines.setComponentAndChildrenCursors(this.cmd_splitter, CustomCursor.Wait);
        this.resetAllButtons(true);
    }

    public void finalizeWaiting() {
        this.resetAllButtons(false);
        Routines.setComponentAndChildrenCursors(this.cmd_splitter, CustomCursor.Normal);
    }

    public void addActionListenerForOkayButton(ActionListener action) {
        if (action != null && this.cmd_close4ok_btn != null) {
            this.cmd_close4ok_btn.addActionListener(action);
        }
    }

    public void addActionListenerForCancelButton(ActionListener action) {
        if (action != null && this.cmd_close4cancel_btn != null) {
            this.cmd_close4cancel_btn.addActionListener(action);
        }
    }

    public String getOutputSLOG2Name() {
        return this.cmd_outfile.getText();
    }

    private class HelpConvertorListener
    implements ActionListener {
        private HelpConvertorListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            ConvertorPanel.this.cmd_path2jardir.fireActionPerformed();
            ConvertorPanel.this.printSelectedConvertorHelp();
        }
    }

    private class StopConvertorListener
    implements ActionListener {
        private StopConvertorListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (ConvertorPanel.this.logconv_worker != null) {
                ConvertorPanel.this.logconv_worker.finished();
                ConvertorPanel.this.logconv_worker = null;
            }
        }
    }

    private class StartConvertorListener
    implements ActionListener {
        private StartConvertorListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            ConvertorPanel.this.logconv_worker = ConvertorPanel.this.convertSelectedLogFile();
        }
    }

    private class JarDirectoryListener
    implements ActionListener {
        private JarDirectoryListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            String path2jardir;
            String new_path2tracelib;
            String convertor = (String)ConvertorPanel.this.cmd_pulldown.getSelectedItem();
            String cur_path2tracelib = ConvertorPanel.this.cmd_path2tracelib.getText();
            if (cur_path2tracelib == null) {
                cur_path2tracelib = "";
            }
            if ((new_path2tracelib = ConvertorConst.getDefaultTraceLibPath(convertor, path2jardir = ConvertorPanel.this.cmd_path2jardir.getText())) == null) {
                new_path2tracelib = "";
            }
            if (cur_path2tracelib.equals(new_path2tracelib)) {
                return;
            }
            path2jardir = ConvertorConst.getDefaultPathToJarDir();
            String def_path2tracelib = ConvertorConst.getDefaultTraceLibPath(convertor, path2jardir);
            if (def_path2tracelib == null) {
                def_path2tracelib = "";
            }
            if (!cur_path2tracelib.equals(def_path2tracelib) && !Dialogs.confirm(ConvertorPanel.this.top_window, "TraceLibrary Path has been modified from the original default value.\nShould it be updated by the new default value based on your modified JAR Directory ?")) {
                return;
            }
            ConvertorPanel.this.cmd_path2tracelib.setText(new_path2tracelib);
        }
    }

    private class PulldownListener
    implements ActionListener {
        private PulldownListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            String convertor = (String)ConvertorPanel.this.cmd_pulldown.getSelectedItem();
            String path2jardir = ConvertorConst.getDefaultPathToJarDir();
            ConvertorPanel.this.cmd_path2tracelib.setText(ConvertorConst.getDefaultTraceLibPath(convertor, path2jardir));
            ConvertorPanel.this.printSelectedConvertorHelp();
        }
    }

    private class OutputFileSelectorListener
    implements ActionListener {
        private OutputFileSelectorListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            String filename = ConvertorPanel.this.selectLogFile();
            if (filename != null && filename.length() > 0) {
                ConvertorPanel.this.cmd_outfile.setText(filename);
            }
        }
    }

    private class InputFileSelectorListener
    implements ActionListener {
        private InputFileSelectorListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            String filename = ConvertorPanel.this.selectLogFile();
            if (filename != null && filename.length() > 0) {
                ConvertorPanel.this.cmd_infile.setText(filename);
                ConvertorPanel.this.printSelectedConvertorHelp();
            }
        }
    }

    private class LogNameListener
    implements ActionListener {
        private LogNameListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            String infile_name = ConvertorPanel.this.cmd_infile.getText();
            String outfile_name = ConvertorConst.getDefaultSLOG2Name(infile_name);
            ConvertorPanel.this.cmd_outfile.setText(outfile_name);
        }
    }
}

