/*
 * Decompiled with CFR 0.152.
 */
package viewer.first;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import viewer.common.Dialogs;
import viewer.common.TopControl;
import viewer.common.TopWindow;
import viewer.first.FirstMenuBar;
import viewer.first.FirstPanel;
import viewer.zoomable.Debug;
import viewer.zoomable.Profile;

public class FirstFrame
extends JFrame
implements TopControl {
    private static final long serialVersionUID = 14300L;
    private static boolean isApplet = false;
    private static String filename = null;
    private static int view_ID = -1;
    private FirstPanel top_panel;
    private FirstMenuBar top_menubar;
    private static String help_msg = "Usage: java timelines.MainFrame [options] [slog2_filename]\nOptions: \n\t [-h|-help|--help]                 \t Display this message.\n\t [-debug]                          \t Turn on Debugging output\n\t [-profile]                        \t Turn on Profiling output\n\t [-v view_ID ]                     \t Default value is -1.\n";

    public FirstFrame() {
        super("Jumpshot-4");
        super.setDefaultCloseOperation(0);
        TopWindow.First.setWindow(this);
        this.top_panel = new FirstPanel(isApplet, filename, view_ID);
        super.setContentPane(this.top_panel);
        this.top_menubar = new FirstMenuBar(isApplet, this.top_panel);
        super.setJMenuBar(this.top_menubar);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (Dialogs.confirm(TopWindow.First.getWindow(), "Are you sure you want to exit Jumpshot-4 ?")) {
                    TopWindow.First.disposeAll();
                }
            }
        });
    }

    public void init() {
        this.top_panel.init();
    }

    public void setEditPreferenceButtonEnabled(boolean val) {
        this.top_panel.getEditPreferenceButton().setEnabled(val);
    }

    public void setShowLegendButtonEnabled(boolean val) {
        this.top_panel.getShowLegendButton().setEnabled(val);
    }

    public void setShowTimelineButtonEnabled(boolean val) {
        this.top_panel.getShowTimelineButton().setEnabled(val);
    }

    public static void checkVersion() {
        String vers = System.getProperty("java.version");
        System.out.println("Java is version " + vers + ".");
        if (vers.compareTo("1.2.0") < 0) {
            System.err.println("WARNING: Java is version " + vers + ". \n" + "\t It is too old to run this viewer.");
        }
    }

    public static void main(String[] args) {
        FirstFrame.checkVersion();
        FirstFrame.parseCmdLineArgs(args);
        Debug.initTextArea();
        System.out.println("Starting the SLOG-2 Display Program ..... ");
        FirstFrame frame = new FirstFrame();
        frame.pack();
        TopWindow.layoutIdealLocations();
        frame.setVisible(true);
        frame.init();
    }

    private static void parseCmdLineArgs(String[] argv) {
        StringBuffer err_msg = new StringBuffer();
        int idx = 0;
        try {
            while (idx < argv.length) {
                if (argv[idx].startsWith("-")) {
                    if (argv[idx].equals("-h") || argv[idx].equals("-help") || argv[idx].equals("--help")) {
                        System.out.println(help_msg);
                        System.out.flush();
                        System.exit(0);
                        continue;
                    }
                    if (argv[idx].equals("-v")) {
                        String arg_str = argv[++idx];
                        view_ID = Integer.parseInt(arg_str);
                        err_msg.append("\n view_ID = " + arg_str);
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-debug")) {
                        Debug.setActive(true);
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-profile")) {
                        Profile.setActive(true);
                        ++idx;
                        continue;
                    }
                    System.err.println("Unrecognized option, " + argv[idx] + ", at " + FirstFrame.indexOrderStr(idx + 1) + " command line argument");
                    System.out.flush();
                    System.exit(1);
                    continue;
                }
                filename = argv[idx];
                ++idx;
            }
        }
        catch (NumberFormatException numerr) {
            if (err_msg.length() > 0) {
                System.err.println(err_msg.toString());
            }
            System.err.println("Error occurs after option " + argv[idx - 1] + ", " + FirstFrame.indexOrderStr(idx) + " command line argument.  It needs a number.");
            numerr.printStackTrace();
        }
    }

    private static String indexOrderStr(int idx) {
        switch (idx) {
            case 1: {
                return Integer.toString(idx) + "st";
            }
            case 2: {
                return Integer.toString(idx) + "nd";
            }
            case 3: {
                return Integer.toString(idx) + "rd";
            }
        }
        return Integer.toString(idx) + "th";
    }
}

