/*
 * Decompiled with CFR 0.152.
 */
package viewer.first;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import logformat.slog2.LineIDMap;
import viewer.common.ActableTextField;
import viewer.common.Dialogs;
import viewer.common.Routines;
import viewer.common.TopWindow;
import viewer.first.HTMLviewer;
import viewer.first.LogFileOperations;

public class FirstPanel
extends JPanel {
    private static final long serialVersionUID = 14100L;
    private static String about_str = "Jumpshot-4, the SLOG-2 viewer.\nbug-reports/questions:\n            chan@mcs.anl.gov";
    private static String manual_path = "/html/usersguide.html";
    private static String faq_path = "/html/faq_index.html";
    private static String js_icon_path = "/images/jumpshot.gif";
    private static String open_icon_path = "/images/Open24.gif";
    private static String convert_icon_path = "/images/Convert24.gif";
    private static String show_icon_path = "/images/New24.gif";
    private static String close_icon_path = "/images/Stop24.gif";
    private static String legend_icon_path = "/images/Properties24.gif";
    private static String prefer_icon_path = "/images/Preferences24.gif";
    private static String manual_icon_path = "/images/Help24.gif";
    private static String faq_icon_path = "/images/Information24.gif";
    private static String about_icon_path = "/images/About24.gif";
    private ActableTextField logname_fld;
    private JComboBox pulldown_list;
    private JButton file_select_btn;
    private JButton file_convert_btn;
    private JButton file_close_btn;
    private JButton show_timeline_btn;
    private JButton show_legend_btn;
    private JButton edit_prefer_btn;
    private JButton help_manual_btn;
    private JButton help_faq_btn;
    private JButton help_about_btn;
    private HTMLviewer manual_viewer;
    private HTMLviewer faq_viewer;
    private LogFileOperations file_ops;
    private String logfile_name;
    private int view_ID;

    public FirstPanel(boolean bl, String string, int n) {
        super.setLayout(new BorderLayout());
        Border border = BorderFactory.createLoweredBevelBorder();
        Border border2 = BorderFactory.createEtchedBorder();
        this.file_ops = new LogFileOperations(bl);
        this.logfile_name = string;
        this.view_ID = n;
        Dimension dimension = new Dimension(410, 27);
        Dimension dimension2 = new Dimension(110, 25);
        Dimension dimension3 = new Dimension(dimension.width - dimension2.width, dimension2.height);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalGlue());
        JPanel jPanel2 = new JPanel();
        jPanel2.setAlignmentX(0.5f);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JLabel jLabel = new JLabel(" LogName : ");
        Routines.setShortJComponentSizes(jLabel, dimension2);
        jPanel2.add(jLabel);
        this.logname_fld = new ActableTextField(this.logfile_name, 40);
        this.logname_fld.setBorder(BorderFactory.createCompoundBorder(border, border2));
        this.logname_fld.addActionListener(new LogNameTextFieldListener());
        Routines.setShortJComponentSizes(this.logname_fld, dimension3);
        jPanel2.add(this.logname_fld);
        Routines.setShortJComponentSizes(jPanel2, dimension);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(Box.createVerticalStrut(4));
        JPanel jPanel3 = new JPanel();
        jPanel3.setAlignmentX(0.5f);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jLabel = new JLabel(" ViewMap : ");
        Routines.setShortJComponentSizes(jLabel, dimension2);
        jPanel3.add(jLabel);
        this.pulldown_list = new JComboBox();
        this.pulldown_list.setBorder(border);
        this.pulldown_list.addActionListener(new ViewMapComboBoxListener());
        Routines.setShortJComponentSizes(this.pulldown_list, dimension3);
        jPanel3.add(this.pulldown_list);
        Routines.setShortJComponentSizes(jPanel3, dimension);
        jPanel.add(jPanel3);
        jPanel.add(Box.createVerticalGlue());
        jPanel.setBorder(border2);
        super.add((Component)jPanel, "Center");
        JToolBar jToolBar = this.createToolBarAndButtons(0);
        super.add((Component)jToolBar, "South");
    }

    private JToolBar createToolBarAndButtons(int n) {
        JToolBar jToolBar = new JToolBar(n);
        jToolBar.setFloatable(true);
        Insets insets = new Insets(1, 1, 1, 1);
        URL uRL = null;
        uRL = this.getURL(open_icon_path);
        this.file_select_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("SELECT");
        this.file_select_btn.setToolTipText("Select a new logfile");
        this.file_select_btn.setMargin(insets);
        this.file_select_btn.addActionListener(new FileSelectButtonListener());
        jToolBar.add(this.file_select_btn);
        uRL = null;
        uRL = this.getURL(convert_icon_path);
        this.file_convert_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("CONVERT");
        this.file_convert_btn.setToolTipText("Invoke the Logfile Convertor");
        this.file_convert_btn.setMargin(insets);
        this.file_convert_btn.addActionListener(new FileConvertButtonListener());
        jToolBar.add(this.file_convert_btn);
        jToolBar.addSeparator();
        uRL = null;
        uRL = this.getURL(legend_icon_path);
        this.show_legend_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("LEGEND");
        this.show_legend_btn.setToolTipText("Display the Legend window");
        this.show_legend_btn.setMargin(insets);
        this.show_legend_btn.addActionListener(new ShowLegendButtonListener());
        jToolBar.add(this.show_legend_btn);
        uRL = null;
        uRL = this.getURL(show_icon_path);
        this.show_timeline_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("TIMELINE");
        this.show_timeline_btn.setToolTipText("Display the Timeline window");
        this.show_timeline_btn.setMargin(insets);
        this.show_timeline_btn.addActionListener(new ViewMapComboBoxListener());
        jToolBar.add(this.show_timeline_btn);
        jToolBar.addSeparator();
        uRL = null;
        uRL = this.getURL(prefer_icon_path);
        this.edit_prefer_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("PREFERENCE");
        this.edit_prefer_btn.setToolTipText("Open the Preference window");
        this.edit_prefer_btn.setMargin(insets);
        this.edit_prefer_btn.addActionListener(new EditPreferButtonListener());
        jToolBar.add(this.edit_prefer_btn);
        jToolBar.addSeparator();
        uRL = null;
        uRL = this.getURL(manual_icon_path);
        this.help_manual_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("MANUAL");
        this.help_manual_btn.setToolTipText("Open the user's manual window");
        this.help_manual_btn.setMargin(insets);
        this.help_manual_btn.addActionListener(new HelpManualButtonListener());
        jToolBar.add(this.help_manual_btn);
        uRL = null;
        uRL = this.getURL(faq_icon_path);
        this.help_faq_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("FAQ");
        this.help_faq_btn.setToolTipText("Open the FAQ window");
        this.help_faq_btn.setMargin(insets);
        this.help_faq_btn.addActionListener(new HelpFAQsButtonListener());
        jToolBar.add(this.help_faq_btn);
        uRL = null;
        uRL = this.getURL(about_icon_path);
        this.help_about_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("ABOUT");
        this.help_about_btn.setToolTipText("Open the About-This window");
        this.help_about_btn.setMargin(insets);
        this.help_about_btn.addActionListener(new HelpAboutButtonListener());
        uRL = null;
        uRL = this.getURL(close_icon_path);
        this.file_close_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("CLOSE");
        this.file_close_btn.setToolTipText("Close the logfile");
        this.file_close_btn.setMargin(insets);
        this.file_close_btn.addActionListener(new FileCloseButtonListener());
        this.manual_viewer = new HTMLviewer("Manual", this.help_manual_btn);
        this.faq_viewer = new HTMLviewer("FAQs", this.help_faq_btn);
        return jToolBar;
    }

    public void init() {
        this.file_ops.init();
        if (this.logfile_name != null) {
            this.logname_fld.fireActionPerformed();
        }
    }

    private URL getURL(String string) {
        return this.getClass().getResource(string);
    }

    private void setMapPullDownMenu(List list) {
        this.pulldown_list.removeAllItems();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = "  " + ((LineIDMap)iterator.next()).getTitle();
            this.pulldown_list.addItem(string);
        }
    }

    public JButton getLogFileSelectButton() {
        return this.file_select_btn;
    }

    public JButton getLogFileConvertButton() {
        return this.file_convert_btn;
    }

    public JButton getLogFileCloseButton() {
        return this.file_close_btn;
    }

    public JButton getShowLegendButton() {
        return this.show_legend_btn;
    }

    public JButton getShowTimelineButton() {
        return this.show_timeline_btn;
    }

    public JButton getEditPreferenceButton() {
        return this.edit_prefer_btn;
    }

    public JButton getHelpManualButton() {
        return this.help_manual_btn;
    }

    public JButton getHelpFAQsButton() {
        return this.help_faq_btn;
    }

    public JButton getHelpAboutButton() {
        return this.help_about_btn;
    }

    private class FileCloseButtonListener
    implements ActionListener {
        private FileCloseButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FirstPanel.this.file_ops.disposeLogFileAndResources();
            FirstPanel.this.pulldown_list.removeAllItems();
        }
    }

    private class HelpAboutButtonListener
    implements ActionListener {
        private HelpAboutButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            URL uRL = FirstPanel.this.getURL(js_icon_path);
            if (uRL != null) {
                ImageIcon imageIcon = new ImageIcon(uRL);
                Dialogs.info(TopWindow.First.getWindow(), about_str, imageIcon);
            } else {
                Dialogs.info(TopWindow.First.getWindow(), about_str, null);
            }
        }
    }

    private class HelpFAQsButtonListener
    implements ActionListener {
        private HelpFAQsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            URL uRL = FirstPanel.this.getURL(faq_path);
            if (uRL != null) {
                FirstPanel.this.faq_viewer.init(uRL);
                FirstPanel.this.faq_viewer.setVisible(true);
            } else {
                Dialogs.warn(TopWindow.First.getWindow(), "Cannot locate " + faq_path + ".");
            }
        }
    }

    private class HelpManualButtonListener
    implements ActionListener {
        private HelpManualButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            URL uRL = FirstPanel.this.getURL(manual_path);
            if (uRL != null) {
                FirstPanel.this.manual_viewer.init(uRL);
                FirstPanel.this.manual_viewer.setVisible(true);
            } else {
                Dialogs.warn(TopWindow.First.getWindow(), "Cannot locate " + manual_path + ".");
            }
        }
    }

    private class EditPreferButtonListener
    implements ActionListener {
        private EditPreferButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FirstPanel.this.file_ops.showPreferenceWindow();
        }
    }

    private class ShowLegendButtonListener
    implements ActionListener {
        private ShowLegendButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FirstPanel.this.file_ops.showLegendWindow();
        }
    }

    private class ViewMapComboBoxListener
    implements ActionListener {
        private ViewMapComboBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FirstPanel.this.view_ID = FirstPanel.this.pulldown_list.getSelectedIndex();
            if (FirstPanel.this.view_ID >= 0 && FirstPanel.this.view_ID < FirstPanel.this.pulldown_list.getItemCount()) {
                FirstPanel.this.file_ops.createTimelineWindow(FirstPanel.this.view_ID);
            }
        }
    }

    private class LogNameTextFieldListener
    implements ActionListener {
        private LogNameTextFieldListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FirstPanel.this.file_ops.disposeLogFileAndResources();
            List list = FirstPanel.this.file_ops.openLogFile(FirstPanel.this.logname_fld);
            if (list != null) {
                FirstPanel.this.setMapPullDownMenu(list);
            }
        }
    }

    private class FileConvertButtonListener
    implements ActionListener {
        private FileConvertButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = null;
            String string2 = FirstPanel.this.logname_fld.getText();
            string = string2 != null && string2.length() > 0 ? FirstPanel.this.file_ops.convertLogFile(string2) : FirstPanel.this.file_ops.convertLogFile(null);
            if (string != null && string.length() > 0) {
                FirstPanel.this.logname_fld.setText(string);
                FirstPanel.this.logname_fld.fireActionPerformed();
            }
        }
    }

    private class FileSelectButtonListener
    implements ActionListener {
        private FileSelectButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = FirstPanel.this.file_ops.selectLogFile();
            if (string != null && string.length() > 0) {
                FirstPanel.this.logname_fld.setText(string);
                FirstPanel.this.logname_fld.fireActionPerformed();
            }
        }
    }
}

