/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2;

import base.io.MixedDataIO;
import base.io.MixedDataInput;
import base.io.MixedDataOutput;
import base.io.MixedRandomAccessFile;
import java.io.IOException;
import logformat.slog2.FileBlockPtr;

public class Header
implements MixedDataIO {
    public static final int BYTESIZE = MixedRandomAccessFile.getStringByteSize("SLOG 2.0.6") + 2 + 4 + 2 + 4 + 84;
    private String version_ID = "SLOG 2.0.6";
    private short num_children_per_node = (short)2;
    private int treeleaf_bytesize = 65536;
    private short max_treedepth = 0;
    private int max_buffer_bytesize = 0;
    public FileBlockPtr blockptr2categories = new FileBlockPtr();
    public FileBlockPtr blockptr2methoddefs = new FileBlockPtr();
    public FileBlockPtr blockptr2lineIDmaps = new FileBlockPtr();
    public FileBlockPtr blockptr2treeroot = new FileBlockPtr();
    public FileBlockPtr blockptr2treedir = new FileBlockPtr();
    public FileBlockPtr blockptr2annotations = new FileBlockPtr();
    public FileBlockPtr blockptr2postamble = new FileBlockPtr();

    public Header() {
    }

    public void writeObject(MixedDataOutput outs) throws IOException {
        outs.writeString(this.version_ID);
        outs.writeShort(this.num_children_per_node);
        outs.writeInt(this.treeleaf_bytesize);
        outs.writeShort(this.max_treedepth);
        outs.writeInt(this.max_buffer_bytesize);
        this.blockptr2categories.writeObject(outs);
        this.blockptr2methoddefs.writeObject(outs);
        this.blockptr2lineIDmaps.writeObject(outs);
        this.blockptr2treeroot.writeObject(outs);
        this.blockptr2treedir.writeObject(outs);
        this.blockptr2annotations.writeObject(outs);
        this.blockptr2postamble.writeObject(outs);
    }

    public Header(MixedDataInput ins) throws IOException {
        this();
        this.readObject(ins);
    }

    public void readObject(MixedDataInput ins) throws IOException {
        short max_str_length = (short)"SLOG 2.0.6".length();
        this.version_ID = ins.readStringWithLimit(max_str_length);
        this.num_children_per_node = ins.readShort();
        this.treeleaf_bytesize = ins.readInt();
        this.max_treedepth = ins.readShort();
        this.max_buffer_bytesize = ins.readInt();
        this.blockptr2categories.readObject(ins);
        this.blockptr2methoddefs.readObject(ins);
        this.blockptr2lineIDmaps.readObject(ins);
        this.blockptr2treeroot.readObject(ins);
        this.blockptr2treedir.readObject(ins);
        this.blockptr2annotations.readObject(ins);
        this.blockptr2postamble.readObject(ins);
    }

    public boolean isSLOG2() {
        return this.version_ID != null && this.version_ID.startsWith("SLOG 2");
    }

    public String getCompatibleVersionMessage() {
        if (this.version_ID != null && this.version_ID.compareTo("SLOG 2.0.6") == 0) {
            return null;
        }
        return "Incompatible Version IDs detected! \nThe logfile's version ID is " + this.version_ID + ",\n" + "but this input program reads logfile of version " + "SLOG 2.0.6" + ".\n";
    }

    public void setTreeLeafByteSize(int in_bytesize) {
        this.treeleaf_bytesize = in_bytesize;
    }

    public int getTreeLeafByteSize() {
        return this.treeleaf_bytesize;
    }

    public void setNumChildrenPerNode(short num_leafs) {
        this.num_children_per_node = num_leafs;
    }

    public short getNumChildrenPerNode() {
        return this.num_children_per_node;
    }

    public void setMaxTreeDepth(short in_depth) {
        this.max_treedepth = in_depth;
    }

    public short getMaxTreeDepth() {
        return this.max_treedepth;
    }

    public void setMaxBufferByteSize(int bufsize) {
        this.max_buffer_bytesize = bufsize;
    }

    public int getMaxBufferByteSize() {
        return this.max_buffer_bytesize;
    }

    public String toString() {
        StringBuffer rep = new StringBuffer("\t SLOG-2 Header:\n");
        rep.append("version = " + this.version_ID + "\n");
        rep.append("NumOfChildrenPerNode = " + this.num_children_per_node + "\n");
        rep.append("TreeLeafByteSize = " + this.treeleaf_bytesize + "\n");
        rep.append("MaxTreeDepth = " + this.max_treedepth + "\n");
        rep.append("MaxBufferByteSize = " + this.max_buffer_bytesize + "\n");
        rep.append("Categories  is " + this.blockptr2categories + "\n");
        rep.append("MethodDefs  is " + this.blockptr2methoddefs + "\n");
        rep.append("LineIDMaps  is " + this.blockptr2lineIDmaps + "\n");
        rep.append("TreeRoot    is " + this.blockptr2treeroot + "\n");
        rep.append("TreeDir     is " + this.blockptr2treedir + "\n");
        rep.append("Annotations is " + this.blockptr2annotations + "\n");
        rep.append("Postamble   is " + this.blockptr2postamble + "\n");
        return rep.toString();
    }
}

