/*
 * Decompiled with CFR 0.152.
 */
package viewer.histogram;

import base.drawable.TimeBoundingBox;
import base.statistics.BufForTimeAveBoxes;
import base.statistics.Summarizable;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.Date;
import java.util.Map;
import javax.swing.BoundedRangeModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import viewer.common.CustomCursor;
import viewer.common.Dialogs;
import viewer.common.Parameters;
import viewer.common.Routines;
import viewer.histogram.InfoDialogForSummary;
import viewer.zoomable.CoordPixelImage;
import viewer.zoomable.Debug;
import viewer.zoomable.InfoDialog;
import viewer.zoomable.ModelTime;
import viewer.zoomable.Profile;
import viewer.zoomable.ScrollableObject;
import viewer.zoomable.YaxisMaps;
import viewer.zoomable.YaxisTree;

public class CanvasStatline
extends ScrollableObject {
    private static final long serialVersionUID = 12400L;
    private BufForTimeAveBoxes buf4statboxes;
    private YaxisMaps y_maps;
    private YaxisTree tree_view;
    private BoundedRangeModel y_model;
    private String[] y_colnames;
    private Dialog root_dialog;
    private TimeBoundingBox timeframe4imgs;
    private ChangeListener change_listener;
    private ChangeEvent change_event;
    private int num_rows;
    private int row_height;
    private Map map_line2row;
    private Date zero_time;
    private Date init_time;
    private Date final_time;

    public CanvasStatline(ModelTime time_model, BufForTimeAveBoxes statboxes, BoundedRangeModel yaxis_model, YaxisMaps yaxis_maps, String[] yaxis_colnames) {
        super(time_model);
        this.buf4statboxes = statboxes;
        this.y_maps = yaxis_maps;
        this.tree_view = this.y_maps.getTreeView();
        this.y_model = yaxis_model;
        this.y_colnames = yaxis_colnames;
        this.map_line2row = null;
        this.timeframe4imgs = null;
        this.root_dialog = null;
        this.change_event = null;
        this.change_listener = null;
    }

    public void addChangeListener(ChangeListener listener) {
        this.change_event = new ChangeEvent(this);
        this.change_listener = listener;
    }

    public Dimension getMinimumSize() {
        int min_view_height = 0;
        if (Debug.isActive()) {
            Debug.println("CanvasStatline: min_size = (0," + min_view_height + ")");
        }
        return new Dimension(0, min_view_height);
    }

    public Dimension getMaximumSize() {
        if (Debug.isActive()) {
            Debug.println("CanvasStatline: max_size = (32767,32767)");
        }
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public int getJComponentHeight() {
        int rows_size = this.tree_view.getRowCount() * this.tree_view.getRowHeight();
        int view_size = this.y_model.getMaximum() - this.y_model.getMinimum() + 1;
        if (view_size > rows_size) {
            return view_size;
        }
        return rows_size;
    }

    private void fireChangeEvent() {
        if (this.change_event != null) {
            this.change_listener.stateChanged(this.change_event);
        }
    }

    protected void initializeAllOffImages(TimeBoundingBox imgs_times) {
        if (Profile.isActive()) {
            this.zero_time = new Date();
        }
        if (this.root_dialog == null) {
            this.root_dialog = (Dialog)SwingUtilities.windowForComponent(this);
        }
        if (this.timeframe4imgs == null) {
            this.timeframe4imgs = new TimeBoundingBox(imgs_times);
        }
        Routines.setComponentAndChildrenCursors(this.root_dialog, CustomCursor.Wait);
        this.num_rows = this.tree_view.getRowCount();
        this.row_height = this.tree_view.getRowHeight();
        if (Profile.isActive()) {
            this.init_time = new Date();
        }
        this.map_line2row = this.y_maps.getMapOfLineIDToRowID();
        if (this.map_line2row == null) {
            if (!this.y_maps.update()) {
                Dialogs.error(this.root_dialog, "Error in updating YaxisMaps!");
            }
            this.map_line2row = this.y_maps.getMapOfLineIDToRowID();
        }
    }

    protected void finalizeAllOffImages(TimeBoundingBox imgs_times) {
        this.map_line2row = null;
        this.timeframe4imgs.setEarliestTime(imgs_times.getEarliestTime());
        this.timeframe4imgs.setLatestTime(imgs_times.getLatestTime());
        this.fireChangeEvent();
        Routines.setComponentAndChildrenCursors(this.root_dialog, CustomCursor.Normal);
        if (Profile.isActive()) {
            this.final_time = new Date();
        }
        if (Profile.isActive()) {
            Profile.println("CanvasStatline.finalizeAllOffImages(): init. time = " + (this.init_time.getTime() - this.zero_time.getTime()) + " msec.,   total time = " + (this.final_time.getTime() - this.zero_time.getTime()) + " msec.");
        }
    }

    protected void drawOneOffImage(Image offImage, TimeBoundingBox timebounds) {
        if (Debug.isActive()) {
            Debug.println("CanvasStatline: drawOneOffImage()'s offImage = " + offImage);
        }
        if (offImage != null) {
            int offImage_width = offImage.getWidth(this);
            int offImage_height = offImage.getHeight(this);
            Graphics2D offGraphics = (Graphics2D)offImage.getGraphics();
            offGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            Color back_color = (Color)Parameters.BACKGROUND_COLOR.toValue();
            offGraphics.setPaint(back_color);
            offGraphics.fillRect(0, 0, offImage_width, offImage_height);
            CoordPixelImage coord_xform = new CoordPixelImage(this, this.row_height, timebounds);
            offGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            offGraphics.setColor(Color.cyan);
            for (int irow = 0; irow < this.num_rows; ++irow) {
                if (this.tree_view.isExpanded(irow)) continue;
                int i_Y = coord_xform.convertRowToPixel(irow);
                offGraphics.drawLine(0, i_Y, offImage_width - 1, i_Y);
            }
            if (Debug.isActive() || Profile.isActive()) {
                offGraphics.setColor(Color.gray);
                offGraphics.drawLine(0, 0, 0, this.getHeight());
            }
            this.buf4statboxes.initializeDrawing(this.map_line2row, back_color, Parameters.HISTOGRAM_ZERO_ORIGIN, Parameters.STATE_HEIGHT_FACTOR, Parameters.NESTING_HEIGHT_FACTOR);
            int N_nestable = 0;
            int N_nestless = 0;
            N_nestable = this.buf4statboxes.drawAllStates(offGraphics, coord_xform);
            offGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, Parameters.ARROW_ANTIALIASING.toValue());
            N_nestless = this.buf4statboxes.drawAllArrows(offGraphics, coord_xform);
            if (Profile.isActive()) {
                Profile.println("CanvasStatline.drawOneOffImage(): N_NestAble = " + N_nestable + ",  " + "R_NestLess = " + N_nestless);
            }
            offGraphics.dispose();
        }
    }

    public InfoDialog getPropertyAt(Point local_click, TimeBoundingBox vport_timeframe) {
        CoordPixelImage coord_xform = new CoordPixelImage(this, this.row_height, super.getTimeBoundsOfImages());
        double clicked_time = coord_xform.convertPixelToTime(local_click.x);
        Summarizable clicked_summary = this.buf4statboxes.getSummarizableAt(coord_xform, local_click);
        if (clicked_summary != null) {
            return new InfoDialogForSummary(this.root_dialog, clicked_time, this.tree_view, this.y_colnames, clicked_summary);
        }
        return super.getTimePropertyAt(local_click);
    }
}

