/*
 * Decompiled with CFR 0.152.
 */
package viewer.timelines;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import logformat.slog2.input.InputLog;
import viewer.common.Dialogs;
import viewer.common.Parameters;
import viewer.common.TopWindow;
import viewer.timelines.TimelinePanel;

public class TimelineFrame
extends JFrame {
    private static final long serialVersionUID = 13700L;
    private static String in_filename;
    private static int in_view_ID;
    private TimelinePanel top_panel;
    private static String help_msg;

    public TimelineFrame(InputLog slog_ins, int view_ID) {
        super("TimeLine : " + slog_ins.getPathnameSuffix() + "  <" + slog_ins.getLineIDMapName(view_ID) + ">");
        super.setDefaultCloseOperation(0);
        TopWindow.Timeline.disposeAll();
        TopWindow.Timeline.setWindow(this);
        this.top_panel = new TimelinePanel(this, slog_ins, view_ID);
        this.setContentPane(this.top_panel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TopWindow.Timeline.disposeAll();
            }
        });
    }

    public void setVisible(boolean val) {
        super.setVisible(val);
        TopWindow.Control.setShowTimelineButtonEnabled(!val);
    }

    public void init() {
        this.top_panel.init();
    }

    public static void checkVersion() {
        String vers = System.getProperty("java.version");
        System.out.println("Java is version " + vers + ".");
        if (vers.compareTo("1.2.0") < 0) {
            System.err.println("WARNING: Java is version " + vers + ". \n" + "\t It is too old to run this viewer.");
        }
    }

    public static void main(String[] args) {
        String err_msg;
        TimelineFrame.checkVersion();
        TimelineFrame.parseCmdLineArgs(args);
        System.out.print("Reading the SLOG-2 file ...... ");
        InputLog in_slog_ins = new InputLog(in_filename);
        if (in_slog_ins == null) {
            Dialogs.error(TopWindow.First.getWindow(), "Null InputLog!");
            System.exit(1);
        }
        if (!in_slog_ins.isSLOG2()) {
            Dialogs.error(TopWindow.First.getWindow(), in_filename + " is NOT a SLOG-2 file!");
            in_slog_ins = null;
            System.exit(1);
        }
        if ((err_msg = in_slog_ins.getCompatibleHeader()) != null && !Dialogs.confirm(TopWindow.First.getWindow(), err_msg + "Check the following version history " + "for compatibility.\n\n" + "- Version SLOG 2.0.0's node employs\n  decreasing endtime ordering.\n- Version SLOG 2.0.1's node employs\n  increasing starttime ordering.\n- Version SLOG 2.0.2 added preview data\n  in legend order to shadow states.\n- Version SLOG 2.0.3 changed preview data\n  from legend to inclusive ratio order.\n- Version SLOG 2.0.4 removed unused\n  category objects.\n- Version SLOG 2.0.5 expanded preview data\n  to include inclusive & exclusive ratios.\n- Version SLOG 2.0.6 expanded preview data\n  to include the count of real drawables.\n  \n- 2.0.1 viewer draws 2.0.0 logfile's\n  state nesting stack incorrectly!\n- 2.0.2 viewer cannot read 2.0.1 logfile.\n- 2.0.3 viewer draws 2.0.2 logfile's\n  preview weight incorrectly.\n- 2.0.4 viewer supports JOIN method and\n  can display 2.0.3 logfile correctly.\n- 2.0.5 viewer cannot read 2.0.4 logfile.\n- 2.0.6 viewer cannot read 2.0.5 logfile.\n" + "\n" + "Do you still want to continue reading " + "the logfile ?")) {
            in_slog_ins = null;
            System.exit(1);
        }
        in_slog_ins.initialize();
        System.out.println("Done.");
        Parameters.initSetupFile();
        Parameters.readFromSetupFile(null);
        Parameters.initStaticClasses();
        System.out.println("Starting the SLOG-2 Display Program ..... ");
        TimelineFrame frame = new TimelineFrame(in_slog_ins, in_view_ID);
        frame.pack();
        frame.setVisible(true);
        frame.init();
    }

    private static void parseCmdLineArgs(String[] argv) {
        StringBuffer err_msg = new StringBuffer();
        int idx = 0;
        try {
            while (idx < argv.length) {
                if (argv[idx].startsWith("-")) {
                    if (argv[idx].equals("-h") || argv[idx].equals("-help") || argv[idx].equals("--help")) {
                        System.out.println(help_msg);
                        System.out.flush();
                        System.exit(0);
                        continue;
                    }
                    if (argv[idx].equals("-v")) {
                        String arg_str = argv[++idx];
                        in_view_ID = Integer.parseInt(arg_str);
                        err_msg.append("\n view_ID = " + arg_str);
                        ++idx;
                        continue;
                    }
                    System.err.println("Unrecognized option, " + argv[idx] + ", at " + TimelineFrame.indexOrderStr(idx + 1) + " command line argument");
                    System.out.flush();
                    System.exit(1);
                    continue;
                }
                in_filename = argv[idx];
                ++idx;
            }
        }
        catch (NumberFormatException numerr) {
            if (err_msg.length() > 0) {
                System.err.println(err_msg.toString());
            }
            System.err.println("Error occurs after option " + argv[idx - 1] + ", " + TimelineFrame.indexOrderStr(idx) + " command line argument.  It needs a number.");
            numerr.printStackTrace();
        }
        if (in_filename == null) {
            System.err.println("The Program needs a SLOG-2 filename as a command line argument.");
            System.err.println(help_msg);
            System.exit(1);
        }
    }

    private static String indexOrderStr(int idx) {
        switch (idx) {
            case 1: {
                return Integer.toString(idx) + "st";
            }
            case 2: {
                return Integer.toString(idx) + "nd";
            }
            case 3: {
                return Integer.toString(idx) + "rd";
            }
        }
        return Integer.toString(idx) + "th";
    }

    static {
        in_view_ID = 0;
        help_msg = "Usage: java viewer.timelines.TimelineFrame [options] slog2_filename.\nOptions: \n\t [-h|-help|--help]                 \t Display this message.\n\t [-v view_ID ]                     \t Default value is 0.\n";
    }
}

