/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import viewer.common.Dialogs;
import viewer.zoomable.Debug;
import viewer.zoomable.ToolBarStatus;
import viewer.zoomable.YaxisTree;

public class ActionTimelineMark
implements ActionListener {
    private Window root_window;
    private ToolBarStatus toolbar;
    private YaxisTree tree;

    public ActionTimelineMark(Window parent_window, ToolBarStatus in_toolbar, YaxisTree in_tree) {
        this.root_window = parent_window;
        this.toolbar = in_toolbar;
        this.tree = in_tree;
    }

    public void actionPerformed(ActionEvent event) {
        if (Debug.isActive()) {
            Debug.println("Action for Mark Timeline button");
        }
        if (this.tree.getSelectionCount() < 1) {
            Dialogs.error(this.root_window, "At least ONE tree node needs to be marked!");
            return;
        }
        TreePath[] selected_paths = this.tree.getSelectionPaths();
        for (int idx = 0; idx < selected_paths.length; ++idx) {
            MutableTreeNode node = (MutableTreeNode)selected_paths[idx].getLastPathComponent();
            if (!Debug.isActive()) continue;
            if (this.tree.isExpanded(selected_paths[idx])) {
                Debug.println("\tselected an expanded node " + node);
                continue;
            }
            Debug.println("\tselected a collapsed node " + node);
        }
        this.tree.renewCutAndPasteBuffer();
        if (!this.tree.isCutAndPasteBufferUniformlyLeveled(selected_paths)) {
            Dialogs.error(this.root_window, "The tree nodes are NOT selected from the same level!  Select again.");
            return;
        }
        this.tree.addToCutAndPasteBuffer(selected_paths);
        this.toolbar.getTimelineMarkButton().setEnabled(true);
        this.toolbar.getTimelineMoveButton().setEnabled(true);
        this.toolbar.getTimelineDeleteButton().setEnabled(true);
    }
}

