/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import viewer.common.Dialogs;
import viewer.zoomable.Debug;
import viewer.zoomable.ModelTime;
import viewer.zoomable.ToolBarStatus;

public class ActionZoomIn
implements ActionListener {
    private ToolBarStatus toolbar;
    private ModelTime model;
    private int zoomlevel;

    public ActionZoomIn(ToolBarStatus in_toolbar, ModelTime in_model) {
        this.toolbar = in_toolbar;
        this.model = in_model;
        this.zoomlevel = 0;
    }

    public void actionPerformed(ActionEvent event) {
        this.zoomlevel = this.model.getZoomLevel();
        if (this.zoomlevel >= 30) {
            Window window = SwingUtilities.windowForComponent((JToolBar)((Object)this.toolbar));
            String msg = "The Current ZoomLevel(" + this.zoomlevel + ") exceeds " + "the Maximum ZoomLevel(" + 30 + ")!";
            Dialogs.error(window, msg);
        } else {
            this.model.zoomIn();
        }
        if (this.toolbar != null) {
            this.toolbar.resetZoomButtons();
        }
        if (Debug.isActive()) {
            Debug.println("Action for Zoom In button. ZoomLevel = " + this.zoomlevel);
        }
    }
}

