/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.awt.Dimension;
import javax.swing.JScrollBar;
import viewer.zoomable.ModelTime;

public class ScrollbarTime
extends JScrollBar {
    private static final long serialVersionUID = 4200L;
    private ModelTime model;
    private Dimension min_size;

    public ScrollbarTime(ModelTime model) {
        super(0);
        this.model = model;
        this.setModel(model);
        this.addAdjustmentListener(model);
        super.setUnitIncrement(10);
        this.min_size = super.getMinimumSize();
        if (this.min_size.height <= 0) {
            this.min_size.height = 20;
        }
    }

    public void setBlockIncrementToModelExtent() {
        int model_extent;
        if (this.model != null && (model_extent = this.model.getExtent()) > 1) {
            super.setBlockIncrement(model_extent);
        }
    }

    public Dimension getMinimumSize() {
        return this.min_size;
    }

    public void init() {
    }
}

