/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.text.ChoiceFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class TimeFormat {
    private static final double[] LIMITS = new double[]{Double.NEGATIVE_INFINITY, 0.0, 1.0E-10, 1.0E-7, 1.0E-4, 0.1};
    private static final String[] UNITS = new String[]{"-ve", "ps", "ns", "us", "ms", "s"};
    private static final String PATTERN = "#,##0.00###";
    private DecimalFormat decfmt = (DecimalFormat)NumberFormat.getInstance();
    private ChoiceFormat unitfmt = null;

    public TimeFormat() {
        this.decfmt.applyPattern(PATTERN);
        this.unitfmt = new ChoiceFormat(LIMITS, UNITS);
    }

    public String format(double time) {
        String unit = this.unitfmt.format(Math.abs(time));
        if (unit.equals("s")) {
            return this.decfmt.format(time) + " sec";
        }
        if (unit.equals("ms")) {
            return this.decfmt.format(time * 1000.0) + " msec";
        }
        if (unit.equals("us")) {
            return this.decfmt.format(time * 1000000.0) + " usec";
        }
        if (unit.equals("ns")) {
            return this.decfmt.format(time * 1.0E9) + " nsec";
        }
        if (unit.equals("ps")) {
            return this.decfmt.format(time * 1.0E12) + " psec";
        }
        return this.decfmt.format(time) + " sec";
    }
}

