/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import base.drawable.ColorAlpha;
import base.drawable.Drawable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.SwingUtilities;
import viewer.common.Dialogs;
import viewer.common.Parameters;
import viewer.common.Routines;
import viewer.zoomable.Debug;
import viewer.zoomable.InfoDialog;
import viewer.zoomable.ModelTime;
import viewer.zoomable.SearchDialog;
import viewer.zoomable.SearchPanel;
import viewer.zoomable.SearchableView;
import viewer.zoomable.ViewportTime;
import viewer.zoomable.YaxisTree;

public class ViewportTimeYaxis
extends ViewportTime
implements AdjustmentListener {
    private static final long serialVersionUID = 4300L;
    private static final Color SEARCH_LINE_COLOR = Color.yellow;
    private static final int SEARCH_ARROW_HALF_ANGLE = 15;
    private static final double SEARCH_ARROW_ANGLE = 0.5235987755982988;
    private static final double COS_SEARCH_ARROW_ANGLE = Math.cos(0.5235987755982988);
    private static final double SIN_SEARCH_ARROW_ANGLE = Math.sin(0.5235987755982988);
    private ModelTime time_model = null;
    private BoundedRangeModel y_model = null;
    private YaxisTree tree_view = null;
    private Point view_pt = null;
    private ComponentEvent resize_evt = null;
    private SearchableView searchable = null;
    private SearchDialog search_dialog = null;
    private Drawable searched_dobj = null;
    private double searching_time;
    private static final double INVALID_TIME = Double.NEGATIVE_INFINITY;
    private double searched_time = Double.NEGATIVE_INFINITY;
    private int mouse_last_Yloc;
    private double ratio_ymodel2vportH;

    public ViewportTimeYaxis(ModelTime time_axis_model, BoundedRangeModel yaxis_model, YaxisTree y_tree) {
        super(time_axis_model);
        this.time_model = time_axis_model;
        this.y_model = yaxis_model;
        this.tree_view = y_tree;
        this.view_pt = new Point(0, 0);
        this.resize_evt = new ComponentEvent(this, 101);
        this.searching_time = this.time_model.getTimeGlobalMinimum();
    }

    public void setView(Component view) {
        super.setView(view);
        this.searchable = view instanceof SearchableView ? (SearchableView)((Object)view) : null;
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        if (Debug.isActive()) {
            Debug.println("ViewportTimeYaxis: adjChanged()'s START: ");
            Debug.println("adj_evt = " + evt);
        }
        this.view_pt.x = super.getXaxisViewPosition();
        this.view_pt.y = evt.getValue();
        super.setYaxisViewPosition(this.view_pt.y);
        super.setViewPosition(this.view_pt);
        super.repaint();
        if (Debug.isActive()) {
            Debug.println("ViewportTimeYaxis: adjChanged()'s END: ");
        }
    }

    public void fireComponentResized() {
        super.componentResized(this.resize_evt);
    }

    private Rectangle localRectangleForDrawable(Drawable dobj) {
        Rectangle dobj_rect = this.searchable.localRectangleForDrawable(dobj);
        Point local_click = SwingUtilities.convertPoint((Component)((Object)this.searchable), dobj_rect.x, dobj_rect.y, this);
        dobj_rect.setLocation(local_click);
        return dobj_rect;
    }

    private void drawMarkerForSearchedDrawable(Graphics g) {
        int y2;
        int x2;
        int y1;
        int x1;
        int frame_thickness;
        int vport_width = this.getWidth();
        int vport_height = this.getHeight();
        Rectangle dobj_rect = this.localRectangleForDrawable(this.searched_dobj);
        if (dobj_rect.x >= 0 && dobj_rect.x < vport_width) {
            ColorAlpha dobj_color = this.searched_dobj.getCategory().getColor();
            Color dobj_brighter_color = dobj_color.brighter();
            Color dobj_darker_color = dobj_color.darker();
            frame_thickness = Parameters.SEARCH_FRAME_THICKNESS;
            int radius = Parameters.SEARCH_ARROW_LENGTH;
            int diameter = 2 * radius;
            int arrow_Xoff = (int)((double)radius * SIN_SEARCH_ARROW_ANGLE + 0.5);
            int arrow_Yoff = (int)((double)radius * COS_SEARCH_ARROW_ANGLE + 0.5);
            x1 = dobj_rect.x;
            y1 = dobj_rect.y - frame_thickness;
            g.setColor(dobj_color);
            g.fillArc(x1 - radius, y1 - radius, diameter, diameter, 90, -15);
            g.setColor(dobj_darker_color);
            g.fillArc(x1 - radius, y1 - radius, diameter, diameter, 75, -15);
            g.setColor(dobj_brighter_color);
            g.drawLine(x1, y1, x1, y1 - radius);
            g.setColor(dobj_brighter_color);
            g.drawLine(x1, y1, x1 + arrow_Xoff, y1 - arrow_Yoff);
            x2 = x1;
            y2 = dobj_rect.y + dobj_rect.height + frame_thickness;
            g.setColor(Color.yellow);
            g.fillArc(x2 - radius, y2 - radius, diameter, diameter, 270, 15);
            g.setColor(Color.darkGray);
            g.fillArc(x2 - radius, y2 - radius, diameter, diameter, 285, 15);
            g.setColor(Color.gray);
            g.drawLine(x2, y2, x2, y2 + radius);
            g.setColor(Color.white);
            g.drawLine(x2, y2, x2 + arrow_Xoff, y2 + arrow_Yoff);
        }
        dobj_rect = SwingUtilities.computeIntersection(0, 0, vport_width, vport_height, dobj_rect);
        if (dobj_rect.x >= 0) {
            if (Parameters.SEARCHED_OBJECT_ON_TOP) {
                g.setColor(this.searched_dobj.getCategory().getColor());
                g.fillRect(dobj_rect.x, dobj_rect.y, dobj_rect.width, dobj_rect.height);
            }
            frame_thickness = Parameters.SEARCH_FRAME_THICKNESS;
            x1 = dobj_rect.x;
            y1 = dobj_rect.y;
            x2 = x1 + dobj_rect.width;
            y2 = y1 + dobj_rect.height;
            g.setColor(Color.black);
            int ii = 0;
            g.drawLine(x1 - ii, y1 - ii, x1 - ii, y2 + ii);
            g.drawLine(x1 - ii, y1 - ii, x2 + ii, y1 - ii);
            g.setColor(Color.white);
            for (ii = 1; ii <= frame_thickness; ++ii) {
                g.drawLine(x1 - ii, y1 - ii, x1 - ii, y2 + ii);
                g.drawLine(x1 - ii, y1 - ii, x2 + ii, y1 - ii);
            }
            g.setColor(Color.white);
            ii = 0;
            g.drawLine(x2 + ii, y1 - ii, x2 + ii, y2 + ii);
            g.drawLine(x1 - ii, y2 + ii, x2 + ii, y2 + ii);
            g.setColor(Color.darkGray);
            for (ii = 1; ii <= frame_thickness; ++ii) {
                g.drawLine(x2 + ii, y1 - ii, x2 + ii, y2 + ii);
                g.drawLine(x1 - ii, y2 + ii, x2 + ii, y2 + ii);
            }
        }
    }

    public void paint(Graphics g) {
        if (Debug.isActive()) {
            Debug.println("ViewportTimeYaxis: paint()'s START: ");
        }
        super.paint(g);
        if (this.coord_xform.contains(this.searching_time)) {
            int x_pos = this.coord_xform.convertTimeToPixel(this.searching_time);
            g.setColor(SEARCH_LINE_COLOR);
            g.drawLine(x_pos, 0, x_pos, this.getHeight());
        }
        if (this.searched_dobj != null) {
            this.drawMarkerForSearchedDrawable(g);
        }
        if (Debug.isActive()) {
            Debug.println("ViewportTimeYaxis: paint()'s END: ");
        }
    }

    public void eraseSearchedDrawable() {
        this.searched_dobj = null;
    }

    public boolean searchBackward() {
        SearchPanel dobj_panel = null;
        if (this.search_dialog == null) {
            Window window = SwingUtilities.windowForComponent(this);
            if (window instanceof Frame) {
                this.search_dialog = new SearchDialog((Frame)window, this);
            } else {
                Dialogs.error(window, "ViewportTimeYaxis.searchBackward() is meant to be invoked from a top JFrame.");
            }
        }
        if ((dobj_panel = this.searching_time != this.searched_time ? this.searchable.searchPreviousComponent(this.searching_time) : this.searchable.searchPreviousComponent()) != null) {
            this.searched_dobj = dobj_panel.getSearchedDrawable();
            this.searched_time = this.searched_dobj.getEarliestTime();
            this.time_model.scroll(this.searched_time - this.searching_time);
            this.searching_time = this.searched_time;
            this.tree_view.scrollRowToVisible(this.searched_dobj.getRowID());
            this.repaint();
            this.search_dialog.replace(dobj_panel);
            if (!this.search_dialog.isVisible()) {
                this.search_dialog.setVisibleAtDefaultLocation();
            }
            return true;
        }
        if (this.searched_dobj != null && this.searched_dobj.getEarliestTime() == this.time_model.getTimeGlobalMinimum()) {
            Dialogs.info(SwingUtilities.windowForComponent(this), "The FIRST drawable in the logfile has been reached.\n  Search backward has no more drawable to return.\n", null);
        } else {
            Dialogs.warn(SwingUtilities.windowForComponent(this), "If the logfile's beginning is not within view,\nSCROLL BACKWARD till you see more drawables\nare within view.  All drawables in view or in \nthe memory have been searched.\n");
        }
        this.search_dialog.setVisible(false);
        this.searched_dobj = null;
        this.searched_time = Double.NEGATIVE_INFINITY;
        this.repaint();
        return false;
    }

    public boolean searchForward() {
        SearchPanel dobj_panel = null;
        if (this.search_dialog == null) {
            Window window = SwingUtilities.windowForComponent(this);
            if (window instanceof Frame) {
                this.search_dialog = new SearchDialog((Frame)window, this);
            } else {
                Dialogs.error(window, "ViewportTimeYaxis.searchForward() is meant to be invoked from a top JFrame.");
            }
        }
        if ((dobj_panel = this.searching_time != this.searched_time ? this.searchable.searchNextComponent(this.searching_time) : this.searchable.searchNextComponent()) != null) {
            this.searched_dobj = dobj_panel.getSearchedDrawable();
            this.searched_time = this.searched_dobj.getEarliestTime();
            this.time_model.scroll(this.searched_time - this.searching_time);
            this.searching_time = this.searched_time;
            this.tree_view.scrollRowToVisible(this.searched_dobj.getRowID());
            this.repaint();
            this.search_dialog.replace(dobj_panel);
            if (!this.search_dialog.isVisible()) {
                this.search_dialog.setVisibleAtDefaultLocation();
            }
            return true;
        }
        if (this.searched_dobj != null && this.searched_dobj.getLatestTime() == this.time_model.getTimeGlobalMaximum()) {
            Dialogs.info(SwingUtilities.windowForComponent(this), "The LAST drawable in the logfile has been reached.\n  Search forward has no more drawable to return.\n", null);
        } else {
            Dialogs.warn(SwingUtilities.windowForComponent(this), "If the end of the logfile is not within view,\nSCROLL FORWARD till you see more drawables\nare within view.  All drawables in view or in \nthe memory have been searched.\n");
        }
        this.search_dialog.setVisible(false);
        this.searched_dobj = null;
        this.searched_time = Double.NEGATIVE_INFINITY;
        this.repaint();
        return false;
    }

    public boolean searchInit() {
        InfoDialog info_popup = super.getLastInfoDialog();
        if (info_popup != null) {
            this.searching_time = info_popup.getClickedTime();
            info_popup.getCloseButton().doClick();
            this.repaint();
            return true;
        }
        Dialogs.warn(SwingUtilities.windowForComponent(this), "No info dialog box! Info dialog box can be set\nby right mouse clicking on the timeline canvas\n");
        return false;
    }

    public void mouseClicked(MouseEvent mouse_evt) {
        super.mouseClicked(mouse_evt);
        if (Routines.isLeftMouseButton(mouse_evt) && !this.isLeftMouseClick4Zoom) {
            Point vport_click = mouse_evt.getPoint();
            this.searching_time = this.coord_xform.convertPixelToTime(vport_click.x);
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouse_evt) {
        super.mousePressed(mouse_evt);
        if (Routines.isLeftMouseButton(mouse_evt) && !this.isLeftMouseClick4Zoom) {
            Point vport_click = mouse_evt.getPoint();
            this.mouse_last_Yloc = vport_click.y;
            this.ratio_ymodel2vportH = (double)this.y_model.getExtent() / (double)this.getHeight();
        }
    }

    public void mouseDragged(MouseEvent mouse_evt) {
        super.mouseDragged(mouse_evt);
        if (Routines.isLeftMouseButton(mouse_evt) && !this.isLeftMouseClick4Zoom) {
            Point vport_click = mouse_evt.getPoint();
            int y_change = this.mouse_last_Yloc - vport_click.y;
            int sb_change = (int)Math.round(this.ratio_ymodel2vportH * (double)y_change);
            this.y_model.setValue(this.y_model.getValue() + sb_change);
            this.mouse_last_Yloc = vport_click.y;
        }
    }

    public void mouseReleased(MouseEvent mouse_evt) {
        super.mouseReleased(mouse_evt);
        if (Routines.isLeftMouseButton(mouse_evt) && !this.isLeftMouseClick4Zoom) {
            Point vport_click = mouse_evt.getPoint();
            int y_change = this.mouse_last_Yloc - vport_click.y;
            int sb_change = (int)Math.round(this.ratio_ymodel2vportH * (double)y_change);
            this.y_model.setValue(this.y_model.getValue() + sb_change);
            this.mouse_last_Yloc = vport_click.y;
        }
    }
}

