/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import logformat.slog2.LineIDMap;
import viewer.common.Parameters;
import viewer.zoomable.IntegerArrayComparator;
import viewer.zoomable.YaxisTree;
import viewer.zoomable.YaxisTreeNode;

public class YaxisMaps {
    private LineIDMap lineIDmap;
    private YaxisTreeNode y_treeroot;
    private YaxisTree tree_view;
    private Map map_line2treeleaf;
    private Map map_treepath2row;
    private Map map_line2row;

    public YaxisMaps(LineIDMap in_linemap) {
        this.lineIDmap = in_linemap;
        this.y_treeroot = null;
        this.tree_view = null;
        this.map_line2treeleaf = null;
        this.map_treepath2row = null;
        this.map_line2row = null;
    }

    public LineIDMap getLineIDMap() {
        return this.lineIDmap;
    }

    public YaxisTreeNode getTreeRoot() {
        if (this.y_treeroot == null) {
            this.y_treeroot = new YaxisTreeNode(Parameters.Y_AXIS_ROOT_LABEL);
            this.convertLineIDMapToTree();
        }
        return this.y_treeroot;
    }

    public void setTreeView(YaxisTree in_tree) {
        this.tree_view = in_tree;
        if (this.map_line2treeleaf == null) {
            this.map_line2treeleaf = new TreeMap();
            this.setMapOfLineIDToTreeLeaf();
        }
    }

    public YaxisTree getTreeView() {
        return this.tree_view;
    }

    public Map getMapOfLineIDToTreeLeaf() {
        return this.map_line2treeleaf;
    }

    public Map getMapOfTreePathToRowID() {
        return this.map_treepath2row;
    }

    public Map getMapOfLineIDToRowID() {
        return this.map_line2row;
    }

    public boolean update() {
        this.updateMapOfTreePathToRowID();
        return this.updateMapOfLineIDToRowID();
    }

    private void convertLineIDMapToTree() {
        TreeSet set_userpath = new TreeSet(new IntegerArrayComparator());
        set_userpath.addAll(this.lineIDmap.values());
        Iterator iarys = set_userpath.iterator();
        while (iarys.hasNext()) {
            YaxisTreeNode parent = this.y_treeroot;
            Integer[] iary = (Integer[])iarys.next();
            for (int idx = 0; idx < iary.length; ++idx) {
                Integer user_obj = iary[idx];
                YaxisTreeNode child = parent.getChild(user_obj);
                if (child == null) {
                    child = new YaxisTreeNode(user_obj);
                    parent.add(child);
                }
                parent = child;
            }
        }
    }

    private boolean setMapOfLineIDToTreeLeaf() {
        boolean isOK = true;
        Iterator entries = this.lineIDmap.entrySet().iterator();
        while (entries.hasNext()) {
            YaxisTreeNode node = this.y_treeroot;
            Map.Entry entry = entries.next();
            Integer[] iary = (Integer[])entry.getValue();
            for (int idx = 0; idx < iary.length; ++idx) {
                Integer user_obj = iary[idx];
                YaxisTreeNode child = node.getChild(user_obj);
                if (child == null) {
                    child = new YaxisTreeNode(user_obj);
                    node.add(child);
                    System.err.println("YaxisMaps.setMapOfLineIDToTreeLeaf(): Unexpected Error!\n\t user object " + user_obj + " is NOT found under the root! ");
                    isOK = false;
                }
                node = child;
            }
            this.map_line2treeleaf.put(entry.getKey(), node);
        }
        return isOK;
    }

    private void updateMapOfTreePathToRowID() {
        if (this.map_treepath2row == null) {
            this.map_treepath2row = new HashMap();
        } else {
            this.map_treepath2row.clear();
        }
        int row_count = this.tree_view.getRowCount();
        for (int idx = 0; idx < row_count; ++idx) {
            TreePath path = this.tree_view.getPathForRow(idx);
            this.map_treepath2row.put(path, new Integer(idx));
        }
    }

    private boolean updateMapOfLineIDToRowID() {
        if (this.map_line2row == null) {
            this.map_line2row = new TreeMap();
        } else {
            this.map_line2row.clear();
        }
        boolean isOK = true;
        Iterator entries = this.map_line2treeleaf.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Integer lineID = (Integer)entry.getKey();
            YaxisTreeNode node = (YaxisTreeNode)entry.getValue();
            Integer rowID = null;
            for (TreePath path = new TreePath(node.getPath()); rowID == null && path != null; path = path.getParentPath()) {
                rowID = (Integer)this.map_treepath2row.get(path);
            }
            if (rowID == null) {
                isOK = false;
            }
            this.map_line2row.put(lineID, rowID);
        }
        return isOK;
    }

    public static String stringFromYaxisRoot(YaxisTreeNode treeroot) {
        StringBuffer rep = new StringBuffer();
        int level = treeroot.getLevel();
        Enumeration<TreeNode> nodes = treeroot.breadthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            YaxisTreeNode node = (YaxisTreeNode)nodes.nextElement();
            if (level != node.getLevel()) {
                level = node.getLevel();
                rep.append("\n");
            }
            rep.append(" " + node);
        }
        return rep.toString();
    }

    public String stringForYaxisTree() {
        return "YaxisTree:\n" + YaxisMaps.stringFromYaxisRoot(this.y_treeroot);
    }

    public static String stringForMap(Map map) {
        StringBuffer rep = new StringBuffer();
        Iterator entries = map.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            rep.append(" [ " + entry.getKey() + " ] => " + entry.getValue() + "\n");
        }
        return rep.toString();
    }

    public String stringForMapOfLineIDToTreeLeaf() {
        StringBuffer rep = new StringBuffer("MapOfLineIDToTreeLeaf:\n");
        Iterator entries = this.map_line2treeleaf.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            rep.append(" [ " + entry.getKey() + " ] => { ");
            TreeNode[] nodes = ((YaxisTreeNode)entry.getValue()).getPath();
            int last_idx = nodes.length - 1;
            for (int idx = 0; idx < last_idx; ++idx) {
                rep.append(nodes[idx] + " ");
            }
            rep.append("(" + nodes[last_idx] + ") }\n");
        }
        return rep.toString();
    }

    public String stringForMapOfTreePathToRowID() {
        return "MapOfTreePathToRowID:\n" + YaxisMaps.stringForMap(this.map_treepath2row);
    }

    public String stringForMapOfLineIDToRowID() {
        return "MapOfLineIDToRowID:\n" + YaxisMaps.stringForMap(this.map_line2row);
    }

    public void printMaps(PrintStream pstm) {
        pstm.println(this.stringForMapOfLineIDToTreeLeaf());
        pstm.println(this.stringForMapOfTreePathToRowID());
        pstm.println(this.stringForMapOfLineIDToRowID());
    }
}

