/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2;

import java.util.Enumeration;

public class Permutation
implements Enumeration {
    private int numLevels;
    private int numChildrenPerNode;
    private long enum_idx;
    private long enum_max;
    private int[] next_enum;

    public Permutation(int Nlevels, int Nchilds) {
        this.numLevels = Nlevels;
        this.numChildrenPerNode = Nchilds;
        this.next_enum = new int[this.numLevels];
        for (int idx = 0; idx < this.numLevels; ++idx) {
            this.next_enum[idx] = 0;
        }
        this.enum_max = (long)Math.pow(Nchilds, Nlevels);
        this.enum_idx = 0L;
    }

    public boolean hasMoreElements() {
        return this.enum_idx < this.enum_max;
    }

    public Object nextElement() {
        int[] curr_enum = (int[])this.next_enum.clone();
        for (int ilevel = 0; ilevel < this.numLevels; ++ilevel) {
            int n = ilevel;
            this.next_enum[n] = this.next_enum[n] + 1;
            if (this.next_enum[ilevel] < this.numChildrenPerNode) break;
            this.next_enum[ilevel] = 0;
        }
        ++this.enum_idx;
        return curr_enum;
    }

    public static final void main(String[] args) {
        int Nlevels = Integer.parseInt(args[0]);
        int Nchilds = Integer.parseInt(args[1]);
        Permutation perms = new Permutation(Nlevels, Nchilds);
        while (perms.hasMoreElements()) {
            int[] icfg = (int[])perms.nextElement();
            for (int idx = 0; idx < icfg.length; ++idx) {
                System.out.print(icfg[idx] + " ");
            }
            System.out.println();
        }
    }
}

