#ifndef BASIC_3D_OUTPUTTER_H_
#define BASIC_3D_OUTPUTTER_H_

#include <string>

#include "OutputterBase.h"
#include "SeriesHandler.h"

namespace jcs {

class BasicVolumeFormat;
struct Basic3DHeader;


// Handles header+raw volume types

class Basic3DOutputter : public OutputterBase {


public :
	Basic3DOutputter(const Options& options);

	virtual ~Basic3DOutputter();

	virtual void UpdateOutputForSeries(SeriesHandler* handler);
	virtual int ConvertSeries(SeriesHandler* handler) = 0;
	virtual void RemoveSeries(const std::string& seriesUid);

	virtual BasicVolumeFormat* GetOutputVolume(const char* file) = 0;
/*	virtual Basic3DHeader* GetHeader(SeriesHandler* handler) = 0; */

// following only used internally or by basic conversion
	wxFileName GetFileNameFromVolId(const VolId& VolId);
//	wxFileName GetFileName(const std::string& series_uid);
	wxString headerExtension;
	wxString rawExtension;

	int GetDimensionality() const {return dim_; }
	int GetDimensionality(const std::string& series_uid) const;

	int GetSkip() const {return skip_; }
	int GetSkip(const std::string& series_uid) const;

	void SetDimensionality(int dim) { dim_ = dim; }
	void SetDimensionality(const std::string& series_uid, int dim);

	void SetSkip(int skip) { skip_ = skip; }
	void SetSkip(const std::string& series_uid, int skip);

	virtual void SetOption(const std::string& name, int value);
	virtual void SetOption(const std::string& name, bool value);

	bool rescale;

protected:
	std::map<VolId, std::string> volKeyMap;
	static Options Get3DOptions();


private:
	int dim_;
	int skip_;

};

template <class T>
class Basic3DConversion {

public:
	Basic3DConversion(Basic3DOutputter* outputter, SeriesHandler* handler);
	virtual void Convert();

protected:
	virtual void GetHeaderForSeries() = 0;
	virtual void CompleteHeaderForVolume(std::pair<VolId, Volume<T> > volPair) { }

	virtual void ProcessSlice(std::vector<T>& slice) {}
	virtual Basic3DHeader* GetHeader() = 0; 

	int GetSkip();
	int GetNumberOfVolumes();

	Basic3DOutputter* mOutputter;
	SeriesHandler* mHandler;

private:
	void WriteMoCoFiles();

};

}

#include "Basic3DOutputter.txx"

#endif
