/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */

#ifndef opengl_CPointCloud_H
#define opengl_CPointCloud_H

#include <mrpt/opengl/CRenderizable.h>
#include <mrpt/utils/CMRPTImage.h>

namespace mrpt
{
	namespace slam { class CPointsMap; }

	namespace opengl
	{
		class MRPTDLLIMPEXP CPointCloud;

		// This must be added to any CSerializable derived class:
		DEFINE_SERIALIZABLE_PRE_CUSTOM_BASE( CPointCloud, CRenderizable )


		/** A cloud of points, all with the same color or each depending on it's "z" coordinate.
		  *  \sa opengl::CPlanarLaserScan, opengl::COpenGLScene, opengl::CPointCloudColoured
		  */
		class MRPTDLLIMPEXP CPointCloud : public CRenderizable
		{
			DEFINE_SERIALIZABLE( CPointCloud )
		public:
			bool			m_colorFromZ;
			vector_float	m_xs,m_ys,m_zs;
			float           m_pointSize; //!< By default is 1.0


			/** Empty the list of points. */
			void clear();

			/** Adds a new point to the cloud */
			void insertPoint( float x,float y, float z );

			/** Class factory  */
			static CPointCloudPtr Create()
			{
				return CPointCloudPtr( new CPointCloud() );
			}

			/** Load the points from a points map
			  */
			void  loadFromPointsMap( const mrpt::slam::CPointsMap *map);

			/** Render
			  */
			void  render();

		private:
			/** Constructor
			  */
			CPointCloud( ) :
				m_colorFromZ(false),
				m_xs(),m_ys(),m_zs(),
				m_pointSize(1),
				m_z_min(0),
				m_z_max(0),
				m_z_minmax_valid(false)
			{
			}
			/** Private, virtual destructor: only can be deleted from smart pointers */
			virtual ~CPointCloud() { }

			float m_z_min, m_z_max; 	//!< Buffer for min/max z coords.
			bool   m_z_minmax_valid;
		};

	} // end namespace

} // End of namespace


#endif
