
#include <mrpt/core.h>

using namespace mrpt;
using namespace mrpt::utils;
using namespace std;

int test_matrix_ops_main(int, char*[]);
int test_icp_main(int, char*[]);
int test_serialize_main(int, char*[]);

int passed;
int failed;

void testname( const char* testname )
{
  cout << "   Testing mrpt_" << testname << " ... ";
  cout.flush();
}

void testresult( int testresult )
{
  if ( testresult==0 ) {
    ++passed;
    cout << "    PASSED" << endl;
  } else {
    ++failed;
    cout << "  **FAILED**" << endl;
  }
}

// The else is for a trailing ; after the macro
#define DO_TEST( Name ) \
  if ( name == "" || name == "test_" #Name ) { \
    testname( #Name ); \
    try { \
    int res = test_##Name##_main(argc,argv); \
    testresult( res ); \
    } catch (exception &e) \
    { \
	testresult( -1 ); \
	std::cout << e.what() << std::endl; \
    } \
    test_run = 1; \
  } else

int main( int argc, char* argv[] )
{
  int test_run = 0;
  passed = failed = 0;
  string name = "";

  if ( argc > 1 ) {
    name = argv[1];
    ++argv;
    --argc;
  }

  // Disable Borland's floating point exceptions.
#if defined(VCL_BORLAND)
  _control87(MCW_EM, MCW_EM);  
#endif // defined(VCL_BORLAND)

  DO_TEST(matrix_ops)
  DO_TEST(icp)
  DO_TEST(serialize)
;

  if (test_run == 0)
  {
    cout << "Unsupported test " << name
             << "; should first be added to test_driver.cpp\n";
    failed = true;
  }

  cout << name << " Test Summary: ";
  if (failed > 0)
    cout<<passed<<" tests succeeded, "<<failed<<" tests failed\t\t\t*****";
  else if (passed > 1)
    cout<<"All "<<passed<<" tests succeeded";
  else
    cout<<"All tests succeeded";
  cout << "\n-----------------------------------------------------------------------------\n";

  return failed;
}

