/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2009  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */

#ifndef CAMERA_CALIB_GUIMAIN_H
#define CAMERA_CALIB_GUIMAIN_H

//(*Headers(camera_calib_guiDialog)
#include <wx/scrolwin.h>
#include <wx/notebook.h>
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/checkbox.h>
#include <wx/listbox.h>
#include <wx/spinctrl.h>
#include <wx/statbmp.h>
#include <wx/button.h>
#include <wx/dialog.h>
//*)

#include <mrpt/gui/CDisplayWindow3D.h>

#define CAMERA_CALIB_GUI_VERSION  "1.0"

class camera_calib_guiDialog: public wxDialog
{
    public:

        camera_calib_guiDialog(wxWindow* parent,wxWindowID id = -1);
        virtual ~camera_calib_guiDialog();

    private:

        //(*Handlers(camera_calib_guiDialog)
        void OnAddImage(wxCommandEvent& event);
        void OnListClear(wxCommandEvent& event);
        void OnbtnRunCalibClick(wxCommandEvent& event);
        void OnbtnCloseClick(wxCommandEvent& event);
        void OnbtnAboutClick(wxCommandEvent& event);
        void OnbtnSaveClick(wxCommandEvent& event);
        void OnlbFilesSelect(wxCommandEvent& event);
        void OnbtnManualRectClick(wxCommandEvent& event);
        //*)

        //(*Identifiers(camera_calib_guiDialog)
        static const long ID_BUTTON1;
        static const long ID_BUTTON2;
        static const long ID_LISTBOX1;
        static const long ID_STATICTEXT1;
        static const long ID_SPINCTRL1;
        static const long ID_STATICTEXT2;
        static const long ID_SPINCTRL2;
        static const long ID_STATICTEXT3;
        static const long ID_TEXTCTRL1;
        static const long ID_STATICTEXT4;
        static const long ID_TEXTCTRL3;
        static const long ID_CHECKBOX1;
        static const long ID_TEXTCTRL2;
        static const long ID_BUTTON3;
        static const long ID_BUTTON6;
        static const long ID_BUTTON7;
        static const long ID_BUTTON5;
        static const long ID_BUTTON4;
        static const long ID_STATICBITMAP2;
        static const long ID_SCROLLEDWINDOW2;
        static const long ID_STATICBITMAP3;
        static const long ID_SCROLLEDWINDOW3;
        static const long ID_NOTEBOOK1;
        //*)

        //(*Declarations(camera_calib_guiDialog)
        wxCheckBox* cbNormalize;
        wxTextCtrl* edLengthX;
        wxNotebook* Notebook1;
        wxButton* btnSave;
        wxButton* btnAbout;
        wxStaticText* StaticText2;
        wxButton* btnClose;
        wxButton* btnRunCalib;
        wxScrolledWindow* ScrolledWindow3;
        wxButton* Button1;
        wxTextCtrl* edLengthY;
        wxSpinCtrl* edSizeY;
        wxStaticText* StaticText1;
        wxTextCtrl* txtLog;
        wxStaticText* StaticText3;
        wxButton* Button2;
        wxScrolledWindow* ScrolledWindow2;
        wxSpinCtrl* edSizeX;
        wxListBox* lbFiles;
        wxStaticBitmap* bmpRectified;
        wxStaticBitmap* bmpOriginal;
        wxStaticText* StaticText4;
        wxButton* btnManualRect;
        //*)

        DECLARE_EVENT_TABLE()

		void updateListOfImages();

		// Shows the image selected in the listbox:
		void refreshDisplayedImage();

		// Shows a 3D view of the cams.
		void show3Dview();

		void clearListImages();

		mrpt::gui::CDisplayWindow3DPtr		win3D;

};


#ifdef wxUSE_UNICODE
#define _U(x) wxString((x),wxConvUTF8)
#define _UU(x,y) wxString((x),y)
#else
#define _U(x) (x)
#define _UU(x,y) (x)
#endif


#endif // CAMERA_CALIB_GUIMAIN_H
