/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2009  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
// Cam.h: interface for the CCam class.
//

#ifndef CAM_H_INCLUDED
#define CAM_H_INCLUDED

#include <highgui.h>

class CCam
{
public:
	CCam();
	virtual ~CCam();

	void open();
	void open(int index);
	void open(const char* file);
	void close();

	bool isOpen();

	IplImage *getFrame();

	CvCapture *getCapture();

	double getPosMSec();
	double getPosFrames();
	double getPosAVIRatio();
	double getWidth();
	double getHeight();
	double getFPS();
	double getFourCC();
	double getFrameCount();

	void setPosMSec(double value);
	void setPosFrames(double value);
	void setPosAVIRatio(double value);
	void setWidth(double value);
	void setHeight(double value);
	void setFPS(double value);
	void setFourCC(double value);
	void setFrameCount(double value);

    void  openVideoFormatDlg();
    void  openVideoSourceDlg();

private:
	CvCapture *capture;
};

#endif // CAM_H_INCLUDED
