/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2009  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */

#include <mrpt/precomp_core.h>  // Only for precomp. headers, include all libmrpt-core headers.

#include <mrpt/math/CMatrixTemplate.h>

using std::string;
using std::cout;
using std::endl;
using namespace mrpt;
using namespace mrpt::math;
using namespace mrpt::utils;

/** Dump matrix in matlab format:
 */
/*template <class T>
std::string CMatrixTemplate<T>::inMatlabFormat() const
{
	std::stringstream  s;

	s << "[";
	s << std::scientific;
	for (size_t i=0;i<m_Rows;i++)
	{
		for (size_t j=0;j<m_Cols;j++)
			s << m_Val[i][j] << " ";

		if (i<m_Rows-1)	s << ";";
	}
	s << "]";

	return s.str();
}

// Template instantiations:
// int, long, unsinged int, unsigned long, float, double, long double
template std::string CMatrixTemplate<int>::inMatlabFormat() const;
template std::string CMatrixTemplate<long>::inMatlabFormat() const;
template std::string CMatrixTemplate<unsigned int>::inMatlabFormat() const;
template std::string CMatrixTemplate<unsigned long>::inMatlabFormat() const;
template std::string CMatrixTemplate<float>::inMatlabFormat() const;
template std::string CMatrixTemplate<double>::inMatlabFormat() const;
#ifdef HAVE_LONG_DOUBLE
template std::string CMatrixTemplate<long double>::inMatlabFormat() const;
#endif
*/


/** Read a matrix from a string in Matlab-like format: "[1 0 2; 0 4 -1]"
  *  The string must start with '[' and end with ']'. Rows are separated by semicolons ';' and
  *  columns in each row by one or more whitespaces ' ' or tabs.
  *
  * This format is also used for CConfigFile::read_matrix.
  *
  * \return true on success. false if the string is malformed, and then the matrix will be resized to 0x0.
  * \sa CConfigFile::read_matrix
  */
/*template<class T>
bool CMatrixTemplate<T>::fromMatlabStringFormat(const std::string &s)
{
	this->setSize(0,0);

	// Look for starting "[".
	size_t  ini = s.find_first_not_of(" \t");
	if (ini==string::npos || s[ini]!='[') return false;

	size_t  end = s.find_last_not_of(" \t");
	if (end==string::npos || s[end]!=']') return false;

	if (ini>end) return false;

	std::vector<T> lstElements;

	size_t i = ini+1;
	size_t nRow = 0;

	while (i<end)
	{
		// Extract one row:
		size_t end_row = s.find_first_of(";]",i);
		if (end_row==string::npos) { setSize(0,0); return false; }

		// We have one row in s[ i : (end_row-1) ]
		std::stringstream  ss (s.substr(i, end_row-i ));
		lstElements.clear();
		try
		{
			while (!ss.eof())
			{
				T val;
				ss >> val;
				if (ss.bad() || ss.fail()) break;
				lstElements.push_back(val);
			}
		} catch (...) { }  // end of line

		// Empty row? Only for the first row, then this is an empty matrix:
		if (lstElements.empty())
		{
			if (nRow>0) {  setSize(0,0); return false; }
			// Else, this may be an empty matrix... if there is no next row, we'll return with a (0,0) matrix
		}
		else
		{
			const size_t N = lstElements.size();

			// Check valid width:
			if (nRow>0 && m_Cols!=N)  {  setSize(0,0); return false; }  // All rows must have the same width

			// Append to the matrix:
			realloc( nRow+1,N );

			for (size_t q=0;q<N;q++)
				m_Val[nRow][q] = lstElements[q];

			// Go for the next row:
			nRow++;
		}

		i = end_row+1;
	}

	return true; // Ok
}


// Template instantiations:
// int, long, unsinged int, unsigned long, float, double, long double
template bool CMatrixTemplate<int>::fromMatlabStringFormat(const std::string &s);
template bool CMatrixTemplate<unsigned int>::fromMatlabStringFormat(const std::string &s);
template bool CMatrixTemplate<long>::fromMatlabStringFormat(const std::string &s);
template bool CMatrixTemplate<unsigned long>::fromMatlabStringFormat(const std::string &s);
template bool CMatrixTemplate<float>::fromMatlabStringFormat(const std::string &s);
template bool CMatrixTemplate<double>::fromMatlabStringFormat(const std::string &s);
#ifdef HAVE_LONG_DOUBLE
template bool CMatrixTemplate<long double>::fromMatlabStringFormat(const std::string &s);
#endif

*/
