/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2009  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */

#include <mrpt/precomp_core.h>  // Only for precomp. headers, include all libmrpt-core headers.


#include <mrpt/opengl/CAxis.h>

#include "opengl_internals.h"


using namespace mrpt;
using namespace mrpt::opengl;
using namespace mrpt::system;
using namespace mrpt::utils;
using namespace std;

IMPLEMENTS_SERIALIZABLE( CAxis, CRenderizable, mrpt::opengl )


void   CAxis::render() const
{
#if MRPT_HAS_OPENGL_GLUT
	MRPT_TRY_START;

	glEnable (GL_BLEND);
	checkOpenGLError();
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	checkOpenGLError();

	ASSERT_(m_frecuency>=0);

    glLineWidth(m_lineWidth);
	checkOpenGLError();

    glBegin( GL_LINES );

    glColor4f( m_color_R,m_color_G,m_color_B,m_color_A );
	//X axis
	glVertex3f( m_xmin, 0.0f, 0.0f );
    glVertex3f( m_xmax, 0.0f, 0.0f );
	//Y axis
	glVertex3f( 0.0f, m_ymin, 0.0f );
    glVertex3f( 0.0f, m_ymax, 0.0f);
	//Z axis
	glVertex3f( 0.0f, 0.0f, m_zmin );
    glVertex3f( 0.0f, 0.0f, m_zmax );

	glEnd();
	checkOpenGLError();

    glLineWidth(1.0f);
	checkOpenGLError();

	glDisable (GL_BLEND);
	checkOpenGLError();

	/**********Si marks pintamos las coordenadas************/
	if (m_marks ==true)
	{
		//prepareFontLists();
		glDisable(GL_DEPTH_TEST);
		char n[50];

		for (float i = m_xmin ; i<= m_xmax ; i = i + m_frecuency)
		{
			os::sprintf(n,50,"%.02f",i);
			glRasterPos3f(i,0.0f,0.05f);
			renderTextBitmap(n, GLUT_BITMAP_TIMES_ROMAN_10);
		}
		for (float j = m_ymin ; j<= m_ymax ; j = j + m_frecuency)
		{
			os::sprintf(n,50,"%.02f",j);
			glRasterPos3f(0.0f,j,0.05f);
			renderTextBitmap(n, GLUT_BITMAP_TIMES_ROMAN_10);
		}
		for (float k = m_zmin ; k<= m_zmax ; k = k + m_frecuency)
		{
			os::sprintf(n,50,"%.02f",k);
			glRasterPos3f(0.05f,0.0f,k);
			renderTextBitmap(n, GLUT_BITMAP_TIMES_ROMAN_10);
		}

		glEnable(GL_DEPTH_TEST);
	}

	MRPT_TRY_END;
/*******************************************************/
#endif
}

/*---------------------------------------------------------------
   Implements the writing to a CStream capability of
     CSerializable objects
  ---------------------------------------------------------------*/
void  CAxis::writeToStream(CStream &out,int *version) const
{

	if (version)
		*version = 0;
	else
	{
		writeToStreamRender(out);
		out << m_xmin << m_ymin << m_zmin;
		out << m_xmax << m_ymax << m_zmax;
		out << m_frecuency << m_lineWidth << m_marks;
	}
}

/*---------------------------------------------------------------
	Implements the reading from a CStream capability of
		CSerializable objects
  ---------------------------------------------------------------*/
void  CAxis::readFromStream(CStream &in,int version)
{
	switch(version)
	{
	case 0:
		{
			readFromStreamRender(in);
			in >> m_xmin >> m_ymin >> m_zmin;
			in >> m_xmax >> m_ymax >> m_zmax;
			in >> m_frecuency >> m_lineWidth >> m_marks;
		} break;
	default:
		MRPT_THROW_UNKNOWN_SERIALIZATION_VERSION(version)

	};
}

