/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2010  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */


/**************************************************************************
 Application: mono-slam

  - 2007:
	The first version of this application, the corresponding classes
	and config files were developed by Antonio J. Ortiz de Galisteo
	as part of his Master Thesis at the University of Malaga (2007).

  - Jan-May 2009:
	- mono-slam updated and integrated back into MRPT by M.A. Amiri Atashgah (MAAA)
	  at the University of Sharif Technology, Tehran, Iran (2009).
	- Application converted into a GUI program (Jose Luis Blanco).

 **************************************************************************/

#include <mrpt/core.h>
#include <mrpt/monoslam/CMonoSlam.h>
#include <mrpt/monoslam/CMonoSlamInterface.h>

using namespace std;
using namespace mrpt;
using namespace mrpt::vision;
using namespace mrpt::slam;
using namespace mrpt::poses;
using namespace mrpt::utils;
using namespace mrpt::system;
using namespace mrpt::monoslam;

CMonoSlamInterface*	g_p_interfaz;

int main(int argc, char **argv)
{
	try
	{
		printf(" mono-slam version 2.0 - Part of the MRPT\n");
		printf(" MRPT C++ Library: %s - BUILD DATE %s\n", MRPT_getVersion().c_str(), MRPT_getCompilationDate().c_str() );
		printf("-------------------------------------------------------------------\n");


		//// Process arguments:
		//if (argc<2)
		//{
		//	printf("Use: mono-slam <config_file>\n\nPress any key to exit...\n");
		//	os::getch();
		//	return -1;
		//}

		std::string		inic;

		if (argc==2)
		{
			inic = argv[1]; 
		}
		else
		{
			inic = "../../../../share/mrpt/config_files/mono-slam/monoSlam_demo_simulation_Davison.ini";
			//inic = "../../../../share/mrpt/config_files/mono-slam/monoSlam_demo_simulation.ini";
			//inic = "../../../../share/mrpt/config_files/mono-slam/monoSlam_demo_real_time.ini";
		}

		ASSERT_(fileExists(inic));

		CConfigFile			fich(inic);

		bool						sim_or_rob	= fich.read_bool("SIM","sim_or_rob",false);
		bool						verbose		= fich.read_bool("INTERFACE","verbose",false);
		bool						savedata	= fich.read_bool("INTERFACE","savedata",false);
		bool						plot2d		= fich.read_bool("INTERFACE","plot2D",false);
		bool						plot3d		= fich.read_bool("INTERFACE","plot3D",false);
		int							v1 = 0; //,		v2 = 0;
		CActionCollectionPtr  action;
		CSensoryFramePtr      observations;

		CTicTac						reloj;
		CMonoSlamInterface	interfaz(inic);
		g_p_interfaz = &interfaz;

		//std::cout<<"  0 --> EKF\n";
		//std::cout<<"  1 --> IEKF\n";
		//std::cout<<"  2 --> UKF\n";
		//std::cout<<"Select Tipo de filtro: ";
		//std::cin>>v2;
		//unsigned int				type=v2;

		// Modified by JLBC, Oct 2007.
		unsigned int KF_filter=0;
		MRPT_LOAD_CONFIG_VAR_NO_DEFAULT(KF_filter,int,  fich,"INITIAL");

		if (sim_or_rob == 0)  //Using rawlogs
		{
			//std::cout<<"\n"<<"Introducir frame inicial: ";
			//std::cin>>v1;

			size_t		rawlogEntry = 0;
			size_t		initial_image = 0;//455;//200;//400;////266					
			MRPT_LOAD_CONFIG_VAR_NO_DEFAULT(initial_image,int,  fich,"INITIAL");

			std::string	rawlog_file = fich.read_string("INITIAL","path_rawlog","NO RAWLOG FILE FOUND!!!\n");
			if (!mrpt::system::fileExists(rawlog_file))
				THROW_EXCEPTION_CUSTOM_MSG1("Rawlog file does not exist: %s",rawlog_file.c_str())

			// For externally stored images:
			// Set relative path for externally-stored images in rawlogs:
			string	rawlog_images_path = extractFileDirectory( rawlog_file );
			rawlog_images_path+="/Images";
			CImage::IMAGES_PATH_BASE = rawlog_images_path;		// Set it.


			CFileGZInputStream			rawlogFile(rawlog_file);
			ASSERT_( rawlogFile.fileOpenCorrectly() );

			cout<< "Using rawlog file: " << rawlog_file << endl;

			// Load pose change from the rawlog:
			// ----------------------------------------
			for (size_t q=0;q<=initial_image;q++)
				CRawlog::readActionObservationPair(rawlogFile,action,observations,rawlogEntry);

			// Do initialization with this first sensory-frame.
			if (observations)
				interfaz.initialize(*observations,KF_filter,plot2d,plot3d,verbose,savedata);

			/*else
			{
				std::cout<<"ERROR WHILE LOADING RAWLOG. TRYING TO LOAD BMP\n";
				CObservationImage	*im = new CObservationImage();
				os::sprintf(direccion,500,"%s\\img_left_%05d.bmp",dir_images.c_str(),initial_frame_number+rawlogEntry-1);
				im->image.loadFromFile(direccion);
				if ((im->image.getWidth()>1)&&(im->image.getHeight()>1))
				{
					observations = new CSensoryFrame();
					observations->push_back((CObservationImagePtr)im);
					std::cout<<"BMP loaded succesfully\n";
					interfaz.initialize(observations,KF_filter,plot2d,plot3d,verbose,savedata);
				}
				else
				{
					std::cout<<"ERROR LOADING BMP. FINISHING!!!";
					return 1;
				}
			}*/

			while (!os::kbhit())
			{
			    //for (size_t q=0;q<1;q++) //MAAA:Speed Control
				   CRawlog::readActionObservationPair(rawlogFile,action,observations,rawlogEntry);

				   
			   if(rawlogFile.checkEOF()){
			 	cout<<"[mono-slam] Rawlog EOF! " << endl;
				break;
			   }

				if (verbose)
					cout<<"[mono-slam] Rawlog-entry: " << rawlogEntry << endl;

 				reloj.Tic();
				interfaz.go_one_step(*action,*observations);

				//cout<<"\n [mono-slam] Press any key ... \n";
				//std::cin.get();

				if (verbose)
					cout<<endl << "[mono-slam] Estimated processing rate: "<< endl << 1.0/reloj.Tac() << " Hz\n\n";

 			}
		}
		else
		{
			// ---------------------------------------------------
			//
			// Real-time processing
			//
			// ---------------------------------------------------

			// Dummy "observations"...
			observations = CSensoryFrame::Create();
			action       = CActionCollection::Create();

			interfaz.initialize( *observations,KF_filter,plot2d,plot3d,verbose,savedata);

			//os::getch();

			while (!os::kbhit())
			{
				reloj.Tic();

				interfaz.go_one_step(*action, *observations );

				if (verbose)
					cout<<endl << "[mono-slam] Estimated processing rate: "<< endl << 1.0/reloj.Tac() << " Hz\n\n";
			}

		}

		//if(interfaz.m_savedatas)
		   interfaz.m_robotPath.saveToTextFile("./monoSlamOut/RobotPath.txt");

		return 0;
	}
	catch (std::exception &e)
	{
		std::cout << "MRPT exception: " << e.what() << std::endl;

		//if(interfaz.m_savedatas)
		   g_p_interfaz->m_robotPath.saveToTextFile("./monoSlamOut/RobotPath.txt");
		return 1;
	}
	catch (...)
	{
		printf("Untyped exception!!");
		return 1;
	}
}

