/*
 * base64.c
 *
 * This file is part of msmtp, an SMTP client.
 *
 * This code was adapted from GNU Anubis, version 3.6.2
 * Copyright (C) 2001, 2002 The Anubis Team.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   msmtp is released under the GPL with the additional exemption that
 *   compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h>
#include <string.h>
#include <errno.h>
extern int errno;

#include "merror.h"
#include "base64.h"


/*
 * base64enc()
 *
 * see base64.h
 */

merror_t base64enc(char *s, int src_len, char **dst)
{
    char b64chars[] = 
	"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    char *p;
    int x, y;
    
    if (!(*dst = malloc((4 * ((src_len + 2) / 3) + 1) * sizeof(char))))
    {
	return merror(BASE64_ENOMEM, "%s", strerror(errno));
    }
    
    p = *dst;
    while (src_len-- > 0)
    {
	x = *s++;
	*p++ = b64chars[(x >> 2) & 63];
	if (src_len-- <= 0) 
	{
	    *p++ = b64chars[(x << 4) & 63];
    	    *p++ = '=';
	    *p++ = '=';
    	    break;
	}
	y = *s++;
	*p++ = b64chars[((x << 4) | ((y >> 4) & 15)) & 63];
	if (src_len-- <= 0) 
	{
	    *p++ = b64chars[(y << 2) & 63];
	    *p++ = '=';
	    break;
	}
	x = *s++;
	*p++ = b64chars[((y << 2) | ((x >> 6) & 3)) & 63];
	*p++ = b64chars[x & 63];
    }
    *p = '\0';
    
    return merror(EOK, NULL);
}


/*
 * base64dec()
 *
 * see base64.h
 */

merror_t base64dec(char *src, char **dst, int *dst_len)
{
    int x, y;
    char *p;
    unsigned char b64_decode[] =
    {
	255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
	255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
	255,255,255,255,255,255,255,255,255,255,255, 62,255,255,255, 63,
	 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,255,255,255,255,255,255,
	255,  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14,
	 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25,255,255,255,255,255,
	255, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
	 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51,255,255,255,255,255
    };
    
    if (!(*dst = malloc((3 * (strlen(src) / 4) + 1) * sizeof(char))))
    {
	return merror(BASE64_ENOMEM, "%s", strerror(errno));
    }
    p = *dst;
    
    while ((x = (int)((unsigned char)(*src++))) != 0)
    {
	if (x > 127 || (x = b64_decode[x]) == 255)
	{
	    goto error_exit;
	}
	if ((y = (int)((unsigned char)(*src++))) == 0
		|| (y = b64_decode[y]) == 255)
	{
	    goto error_exit;
	}
	*p++ = (char)(x << 2) | (y >> 4);
	if ((x = (int)((unsigned char)(*src++))) == '=') 
	{
	    if (*src++ != '=' || *src != 0)
	    {
		goto error_exit;
	    }
	}
	else 
	{
	    if (x > 127 || (x = b64_decode[x]) == 255)
	    {
		goto error_exit;
	    }
	    *p++ = (char)(y << 4) | (x >> 2);
	    if ((y = (int)((unsigned char)(*src++))) == '=') 
	    {
		if (*src != '\0')
		{
		    goto error_exit;
		}
	    }
	    else 
	    {
		if (y > 127 || (y = b64_decode[y]) == 255)
		{
		    goto error_exit;
		}
		*p++ = (char)(x << 6) | y;
	    }
	}
    }
    *p = '\0';
    *dst_len = p - *dst;
    return merror(EOK, NULL);

error_exit:
    free(*dst);
    return merror(BASE64_EINVAL, "string is not in BASE64 format");
}
