/*
 * base64.h
 *
 * This file is part of msmtp, an SMTP client.
 *
 * This code was adapted from GNU Anubis, version 3.6.2
 * Copyright (C) 2001, 2002 The Anubis Team.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   msmtp is released under the GPL with the additional exemption that
 *   compiling, linking, and/or using OpenSSL is allowed.
 */

#ifndef BASE64_H
#define BASE64_H

#include "merror.h"

#define BASE64_ENOMEM	1	/* Cannot allocate memory */
#define BASE64_EINVAL	2	/* Invalid data */

/*
 * base64enc()
 *
 * Encode the data in 'src' (which if of length 'src_len') in BASE64. A
 * pointer to the resulting string will be stored in 'dst'. It should be 
 * freed when not used anymore.
 * Used error codes: BASE64_ENOMEM
 */
merror_t base64enc(char *src, int src_len, char **dst);

/*
 * base64dec()
 *
 * Decode the BASE64 encoded string 'src'. A pointer to the decoded data is
 * stored in 'dst'. It should be freed when not used anymore. The length of 
 * the decoded data is stored in 'dst_len'.
 * Used error codes: BASE64_ENOMEM, BASE64_EINVAL
 */
merror_t base64dec(char *src, char **dst, int *dst_len);

#endif
