/*
 * md5_apps.h
 *
 * This file is part of msmtp, an SMTP client.
 *
 * This code was adapted from GNU Anubis, version 3.6.2
 * Copyright (C) 2001, 2002 The Anubis Team.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   msmtp is released under the GPL with the additional exemption that
 *   compiling, linking, and/or using OpenSSL is allowed.
 */

#ifndef MD5_APPS_H
#define MD5_APPS_H

#include "merror.h"

#define MD5_ELIBFAILED	1	/* The underlying library failed */

/*
 * md5_hmac() -- RFC 2104
 *
 * Writes MD5 digest of 'secret', 'challenge' to 'digest', which must be
 * 16 unsigned chars long. 'secret' and 'challenge' must not be NULL!
 * Used error codes: MD5_ELIBFAILED
 */
merror_t md5_hmac(char *secret, size_t secret_len,
	char *challenge, size_t challenge_len,
	unsigned char *digest);

#endif
